/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteDescription;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DescriptionSection
extends PDESection {
    private FormEntry fURLEntry;
    private FormEntry fDescEntry;

    public DescriptionSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.getSection().setText(PDEUIMessages.SiteEditor_DescriptionSection_header);
        this.getSection().setDescription(PDEUIMessages.SiteEditor_DescriptionSection_desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.fURLEntry.commit();
        this.fDescEntry.commit();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        this.fURLEntry = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_DescriptionSection_urlLabel, null, false);
        this.fURLEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                DescriptionSection.this.setDescriptionURL(text.getValue());
            }
        });
        this.fURLEntry.setEditable(this.isEditable());
        this.fDescEntry = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_DescriptionSection_descLabel, 66);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 64;
        this.fDescEntry.getText().setLayoutData((Object)gd);
        this.fDescEntry.getLabel().setLayoutData((Object)new GridData(2));
        this.fDescEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                DescriptionSection.this.setDescriptionText(text.getValue());
            }
        });
        this.fDescEntry.setEditable(this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private void setDescriptionURL(String text) {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        ISite site = model.getSite();
        ISiteDescription description = site.getDescription();
        boolean defined = false;
        if (description == null) {
            description = model.getFactory().createDescription(null);
            defined = true;
        }
        try {
            description.setURL(text);
            if (defined) {
                site.setDescription(description);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setDescriptionText(String text) {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        ISite site = model.getSite();
        ISiteDescription description = site.getDescription();
        boolean defined = false;
        if (description == null) {
            description = model.getFactory().createDescription(null);
            defined = true;
        }
        try {
            description.setText(text);
            if (defined) {
                site.setDescription(description);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        this.refresh();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    public void setFocus() {
        if (this.fURLEntry != null) {
            this.fURLEntry.getText().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    public void refresh() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        ISite site = model.getSite();
        this.setIfDefined(this.fURLEntry, site.getDescription() != null ? site.getDescription().getURL() : null);
        this.setIfDefined(this.fDescEntry, site.getDescription() != null ? site.getDescription().getText() : null);
        super.refresh();
    }

    public void cancelEdit() {
        this.fURLEntry.cancelEdit();
        this.fDescEntry.cancelEdit();
        super.cancelEdit();
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

