/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class FilteredSchemaAttributeSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.pde.ui.dialogs.FilteredSchemaAttributeSelectionDialog";
    private static final String S_OPTIONAL_ATTRIBUTES = "showOptionalAttributes";
    private Action optionalAttributesAction = new ShowOptionalAttributesAction();
    private OptionalAttributesFilter optionalAttributesFilter = new OptionalAttributesFilter();
    private final SchemaListLabelProvider listLabelProvider = new SchemaListLabelProvider();
    private final SchemaDetailsLabelProvider detailsLabelProvider = new SchemaDetailsLabelProvider();

    public FilteredSchemaAttributeSelectionDialog(Shell shell) {
        super(shell, false);
        this.setTitle(PDEUIMessages.FilteredSchemaAttributeSelectionDialog_title);
        this.setMessage(PDEUIMessages.FilteredSchemaAttributeSelectionDialog_message);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.setListLabelProvider((ILabelProvider)this.listLabelProvider);
        this.setListSelectionLabelDecorator(this.listLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)this.detailsLabelProvider);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new SchemaItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        IPluginModelBase[] models = PluginRegistry.getActiveModels();
        SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
        progressMonitor.beginTask(PDEUIMessages.FilteredSchemaAttributeSelectionDialog_searching, models.length);
        int i = 0;
        while (i < models.length) {
            IPluginExtensionPoint[] points = models[i].getPluginBase().getExtensionPoints();
            int j = 0;
            while (j < points.length) {
                String pointID = IdUtil.getFullId((IPluginExtensionPoint)points[j], (IPluginModelBase)models[i]);
                ISchema schema = registry.getSchema(pointID);
                if (schema != null) {
                    ISchemaElement[] elements = schema.getElements();
                    int k = 0;
                    while (k < elements.length) {
                        ISchemaElement element = elements[k];
                        ISchemaAttribute[] attributes = element.getAttributes();
                        int l = 0;
                        while (l < attributes.length) {
                            ISchemaAttribute attribute = attributes[l];
                            if (attribute.getKind() == 0 && ISchemaAttribute.TYPES[1].equals(attribute.getType().getName()) && !attribute.isTranslatable()) {
                                contentProvider.add((Object)attribute, itemsFilter);
                            }
                            ++l;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            progressMonitor.worked(1);
            ++i;
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof ISchemaAttribute) {
            ISchemaAttribute attribute = (ISchemaAttribute)item;
            return attribute.getName();
        }
        return null;
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.optionalAttributesAction);
    }

    protected Comparator getItemsComparator() {
        return new SchemaComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.pde.ui", 0, "", null);
    }

    protected void restoreDialog(IDialogSettings settings) {
        super.restoreDialog(settings);
        if (settings.get(S_OPTIONAL_ATTRIBUTES) != null) {
            boolean state = settings.getBoolean(S_OPTIONAL_ATTRIBUTES);
            this.optionalAttributesAction.setChecked(state);
        }
        this.addListFilter(this.optionalAttributesFilter);
        this.applyFilter();
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        settings.put(S_OPTIONAL_ATTRIBUTES, this.optionalAttributesAction.isChecked());
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    private String getQualifiedName(ISchemaAttribute attribute) {
        ISchemaObject object = attribute.getParent();
        ISchema schema = attribute.getSchema();
        return String.valueOf(attribute.getName()) + " - " + object.getName() + " [" + schema.getName() + "]";
    }

    private class OptionalAttributesFilter
    extends ViewerFilter {
        private boolean enabled = true;

        private OptionalAttributesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.enabled) {
                return true;
            }
            if (element instanceof ISchemaAttribute) {
                ISchemaAttribute attribute = (ISchemaAttribute)element;
                return attribute.getUse() != 0;
            }
            return true;
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }
    }

    private class SchemaComparator
    implements Comparator {
        private SchemaComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return 0;
        }
    }

    private class SchemaDetailsLabelProvider
    extends LabelProvider {
        private SchemaDetailsLabelProvider() {
        }

        public Image getImage(Object element) {
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXT_POINT_OBJ);
        }

        public String getText(Object element) {
            if (element instanceof ISchemaAttribute) {
                ISchemaAttribute attribute = (ISchemaAttribute)element;
                ISchema schema = attribute.getSchema();
                return String.valueOf(schema.getPointId()) + ' ' + '(' + schema.getPluginId() + ')';
            }
            return super.getText(element);
        }
    }

    private class SchemaItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private SchemaItemsFilter() {
            super((FilteredItemsSelectionDialog)FilteredSchemaAttributeSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            if (item instanceof ISchemaAttribute) {
                ISchemaAttribute attribute = (ISchemaAttribute)item;
                ISchemaObject object = attribute.getParent();
                ISchema schema = attribute.getSchema();
                String id = FilteredSchemaAttributeSelectionDialog.this.getQualifiedName(attribute);
                return this.matches(attribute.getName()) || this.matches(object.getName()) || this.matches(id) || this.matches(schema.getName());
            }
            return false;
        }
    }

    private class SchemaListLabelProvider
    extends LabelProvider
    implements ILabelDecorator {
        private SchemaListLabelProvider() {
        }

        public Image getImage(Object element) {
            return PDEPlugin.getDefault().getLabelProvider().getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ISchemaAttribute) {
                ISchemaObject object;
                ISchemaAttribute attribute = (ISchemaAttribute)element;
                if (FilteredSchemaAttributeSelectionDialog.this.isDuplicateElement(element) && (object = attribute.getParent()) != null) {
                    return FilteredSchemaAttributeSelectionDialog.this.getQualifiedName(attribute);
                }
            }
            return PDEPlugin.getDefault().getLabelProvider().getText(element);
        }

        public Image decorateImage(Image image, Object element) {
            return image;
        }

        public String decorateText(String text, Object element) {
            ISchemaAttribute attribute;
            ISchemaObject object;
            if (element instanceof ISchemaAttribute && (object = (attribute = (ISchemaAttribute)element).getParent()) != null && !FilteredSchemaAttributeSelectionDialog.this.isDuplicateElement(element)) {
                return FilteredSchemaAttributeSelectionDialog.this.getQualifiedName(attribute);
            }
            return text;
        }
    }

    private class ShowOptionalAttributesAction
    extends Action {
        public ShowOptionalAttributesAction() {
            super(PDEUIMessages.FilteredSchemaAttributeSelectionDialog_showOptionalAttributes, 2);
            this.setChecked(true);
        }

        public void run() {
            FilteredSchemaAttributeSelectionDialog.this.optionalAttributesFilter.setEnabled(this.isChecked());
            FilteredSchemaAttributeSelectionDialog.this.scheduleRefresh();
        }
    }
}

