/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductModel;
import org.eclipse.pde.internal.core.product.WorkspaceProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.UTF8InputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class ProductInputContext
extends UTF8InputContext {
    public static final String CONTEXT_ID = "product-context";

    public ProductInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        WorkspaceProductModel model = null;
        if (input instanceof IStorageEditorInput) {
            try {
                if (input instanceof IFileEditorInput) {
                    IFile file = ((IFileEditorInput)input).getFile();
                    model = new WorkspaceProductModel(file, true);
                    model.load();
                } else if (input instanceof IStorageEditorInput) {
                    BufferedInputStream is = new BufferedInputStream(((IStorageEditorInput)input).getStorage().getContents());
                    model = new ProductModel();
                    model.load((InputStream)is, false);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
                return null;
            }
        }
        return model;
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
    }

    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            editableModel.save(writer);
            writer.flush();
            swriter.close();
            doc.set(swriter.toString());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    public void doRevert() {
        this.fEditOperations.clear();
        IProductModel model = (IProductModel)this.getModel();
        try {
            InputStream is = ((IFile)model.getUnderlyingResource()).getContents();
            model.reload(is, true);
            this.getEditor().doRevert();
        }
        catch (CoreException coreException) {}
    }

    protected String getPartitionName() {
        return "___prod_partition";
    }
}

