/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.ctxhelp;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.text.ctxhelp.CtxHelpModel;
import org.eclipse.pde.internal.core.text.ctxhelp.CtxHelpObject;
import org.eclipse.pde.internal.core.text.ctxhelp.CtxHelpTopic;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.ctxhelp.CtxHelpFormOutlinePage;
import org.eclipse.pde.internal.ui.editor.ctxhelp.CtxHelpInputContext;
import org.eclipse.pde.internal.ui.editor.ctxhelp.CtxHelpInputContextManager;
import org.eclipse.pde.internal.ui.editor.ctxhelp.CtxHelpPage;
import org.eclipse.pde.internal.ui.editor.ctxhelp.CtxHelpSourcePage;
import org.eclipse.pde.internal.ui.wizards.ctxhelp.RegisterCtxHelpWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class CtxHelpEditor
extends MultiSourceEditor {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected String getEditorID() {
        return "org.eclipse.pde.ui.ctxHelpEditor";
    }

    public Object getAdapter(Class adapter) {
        if (this.isShowInApplicable()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return this.getShowInSource();
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                return this.getShowInTargetList();
            }
        }
        return super.getAdapter(adapter);
    }

    private boolean isShowInApplicable() {
        if (this.getSelection().isEmpty()) {
            return false;
        }
        if (this.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof CtxHelpTopic) || ((CtxHelpTopic)obj).getLocation() == null) continue;
                return true;
            }
        }
        return false;
    }

    private IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                StructuredSelection resources;
                ArrayList<IResource> resourceList = new ArrayList<IResource>();
                IStructuredSelection selection = (IStructuredSelection)CtxHelpEditor.this.getSelection();
                if (selection.isEmpty()) {
                    resources = null;
                } else {
                    IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
                    Iterator iter = selection.iterator();
                    while (iter.hasNext()) {
                        CtxHelpModel model;
                        IPath pluginPath;
                        IResource resource;
                        IPath path;
                        Object obj = iter.next();
                        if (!(obj instanceof CtxHelpTopic) || (path = ((CtxHelpTopic)obj).getLocation()) == null || path.isEmpty() || (resource = root.findMember((pluginPath = (model = (CtxHelpModel)CtxHelpEditor.this.getAggregateModel()).getUnderlyingResource().getProject().getFullPath()).append(path))) == null) continue;
                        resourceList.add(resource);
                    }
                    resources = new StructuredSelection(resourceList);
                }
                return new ShowInContext(null, resources);
            }
        };
    }

    private IShowInTargetList getShowInTargetList() {
        return new IShowInTargetList(){

            public String[] getShowInTargetIds() {
                return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
            }
        };
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public String getContextIDForSaveAs() {
        return "ctxhelp-context";
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new CtxHelpPage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("ctxhelp-context");
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new CtxHelpFormOutlinePage(this);
    }

    protected InputContextManager createInputContextManager() {
        return new CtxHelpInputContextManager(this);
    }

    protected void createResourceContexts(InputContextManager contexts, IFileEditorInput input) {
        contexts.putContext((IEditorInput)input, new CtxHelpInputContext(this, (IEditorInput)input, true));
        contexts.monitorFile(input.getFile());
    }

    protected void createStorageContexts(InputContextManager contexts, IStorageEditorInput input) {
        contexts.putContext((IEditorInput)input, new CtxHelpInputContext(this, (IEditorInput)input, true));
    }

    protected void createSystemFileContexts(InputContextManager contexts, SystemFileEditorInput input) {
        File file;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (File)input.getAdapter(clazz)) != null) {
            SystemFileEditorInput in = new SystemFileEditorInput(file);
            contexts.putContext((IEditorInput)in, new CtxHelpInputContext(this, (IEditorInput)in, true));
        }
    }

    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    protected InputContext getInputContext(Object object) {
        return this.fInputContextManager.findContext("ctxhelp-context");
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return true;
    }

    public ISelection getSelection() {
        IFormPage formPage = this.getActivePageInstance();
        if (formPage != null && formPage instanceof CtxHelpPage) {
            return ((CtxHelpPage)formPage).getSelection();
        }
        return super.getSelection();
    }

    public boolean canCut(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Iterator iter = sel.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof CtxHelpObject) || !((CtxHelpObject)obj).canBeRemoved()) continue;
                return this.canCopy(selection);
            }
        }
        return false;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new CtxHelpSourcePage(editor, title, name);
    }

    public void contributeToToolbar(IToolBarManager manager) {
        if (this.getAggregateModel().isEditable()) {
            manager.add((IContributionItem)new ControlContribution("Register"){

                protected Control createControl(Composite parent) {
                    ImageHyperlink fImageHyperlinkRegisterTOC = new ImageHyperlink(parent, 0);
                    fImageHyperlinkRegisterTOC.setText(PDEUIMessages.CtxHelpEditor_0);
                    fImageHyperlinkRegisterTOC.setUnderlined(true);
                    fImageHyperlinkRegisterTOC.setForeground(CtxHelpEditor.this.getToolkit().getHyperlinkGroup().getForeground());
                    fImageHyperlinkRegisterTOC.addHyperlinkListener(new IHyperlinkListener(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void linkActivated(HyperlinkEvent e) {
                            CtxHelpEditor.access$0(3.access$0(this.this$1));
                        }

                        public void linkEntered(HyperlinkEvent e) {
                            ((ImageHyperlink)e.getSource()).setForeground(3.access$0(this.this$1).getToolkit().getHyperlinkGroup().getActiveForeground());
                            3.access$0(this.this$1).getEditorSite().getActionBars().getStatusLineManager().setMessage(PDEUIMessages.CtxHelpEditor_0);
                        }

                        public void linkExited(HyperlinkEvent e) {
                            ((ImageHyperlink)e.getSource()).setForeground(3.access$0(this.this$1).getToolkit().getHyperlinkGroup().getForeground());
                            3.access$0(this.this$1).getEditorSite().getActionBars().getStatusLineManager().setMessage(null);
                        }
                    });
                    return fImageHyperlinkRegisterTOC;
                }

                static /* synthetic */ CtxHelpEditor access$0(3 var0) {
                    return var0.CtxHelpEditor.this;
                }
            });
        }
    }

    private void handleRegisterCtxHelpFile() {
        RegisterCtxHelpWizard wizard = new RegisterCtxHelpWizard((IModel)this.getAggregateModel());
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(400, 250);
        dialog.open();
    }

    static /* synthetic */ void access$0(CtxHelpEditor ctxHelpEditor) {
        ctxHelpEditor.handleRegisterCtxHelpFile();
    }
}

