/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.simple.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSConditionalSubItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSRepeatedSubItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItemObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class SimpleCSRemoveSubStepAction
extends Action {
    private ISimpleCSSubItemObject fSubItem;
    private ISimpleCSObject fObjectToSelect;

    public SimpleCSRemoveSubStepAction() {
        this.setText(PDEUIMessages.SimpleCSRemoveSubStepAction_0);
        this.fSubItem = null;
        this.fObjectToSelect = null;
    }

    public void setSubItem(ISimpleCSSubItemObject subitem) {
        this.fSubItem = subitem;
    }

    public void run() {
        if (this.fSubItem != null) {
            ISimpleCSObject parent = this.fSubItem.getParent();
            if (parent.getType() == 6) {
                ISimpleCSItem item = (ISimpleCSItem)parent;
                this.determineItemToSelect(item);
                item.removeSubItem(this.fSubItem);
            } else if (parent.getType() == 9 && this.fSubItem.getType() == 10) {
                ISimpleCSRepeatedSubItem subitem = (ISimpleCSRepeatedSubItem)parent;
                this.determineItemToSelect((ISimpleCSObject)subitem);
                subitem.setSubItem(null);
            } else if (parent.getType() == 3 && this.fSubItem.getType() == 10) {
                ISimpleCSConditionalSubItem subitem = (ISimpleCSConditionalSubItem)parent;
                this.determineItemToSelect((ISimpleCSObject)subitem);
                subitem.removeSubItem((ISimpleCSSubItem)this.fSubItem);
            }
        }
    }

    private void determineItemToSelect(ISimpleCSItem item) {
        this.fObjectToSelect = item.getNextSibling(this.fSubItem);
        if (this.fObjectToSelect == null) {
            this.fObjectToSelect = item.getPreviousSibling(this.fSubItem);
            if (this.fObjectToSelect == null) {
                this.fObjectToSelect = item;
            }
        }
    }

    private void determineItemToSelect(ISimpleCSObject object) {
        this.fObjectToSelect = object;
    }

    public ISimpleCSObject getObjectToSelect() {
        return this.fObjectToSelect;
    }
}

