/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.internal.ui.compare.PluginStructureCreator;
import org.eclipse.swt.widgets.Composite;

public class PluginStructureViewer
extends StructureDiffViewer {
    public PluginStructureViewer(Composite parent, CompareConfiguration config) {
        super(parent, config);
        this.setStructureCreator((IStructureCreator)new PluginStructureCreator());
        this.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof DiffNode) {
                    if (e2 instanceof DiffNode) {
                        ITypedElement e1Element = ((DiffNode)e1).getAncestor();
                        ITypedElement e2Element = ((DiffNode)e2).getAncestor();
                        if (!(e1Element instanceof DocumentRangeNode)) {
                            e1Element = ((DiffNode)e1).getLeft();
                        }
                        if (!(e2Element instanceof DocumentRangeNode)) {
                            e2Element = ((DiffNode)e2).getLeft();
                        }
                        if (e1Element instanceof DocumentRangeNode && e2Element instanceof DocumentRangeNode) {
                            float e2off;
                            float e1off = this.getRelativeOffset((DocumentRangeNode)e1Element);
                            return e1off - (e2off = this.getRelativeOffset((DocumentRangeNode)e2Element)) < 0.0f ? -1 : 1;
                        }
                        return 0;
                    }
                    return -1;
                }
                return 1;
            }

            private float getRelativeOffset(DocumentRangeNode node) {
                float absoluteOffset = node.getRange().getOffset();
                float documentLength = node.getDocument().getLength();
                return absoluteOffset / documentLength;
            }
        });
    }
}

