/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.wizard;

import java.util.Iterator;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;

public class WizardPageSupport {
    private WizardPage wizardPage;
    private DataBindingContext dbc;
    private AggregateValidationStatus aggregateStatus;
    private boolean uiChanged = false;
    private IChangeListener uiChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            WizardPageSupport.this.handleUIChanged();
        }
    };
    private IListChangeListener validationStatusProvidersListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] differences = diff.getDifferences();
            int i = 0;
            while (i < differences.length) {
                Iterator it;
                ListDiffEntry listDiffEntry = differences[i];
                ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)listDiffEntry.getElement();
                IObservableList targets = validationStatusProvider.getTargets();
                if (listDiffEntry.isAddition()) {
                    targets.addListChangeListener(WizardPageSupport.this.validationStatusProviderTargetsListener);
                    it = targets.iterator();
                    while (it.hasNext()) {
                        ((IObservable)it.next()).addChangeListener(WizardPageSupport.this.uiChangeListener);
                    }
                } else {
                    targets.removeListChangeListener(WizardPageSupport.this.validationStatusProviderTargetsListener);
                    it = targets.iterator();
                    while (it.hasNext()) {
                        ((IObservable)it.next()).removeChangeListener(WizardPageSupport.this.uiChangeListener);
                    }
                }
                ++i;
            }
        }
    };
    private IListChangeListener validationStatusProviderTargetsListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] differences = diff.getDifferences();
            int i = 0;
            while (i < differences.length) {
                ListDiffEntry listDiffEntry = differences[i];
                IObservable target = (IObservable)listDiffEntry.getElement();
                if (listDiffEntry.isAddition()) {
                    target.addChangeListener(WizardPageSupport.this.uiChangeListener);
                } else {
                    target.removeChangeListener(WizardPageSupport.this.uiChangeListener);
                }
                ++i;
            }
        }
    };
    private IStatus currentStatus;

    public static WizardPageSupport create(WizardPage wizardPage, DataBindingContext dbc) {
        return new WizardPageSupport(wizardPage, dbc);
    }

    private WizardPageSupport(WizardPage wizardPage, DataBindingContext dbc) {
        this.wizardPage = wizardPage;
        this.dbc = dbc;
        this.init();
    }

    protected void init() {
        this.aggregateStatus = new AggregateValidationStatus((IObservableCollection)this.dbc.getValidationStatusProviders(), 2);
        this.aggregateStatus.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                WizardPageSupport.this.currentStatus = (IStatus)event.diff.getNewValue();
                WizardPageSupport.this.handleStatusChanged();
            }
        });
        this.currentStatus = (IStatus)this.aggregateStatus.getValue();
        this.handleStatusChanged();
        this.dbc.getValidationStatusProviders().addListChangeListener(this.validationStatusProvidersListener);
        Iterator it = this.dbc.getValidationStatusProviders().iterator();
        while (it.hasNext()) {
            ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)it.next();
            IObservableList targets = validationStatusProvider.getTargets();
            targets.addListChangeListener(this.validationStatusProviderTargetsListener);
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                ((IObservable)iter.next()).addChangeListener(this.uiChangeListener);
            }
        }
    }

    protected void handleUIChanged() {
        this.uiChanged = true;
        if (this.currentStatus != null) {
            this.handleStatusChanged();
        }
        this.dbc.getValidationStatusProviders().removeListChangeListener(this.validationStatusProvidersListener);
        Iterator it = this.dbc.getValidationStatusProviders().iterator();
        while (it.hasNext()) {
            ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)it.next();
            IObservableList targets = validationStatusProvider.getTargets();
            targets.removeListChangeListener(this.validationStatusProviderTargetsListener);
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                ((IObservable)iter.next()).removeChangeListener(this.uiChangeListener);
            }
        }
    }

    protected void handleStatusChanged() {
        if (this.currentStatus != null && this.currentStatus.getSeverity() == 4) {
            this.wizardPage.setPageComplete(false);
            this.wizardPage.setMessage(null);
            this.wizardPage.setErrorMessage(this.uiChanged ? this.currentStatus.getMessage() : null);
        } else if (this.currentStatus != null && this.currentStatus.getSeverity() != 0) {
            int type;
            int severity = this.currentStatus.getSeverity();
            this.wizardPage.setPageComplete((severity & 8) != 0);
            switch (severity) {
                case 0: {
                    type = 0;
                    break;
                }
                case 8: {
                    type = 0;
                    break;
                }
                case 1: {
                    type = 1;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 4: {
                    type = 3;
                    break;
                }
                default: {
                    throw new AssertionFailedException("incomplete switch statement");
                }
            }
            this.wizardPage.setErrorMessage(null);
            this.wizardPage.setMessage(this.currentStatus.getMessage(), type);
        } else {
            this.wizardPage.setPageComplete(true);
            this.wizardPage.setMessage(null);
            this.wizardPage.setErrorMessage(null);
        }
    }

    public void dispose() {
        this.aggregateStatus.dispose();
        if (!this.uiChanged) {
            Iterator it = this.dbc.getValidationStatusProviders().iterator();
            while (it.hasNext()) {
                ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)it.next();
                IObservableList targets = validationStatusProvider.getTargets();
                targets.removeListChangeListener(this.validationStatusProviderTargetsListener);
                Iterator iter = targets.iterator();
                while (iter.hasNext()) {
                    ((IObservable)iter.next()).removeChangeListener(this.uiChangeListener);
                }
            }
            this.dbc.getValidationStatusProviders().removeListChangeListener(this.validationStatusProvidersListener);
        }
        this.aggregateStatus = null;
        this.dbc = null;
        this.uiChangeListener = null;
        this.validationStatusProvidersListener = null;
        this.validationStatusProviderTargetsListener = null;
        this.wizardPage = null;
    }
}

