/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.properties;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.properties.PropertiesMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class ApiFiltersPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private TreeViewer fViewer = null;
    private Button fRemoveButton;
    private IProject fProject = null;
    private ArrayList fChangeset = new ArrayList();
    private ArrayList fInputset = null;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808);
        SWTFactory.createWrapLabel(comp, PropertiesMessages.ApiFiltersPropertyPage_55, 2);
        Tree tree = new Tree(comp, 68354);
        GridData gd = new GridData(1808);
        gd.widthHint = 275;
        gd.heightHint = 300;
        tree.setLayoutData((Object)gd);
        this.fViewer = new TreeViewer(tree);
        this.fViewer.setAutoExpandLevel(2);
        this.fViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new FilterStoreLabelProvider());
        this.fViewer.setComparator((ViewerComparator)new ApiFilterComparator());
        this.fViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !ApiFiltersPropertyPage.this.fChangeset.contains(element);
            }
        });
        try {
            IApiFilterStore store = this.getFilterStore();
            if (store != null) {
                this.fInputset = new ArrayList<IResource>(Arrays.asList(store.getResources()));
                this.fViewer.setInput((Object)this.fInputset);
            }
        }
        catch (CoreException e) {
            ApiUIPlugin.log(e);
        }
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                ApiFiltersPropertyPage.this.fRemoveButton.setEnabled(ss.size() > 0);
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (ApiFiltersPropertyPage.this.fViewer.isExpandable(o)) {
                    ApiFiltersPropertyPage.this.fViewer.setExpandedState(o, !ApiFiltersPropertyPage.this.fViewer.getExpandedState(o));
                }
            }
        });
        Composite bcomp = SWTFactory.createComposite(comp, 1, 1, 1040, 0, 0);
        this.fRemoveButton = SWTFactory.createPushButton(bcomp, PropertiesMessages.ApiFiltersPropertyPage_57, null, 16384);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)ApiFiltersPropertyPage.this.fViewer.getSelection();
                HashSet deletions = ApiFiltersPropertyPage.this.collectDeletions(ss);
                if (deletions.size() > 0) {
                    ApiFiltersPropertyPage.this.fChangeset.addAll(deletions);
                    ApiFiltersPropertyPage.this.fViewer.remove(deletions.toArray());
                    ApiFiltersPropertyPage.this.fViewer.refresh();
                }
            }
        });
        this.fRemoveButton.setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IApiToolsHelpContextIds.APITOOLS_FILTERS_PROPERTY_PAGE);
        return comp;
    }

    private HashSet collectDeletions(IStructuredSelection selection) {
        HashSet<Object> filters = new HashSet<Object>();
        Object node = null;
        Object[] children = null;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            node = iter.next();
            if (node instanceof IResource) {
                children = ((TreeContentProvider)this.fViewer.getContentProvider()).getChildren(node);
                filters.addAll(Arrays.asList(children));
                this.fInputset.remove(node);
                continue;
            }
            filters.add(node);
        }
        return filters;
    }

    private IProject getProject() {
        if (this.fProject == null) {
            IAdaptable iAdaptable = this.getElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fProject = (IProject)iAdaptable.getAdapter((Class)clazz);
        }
        return this.fProject;
    }

    private IApiFilterStore getFilterStore() throws CoreException {
        IApiComponent component;
        IProject project = this.getProject();
        IApiFilterStore store = null;
        if (project != null && (component = ApiPlugin.getDefault().getApiProfileManager().getWorkspaceProfile().getApiComponent(project.getName())) != null) {
            return component.getFilterStore();
        }
        return store;
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            if (this.fChangeset.size() > 0) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IApiProblemFilter[] apiProblemFilters = this.fChangeset.toArray(new IApiProblemFilter[this.fChangeset.size()]);
                this.getFilterStore().removeFilters(apiProblemFilters);
                int i = 0;
                int max = apiProblemFilters.length;
                while (i < max) {
                    IResource resource;
                    IApiProblemFilter filter = apiProblemFilters[i];
                    IApiProblem apiProblem = filter.getUnderlyingProblem();
                    if (apiProblem != null && (resource = this.fProject.findMember(apiProblem.getResourcePath())) != null) {
                        resource.touch(null);
                    }
                    ++i;
                }
                if (!workspace.isAutoBuilding() && MessageDialog.openQuestion((Shell)this.getShell(), (String)PropertiesMessages.ApiFiltersPropertyPage_58, (String)MessageFormat.format((String)PropertiesMessages.ApiFiltersPropertyPage_59, (Object[])new String[]{this.fProject.getName()}))) {
                    Util.getBuildJob((IProject[])new IProject[]{this.fProject}, (int)10).schedule();
                }
            }
            this.fChangeset.clear();
        }
        catch (CoreException e) {
            ApiUIPlugin.log(e);
        }
        return super.performOk();
    }

    class ApiFilterComparator
    extends WorkbenchViewerComparator {
        ApiFilterComparator() {
        }

        public int category(Object element) {
            if (element instanceof IApiProblemFilter) {
                return ((IApiProblemFilter)element).getUnderlyingProblem().getCategory();
            }
            return -1;
        }
    }

    class FilterStoreLabelProvider
    extends LabelProvider {
        FilterStoreLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IApiProblemFilter) {
                IApiProblemFilter filter = (IApiProblemFilter)element;
                IApiProblem problem = filter.getUnderlyingProblem();
                String sid = ApiProblemFactory.getProblemSeverityId((IApiProblem)problem);
                if (sid == null) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                }
                int severity = ApiPlugin.getDefault().getSeverityLevel(sid, ApiFiltersPropertyPage.this.fProject);
                switch (severity) {
                    case 2: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    }
                    case 1: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    }
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
            if (element instanceof IResource) {
                IResource resource = (IResource)element;
                switch (resource.getType()) {
                    case 1: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                    }
                    case 2: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                    }
                    case 4: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                    }
                }
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IApiProblemFilter) {
                IApiProblemFilter filter = (IApiProblemFilter)element;
                return filter.getUnderlyingProblem().getMessage();
            }
            if (element instanceof IResource) {
                IResource resource = (IResource)element;
                IPath path = resource.getProjectRelativePath();
                StringBuffer buffer = new StringBuffer();
                buffer.append(path.removeFileExtension().lastSegment());
                buffer.append(" (");
                buffer.append(path.removeLastSegments(1));
                buffer.append(")");
                return buffer.toString();
            }
            return super.getText(element);
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IResource) {
                try {
                    return ApiFiltersPropertyPage.this.getFilterStore().getFilters((IResource)parentElement);
                }
                catch (CoreException e) {
                    ApiUIPlugin.log(e);
                }
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IApiProblemFilter) {
                return false;
            }
            if (element instanceof IResource) {
                try {
                    return ApiFiltersPropertyPage.this.getFilterStore().getFilters((IResource)element).length > 0;
                }
                catch (CoreException e) {
                    ApiUIPlugin.log(e);
                }
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

