/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.UpdateBundleVersionOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.progress.UIJob;

public class VersionNumberingResolution
implements IMarkerResolution2 {
    private String newVersionValue;
    private int kind;
    private String description;

    public VersionNumberingResolution(IMarker marker) {
        this.newVersionValue = marker.getAttribute("version", null);
        this.kind = ApiProblemFactory.getProblemKind((int)marker.getAttribute("problemid", 0));
        this.description = marker.getAttribute("description", null);
    }

    public String getDescription() {
        if (1 == this.kind) {
            return NLS.bind((String)MarkerMessages.VersionNumberingResolution_major0, (Object[])new String[]{this.newVersionValue, this.description});
        }
        if (2 == this.kind) {
            return NLS.bind((String)MarkerMessages.VersionNumberingResolution_minor0, (Object[])new String[]{this.newVersionValue, this.description});
        }
        return null;
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_OBJ_BUNDLE_VERSION");
    }

    public String getLabel() {
        if (1 == this.kind) {
            return NLS.bind((String)MarkerMessages.VersionNumberingResolution_major1, (Object)this.newVersionValue);
        }
        if (2 == this.kind) {
            return NLS.bind((String)MarkerMessages.VersionNumberingResolution_minor1, (Object)this.newVersionValue);
        }
        return null;
    }

    public void run(final IMarker marker) {
        String title = null;
        if (1 == this.kind) {
            title = NLS.bind((String)MarkerMessages.VersionNumberingResolution_major2, (Object)this.newVersionValue);
        } else if (2 == this.kind) {
            title = NLS.bind((String)MarkerMessages.VersionNumberingResolution_minor2, (Object)this.newVersionValue);
        }
        UIJob job = new UIJob(title){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                UpdateBundleVersionOperation updateBundleVersionOperation = new UpdateBundleVersionOperation(marker, VersionNumberingResolution.this.newVersionValue);
                return updateBundleVersionOperation.run(monitor);
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

