/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.RemoveUnsupportedTagOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.progress.UIJob;

public class UnsupportedTagResolution
implements IMarkerResolution2 {
    private IMarker fBackingMarker = null;

    public UnsupportedTagResolution(IMarker marker) {
        this.fBackingMarker = marker;
    }

    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jdoc_tag_obj.gif");
    }

    public String getLabel() {
        try {
            String arg = (String)this.fBackingMarker.getAttribute("messagearguments");
            String[] args = arg.split("#");
            return NLS.bind((String)MarkerMessages.UnsupportedTagResolution_remove_unsupported_tag, (Object[])new String[]{args[0]});
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void run(IMarker marker) {
        UIJob job = new UIJob(this.getLabel()){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                RemoveUnsupportedTagOperation op = new RemoveUnsupportedTagOperation(UnsupportedTagResolution.this.fBackingMarker);
                op.run(monitor);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

