/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.NodeFinder;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PartInitException;

public class RemoveUnsupportedTagOperation {
    private IMarker fBackingMarker = null;

    public RemoveUnsupportedTagOperation(IMarker marker) {
        this.fBackingMarker = marker;
    }

    public void run(IProgressMonitor monitor) {
        block18: {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MarkerMessages.RemoveUnsupportedTagOperation_removeing_unsupported_tag, (int)5);
            IResource resource = this.fBackingMarker.getResource();
            IJavaElement javaElement = JavaCore.create((IResource)resource);
            try {
                if (javaElement == null || javaElement.getElementType() != 5) break block18;
                ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                if (!compilationUnit.isWorkingCopy()) {
                    JavaUI.openInEditor((IJavaElement)compilationUnit);
                }
                if (localMonitor.isCanceled()) {
                    return;
                }
                localMonitor.worked(1);
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(compilationUnit);
                Integer charStartAttribute = null;
                charStartAttribute = (Integer)this.fBackingMarker.getAttribute("charStart");
                int intValue = charStartAttribute;
                parser.setFocalPosition(intValue);
                parser.setResolveBindings(true);
                Map options = compilationUnit.getJavaProject().getOptions(true);
                options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                parser.setCompilerOptions(options);
                CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
                NodeFinder finder = new NodeFinder(intValue);
                unit.accept((ASTVisitor)finder);
                if (localMonitor.isCanceled()) {
                    return;
                }
                localMonitor.worked(1);
                BodyDeclaration node = finder.getNode();
                if (node == null) break block18;
                unit.recordModifications();
                AST ast = unit.getAST();
                ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                Javadoc docnode = node.getJavadoc();
                if (docnode == null) {
                    return;
                }
                List tags = docnode.tags();
                String arg = (String)this.fBackingMarker.getAttribute("messagearguments");
                String[] args = arg.split("#");
                TagElement tag = null;
                Iterator iterator = tags.iterator();
                while (iterator.hasNext()) {
                    tag = (TagElement)iterator.next();
                    if (args[0].equals(tag.getTagName())) break;
                }
                if (tag == null) {
                    return;
                }
                ListRewrite lrewrite = rewrite.getListRewrite((ASTNode)docnode, Javadoc.TAGS_PROPERTY);
                lrewrite.remove((ASTNode)tag, null);
                if (localMonitor.isCanceled()) {
                    return;
                }
                localMonitor.worked(1);
                try {
                    TextEdit edit = rewrite.rewriteAST();
                    compilationUnit.applyTextEdit(edit, monitor);
                    if (localMonitor.isCanceled()) {
                        return;
                    }
                    localMonitor.worked(1);
                }
                finally {
                    compilationUnit.reconcile(0, false, null, null);
                    if (localMonitor.isCanceled()) {
                        return;
                    }
                    localMonitor.worked(1);
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (PartInitException partInitException) {
            }
            catch (CoreException coreException) {}
        }
    }
}

