/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.pde.api.tools.ui.internal.markers.DefaultApiProfileResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.FilterProblemResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.SinceTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.UnsupportedTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.VersionNumberingResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class ApiMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (!this.hasResolutions(marker)) {
            return this.NO_RESOLUTIONS;
        }
        switch (marker.getAttribute("apiMarkerID", -1)) {
            case 3: {
                return new IMarkerResolution[]{new FilterProblemResolution(marker)};
            }
            case 2: {
                return new IMarkerResolution[]{new FilterProblemResolution(marker)};
            }
            case 1: {
                return new IMarkerResolution[]{new DefaultApiProfileResolution()};
            }
            case 5: {
                return new IMarkerResolution[]{new SinceTagResolution(marker), new FilterProblemResolution(marker)};
            }
            case 4: {
                return new IMarkerResolution[]{new VersionNumberingResolution(marker), new FilterProblemResolution(marker)};
            }
            case 6: {
                return new IMarkerResolution[]{new UnsupportedTagResolution(marker)};
            }
        }
        return this.NO_RESOLUTIONS;
    }

    public boolean hasResolutions(IMarker marker) {
        return marker.getAttribute("apiMarkerID", -1) > 0;
    }
}

