/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.completion.APIToolsJavadocCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class APIToolsJavadocCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private String fErrorMessage = null;
    private Image fImageHandle = null;

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            ICompilationUnit cunit;
            JavaContentAssistInvocationContext jcontext = (JavaContentAssistInvocationContext)context;
            IJavaProject project = jcontext.getProject();
            if (project == null || !Util.isApiProject((IJavaProject)project)) {
                return Collections.EMPTY_LIST;
            }
            CompletionContext corecontext = jcontext.getCoreContext();
            if (corecontext.isInJavadoc() && (cunit = jcontext.getCompilationUnit()) != null) {
                ArrayList<APIToolsJavadocCompletionProposal> list = new ArrayList<APIToolsJavadocCompletionProposal>();
                int offset = jcontext.getInvocationOffset();
                try {
                    IJavaElement element = cunit.getElementAt(offset);
                    if (element == null) {
                        return Collections.EMPTY_LIST;
                    }
                    ImageDescriptor imagedesc = jcontext.getLabelProvider().createImageDescriptor(CompletionProposal.create((int)19, (int)offset));
                    this.fImageHandle = imagedesc == null ? null : imagedesc.createImage();
                    int type = this.getType(element);
                    int member = 16;
                    switch (element.getElementType()) {
                        case 9: {
                            IMethod method = (IMethod)element;
                            if (method.isConstructor()) {
                                member = 32;
                                break;
                            }
                            member = 4;
                            break;
                        }
                        case 8: {
                            IField field = (IField)element;
                            if (Flags.isFinal((int)field.getFlags())) {
                                return Collections.EMPTY_LIST;
                            }
                            member = 8;
                        }
                    }
                    IApiJavadocTag[] tags = ApiPlugin.getJavadocTagManager().getTagsForType(type, member);
                    String completiontext = null;
                    int tokenstart = corecontext.getTokenStart();
                    int length = offset - tokenstart;
                    int i = 0;
                    while (i < tags.length) {
                        completiontext = tags[i].getCompleteTag(type, member);
                        if (this.appliesToContext(jcontext.getDocument(), completiontext, tokenstart, length > 0 ? length : 1)) {
                            list.add(new APIToolsJavadocCompletionProposal(corecontext, completiontext, tags[i].getTagLabel(), this.fImageHandle));
                        }
                        ++i;
                    }
                    return list;
                }
                catch (JavaModelException e) {
                    this.fErrorMessage = e.getMessage();
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    private int getType(IJavaElement element) throws JavaModelException {
        while (element != null && element.getElementType() != 7) {
            element = element.getParent();
        }
        if (element instanceof IType && ((IType)element).isInterface()) {
            return 2;
        }
        return 1;
    }

    private boolean appliesToContext(IDocument document, String completiontext, int tokenstart, int length) {
        if (length > completiontext.length()) {
            return false;
        }
        try {
            String prefix = document.get(tokenstart, length);
            return prefix.equals(completiontext.substring(0, length));
        }
        catch (BadLocationException e) {
            ApiUIPlugin.log(e);
            return false;
        }
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void sessionEnded() {
        if (this.fImageHandle != null) {
            this.fImageHandle.dispose();
        }
        this.fErrorMessage = null;
    }

    public void sessionStarted() {
        this.fErrorMessage = null;
    }
}

