/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.launching.EEVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiSettingsXmlVisitor;
import org.eclipse.pde.api.tools.internal.comparator.TypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.util.SinceTagVersion;
import org.eclipse.pde.api.tools.internal.util.UtilMessages;
import org.osgi.framework.Version;
import org.w3c.dom.Element;

public final class Util {
    public static boolean DEBUG;
    public static final String EMPTY_STRING = "";
    public static final String DEFAULT_PACKAGE_NAME = "";
    public static final String DOT_CLASS_SUFFIX = ".class";
    private static final int DEFAULT_READING_SIZE = 8192;
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_RUNTIMEEXCEPTION = "java.lang.RuntimeException";
    public static final String LINE_DELIMITER;
    public static final String UNKNOWN_ELEMENT_TYPE = "UNKOWN_ELEMENT_KIND";
    public static final String UNKNOWN_FLAGS = "UNKNOWN_FLAGS";
    public static final String UNKNOWN_KIND = "UNKOWN_KIND";
    public static final IClassFile[] NO_CLASS_FILES;
    private static int DELETE_MAX_TIME;
    private static boolean DELETE_DEBUG;
    private static int DELETE_MAX_WAIT;
    static /* synthetic */ Class class$0;

    static {
        LINE_DELIMITER = System.getProperty("line.separator");
        NO_CLASS_FILES = new IClassFile[0];
        DELETE_MAX_TIME = 0;
        DELETE_DEBUG = false;
        DELETE_MAX_WAIT = 10000;
        String property = System.getProperty("DEBUG");
        DEBUG = property != null && property.equalsIgnoreCase("TRUE");
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.eclipse.pde.api.tools", message, exception);
        throw new CoreException((IStatus)status);
    }

    private static void appendProperty(StringBuffer buffer, String key, String value) {
        buffer.append(key);
        buffer.append('=');
        buffer.append(value);
        buffer.append('\n');
    }

    public static List collectAllDeltas(IDelta delta) {
        final ArrayList list = new ArrayList();
        delta.accept(new DeltaVisitor(){

            public void endVisit(IDelta localDelta) {
                if (localDelta.getChildren().length == 0) {
                    list.add(localDelta);
                }
                super.endVisit(localDelta);
            }
        });
        return list;
    }

    private static void collectAllFiles(File root, ArrayList collector, FileFilter fileFilter) {
        File[] files = root.listFiles(fileFilter);
        int i = 0;
        while (i < files.length) {
            File currentFile = files[i];
            if (currentFile.isDirectory()) {
                Util.collectAllFiles(currentFile, collector, fileFilter);
            } else {
                collector.add(currentFile);
            }
            ++i;
        }
    }

    public static String dequalifySignature(String signature) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = signature.toCharArray();
        int i = 0;
        int max = chars.length;
        while (i < max) {
            char currentChar = chars[i];
            switch (currentChar) {
                case 'L': {
                    buffer.append('Q');
                    int lastDotPosition = i++;
                    while (i < chars.length && (currentChar = chars[i]) != ';') {
                        switch (currentChar) {
                            case '.': 
                            case '/': {
                                lastDotPosition = i;
                            }
                        }
                        ++i;
                    }
                    buffer.append(chars, lastDotPosition + 1, i - lastDotPosition - 1);
                    buffer.append(';');
                    break;
                }
                case 'Q': {
                    while (i < chars.length && currentChar != ';') {
                        buffer.append(currentChar);
                        currentChar = chars[++i];
                    }
                }
                default: {
                    buffer.append(currentChar);
                }
            }
            ++i;
        }
        return String.valueOf(buffer);
    }

    public static IProject[] getApiProjects() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> temp = new ArrayList<IProject>();
        IProject project = null;
        int i = 0;
        int max = allProjects.length;
        while (i < max) {
            project = allProjects[i];
            if (project.isAccessible()) {
                try {
                    if (project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) {
                        temp.add(project);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        IProject[] projects = null;
        if (temp.size() != 0) {
            projects = new IProject[temp.size()];
            temp.toArray(projects);
        }
        return projects;
    }

    public static boolean isQualifiedSignature(String signature) {
        StringTokenizer tokenizer = new StringTokenizer(signature, "();IJCSBDFTZ![");
        if (tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken().charAt(0) == 'L';
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean copy(File file, File newFile) {
        byte[] bytes;
        block31: {
            bytes = null;
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                bytes = Util.getInputStreamAsByteArray(inputStream, -1);
            }
            catch (FileNotFoundException e) {
                ApiPlugin.log(e);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        ApiPlugin.log(e2);
                    }
                }
                break block31;
            }
            catch (IOException e) {
                try {
                    ApiPlugin.log(e);
                    break block31;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e3) {
                            ApiPlugin.log(e3);
                        }
                    }
                }
            }
            if (inputStream == null) break block31;
            try {
                inputStream.close();
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
        }
        if (bytes == null) return false;
        FilterOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(newFile));
            outputStream.write(bytes);
            ((BufferedOutputStream)outputStream).flush();
        }
        catch (FileNotFoundException e) {
            ApiPlugin.log(e);
            if (outputStream == null) return true;
            try {
                outputStream.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
        }
        catch (IOException e) {
            try {
                ApiPlugin.log(e);
                if (outputStream == null) return true;
            }
            catch (Throwable throwable) {
                if (outputStream == null) throw throwable;
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                outputStream.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
        }
        if (outputStream == null) return true;
        try {
            outputStream.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
    }

    public static File createDefaultEEFile() throws IOException, CoreException {
        return Util.createEEFile(Util.getDefaultEEId());
    }

    public static File createEEFile(String eeid) throws IOException, CoreException {
        if (ApiPlugin.isRunningInFramework()) {
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            IExecutionEnvironment environment = manager.getEnvironment(eeid);
            IVMInstall[] compatibleVMs = environment.getCompatibleVMs();
            IVMInstall jre = null;
            int i = 0;
            while (i < compatibleVMs.length) {
                IVMInstall install = compatibleVMs[i];
                if (environment.isStrictlyCompatible(install)) {
                    jre = install;
                    break;
                }
                ++i;
            }
            if (jre == null && compatibleVMs.length > 0) {
                jre = compatibleVMs[0];
            }
            if (jre == null) {
                jre = JavaRuntime.getDefaultVMInstall();
            }
            return Util.createEEFile(jre, eeid);
        }
        String fileName = System.getProperty("ee.file");
        if (fileName == null) {
            Util.abort("Could not retrieve the ee.file property", null);
        }
        return new File(fileName);
    }

    public static File createEEFile(IVMInstall jre, String eeid) throws IOException {
        String string = Util.generateEEContents(jre, eeid);
        File eeFile = File.createTempFile("eed", ".ee");
        eeFile.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(eeFile);
        outputStream.write(string.getBytes("UTF-8"));
        outputStream.close();
        return eeFile;
    }

    public static boolean equalsOrNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String generateEEContents(IVMInstall vm, String eeId) throws IOException {
        StringBuffer buffer = new StringBuffer();
        Util.appendProperty(buffer, "-Djava.home", vm.getInstallLocation().getCanonicalPath());
        StringBuffer paths = new StringBuffer();
        LibraryLocation[] libraryLocations = JavaRuntime.getLibraryLocations((IVMInstall)vm);
        int i = 0;
        while (i < libraryLocations.length) {
            LibraryLocation lib = libraryLocations[i];
            paths.append(lib.getSystemLibraryPath().toOSString());
            if (i < libraryLocations.length - 1) {
                paths.append(File.pathSeparatorChar);
            }
            ++i;
        }
        Util.appendProperty(buffer, "-Dee.bootclasspath", paths.toString());
        Util.appendProperty(buffer, "-Dee.class.library.level", eeId);
        return buffer.toString();
    }

    public static File[] getAllFiles(File root, FileFilter fileFilter) {
        ArrayList files = new ArrayList();
        if (root.isDirectory()) {
            Util.collectAllFiles(root, files, fileFilter);
            File[] result = new File[files.size()];
            files.toArray(result);
            return result;
        }
        return null;
    }

    public static String getApiDescriptionXML(IApiComponent apiComponent) throws CoreException {
        ApiSettingsXmlVisitor xmlVisitor = new ApiSettingsXmlVisitor(apiComponent);
        apiComponent.getApiDescription().accept(xmlVisitor);
        return xmlVisitor.getXML();
    }

    public static Job getBuildJob(IProject[] projects) {
        Assert.isNotNull((Object)projects);
        BuildJob buildJob = new BuildJob(UtilMessages.Util_4, projects);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    public static Job getBuildJob(IProject[] projects, int buildKind) {
        Assert.isNotNull((Object)projects);
        BuildJob buildJob = new BuildJob(UtilMessages.Util_4, projects, buildKind);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    public static IClassFile getClassFile(IApiComponent[] components, String typeName) {
        if (components == null) {
            return null;
        }
        int i = 0;
        int max = components.length;
        while (i < max) {
            IApiComponent apiComponent = components[i];
            if (apiComponent != null) {
                try {
                    IClassFile classFile = apiComponent.findClassFile(typeName);
                    if (classFile != null) {
                        return classFile;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return null;
    }

    public static IApiComponent getComponent(IApiComponent[] components, String typeName) {
        if (components == null) {
            return null;
        }
        int i = 0;
        int max = components.length;
        while (i < max) {
            IApiComponent apiComponent = components[i];
            if (apiComponent != null) {
                try {
                    IClassFile classFile = apiComponent.findClassFile(typeName);
                    if (classFile != null) {
                        return apiComponent;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return null;
    }

    public static String getDefaultEEId() {
        String eeid = "JavaSE-1.6";
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            int i = 0;
            while (i < environments.length) {
                if (environments[i].isStrictlyCompatible(install)) {
                    return environments[i].getId();
                }
                ++i;
            }
        }
        return eeid;
    }

    public static String getDeltaElementType(IDelta delta) {
        return Util.getDeltaElementType(delta.getElementType());
    }

    public static String getSeverity(int severity) {
        switch (severity) {
            case 2: {
                return "ERROR";
            }
            case 0: {
                return "INFO";
            }
            case 1: {
                return "WARNING";
            }
        }
        return "UNKNOWN_SEVERITY";
    }

    public static String getDeltaElementType(int elementType) {
        switch (elementType) {
            case 1: {
                return "ANNOTATION_ELEMENT_TYPE";
            }
            case 8: {
                return "INTERFACE_ELEMENT_TYPE";
            }
            case 6: {
                return "ENUM_ELEMENT_TYPE";
            }
            case 2: {
                return "API_COMPONENT_ELEMENT_TYPE";
            }
            case 3: {
                return "API_PROFILE_ELEMENT_TYPE";
            }
            case 5: {
                return "CONSTRUCTOR_ELEMENT_TYPE";
            }
            case 9: {
                return "MEMBER_ELEMENT_TYPE";
            }
            case 10: {
                return "METHOD_ELEMENT_TYPE";
            }
            case 7: {
                return "FIELD_ELEMENT_TYPE";
            }
            case 4: {
                return "CLASS_ELEMENT_TYPE";
            }
        }
        return UNKNOWN_ELEMENT_TYPE;
    }

    public static String getDeltaFlagsName(IDelta delta) {
        return Util.getDeltaFlagsName(delta.getFlags());
    }

    public static String getDeltaFlagsName(int flags) {
        switch (flags) {
            case 1: {
                return "ABSTRACT_TO_NON_ABSTRACT";
            }
            case 2: {
                return "ANNOTATION_DEFAULT_VALUE";
            }
            case 3: {
                return "API_COMPONENT";
            }
            case 4: {
                return "ARRAY_TO_VARARGS";
            }
            case 5: {
                return "CHECKED_EXCEPTION";
            }
            case 6: {
                return "CLASS_BOUND";
            }
            case 7: {
                return "CLINIT";
            }
            case 8: {
                return "CONSTRUCTOR";
            }
            case 9: {
                return "CONTRACTED_SUPERCLASS_SET";
            }
            case 10: {
                return "CONTRACTED_SUPERINTERFACES_SET";
            }
            case 11: {
                return "DECREASE_ACCESS";
            }
            case 12: {
                return "ENUM_CONSTANT";
            }
            case 13: {
                return "EXECUTION_ENVIRONMENT";
            }
            case 14: {
                return "EXPANDED_SUPERCLASS_SET";
            }
            case 15: {
                return "EXPANDED_SUPERINTERFACES_SET";
            }
            case 16: {
                return "FIELD";
            }
            case 17: {
                return "FIELD_MOVED_UP";
            }
            case 18: {
                return "FINAL_TO_NON_FINAL";
            }
            case 19: {
                return "FINAL_TO_NON_FINAL_NON_STATIC";
            }
            case 20: {
                return "FINAL_TO_NON_FINAL_STATIC_CONSTANT";
            }
            case 21: {
                return "FINAL_TO_NON_FINAL_STATIC_NON_CONSTANT";
            }
            case 22: {
                return "INCREASE_ACCESS";
            }
            case 23: {
                return "INTERFACE_BOUND";
            }
            case 24: {
                return "INTERFACE_BOUNDS";
            }
            case 25: {
                return "METHOD";
            }
            case 26: {
                return "METHOD_MOVED_UP";
            }
            case 27: {
                return "METHOD_WITH_DEFAULT_VALUE";
            }
            case 28: {
                return "METHOD_WITHOUT_DEFAULT_VALUE";
            }
            case 29: {
                return "NATIVE_TO_NON_NATIVE";
            }
            case 30: {
                return "NON_ABSTRACT_TO_ABSTRACT";
            }
            case 31: {
                return "NON_FINAL_TO_FINAL";
            }
            case 32: {
                return "NON_NATIVE_TO_NATIVE";
            }
            case 33: {
                return "NON_STATIC_TO_STATIC";
            }
            case 34: {
                return "NON_SYNCHRONIZED_TO_SYNCHRONIZED";
            }
            case 35: {
                return "NON_TRANSIENT_TO_TRANSIENT";
            }
            case 36: {
                return "OVERRIDEN_METHOD";
            }
            case 38: {
                return "STATIC_TO_NON_STATIC";
            }
            case 39: {
                return "SUPERCLASS";
            }
            case 40: {
                return "SYNCHRONIZED_TO_NON_SYNCHRONIZED";
            }
            case 41: {
                return "TO_ANNOTATION";
            }
            case 42: {
                return "TO_CLASS";
            }
            case 43: {
                return "TO_ENUM";
            }
            case 44: {
                return "TO_INTERFACE";
            }
            case 45: {
                return "TRANSIENT_TO_NON_TRANSIENT";
            }
            case 46: {
                return "TYPE";
            }
            case 47: {
                return "TYPE_ARGUMENTS";
            }
            case 48: {
                return "TYPE_MEMBER";
            }
            case 49: {
                return "TYPE_PARAMETER";
            }
            case 50: {
                return "TYPE_PARAMETER_NAME";
            }
            case 51: {
                return "TYPE_PARAMETERS";
            }
            case 52: {
                return "TYPE_VISIBILITY";
            }
            case 53: {
                return "UNCHECKED_EXCEPTION";
            }
            case 54: {
                return "VALUE";
            }
            case 55: {
                return "VARARGS_TO_ARRAY";
            }
            case 37: {
                return "RESTRICTIONS";
            }
            case 56: {
                return "API_TYPE";
            }
        }
        return UNKNOWN_FLAGS;
    }

    public static String getDeltaKindName(IDelta delta) {
        return Util.getDeltaKindName(delta.getKind());
    }

    public static String getDeltaKindName(int kind) {
        switch (kind) {
            case 1: {
                return "ADDED";
            }
            case 2: {
                return "CHANGED";
            }
            case 3: {
                return "REMOVED";
            }
        }
        return UNKNOWN_KIND;
    }

    public static String getDeltaPrefererenceKey(int elementType, int kind, int flags) {
        StringBuffer buffer = new StringBuffer(Util.getDeltaElementType(elementType));
        buffer.append('_').append(Util.getDeltaKindName(kind));
        if (flags != -1) {
            buffer.append('_').append(Util.getDeltaFlagsName(flags));
        }
        return String.valueOf(buffer);
    }

    public static String getDetail(IDelta delta) {
        StringBuffer buffer = new StringBuffer();
        switch (delta.getElementType()) {
            case 4: {
                buffer.append("class");
                break;
            }
            case 1: {
                buffer.append("annotation");
                break;
            }
            case 8: {
                buffer.append("interface");
                break;
            }
            case 2: {
                buffer.append("api component");
                break;
            }
            case 3: {
                buffer.append("api profile");
                break;
            }
            case 10: {
                buffer.append("method");
                break;
            }
            case 9: {
                buffer.append("member");
                break;
            }
            case 5: {
                buffer.append("constructor");
                break;
            }
            case 6: {
                buffer.append("enum");
                break;
            }
            case 7: {
                buffer.append("field");
            }
        }
        buffer.append(' ');
        switch (delta.getKind()) {
            case 1: {
                buffer.append("added");
                break;
            }
            case 3: {
                buffer.append("removed");
                break;
            }
            case 2: {
                buffer.append("changed");
                break;
            }
            default: {
                buffer.append("unknown kind");
            }
        }
        buffer.append(' ').append(Util.getDeltaFlagsName(delta.getFlags())).append(' ').append(delta.getTypeName()).append("#").append(delta.getKey());
        return String.valueOf(buffer);
    }

    public static IDocument getDocument(ICompilationUnit cu) throws CoreException {
        IFile file;
        if (cu.getOwner() == null && (file = (IFile)cu.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IPath path = cu.getPath();
            bufferManager.connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            return bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
        }
        return new Document(cu.getSource());
    }

    public static Properties getEEProfile(File eeFileProperty) {
        InputStream stream;
        if (!eeFileProperty.exists()) {
            return null;
        }
        EEVMType.clearProperties((File)eeFileProperty);
        String ee = EEVMType.getProperty((String)"-Dee.class.library.level", (File)eeFileProperty);
        if (ee == null) {
            return null;
        }
        String profileName = String.valueOf(ee) + ".profile";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.api.tools.internal.util.Util");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((stream = clazz.getResourceAsStream("profiles/" + profileName)) != null) {
            try {
                Properties profile = new Properties();
                profile.load(stream);
                Properties properties = profile;
                return properties;
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    public static Properties getEEProfile(String eeName) {
        InputStream stream;
        if (eeName == null) {
            return null;
        }
        String profileName = String.valueOf(eeName) + ".profile";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.api.tools.internal.util.Util");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((stream = clazz.getResourceAsStream("profiles/" + profileName)) != null) {
            try {
                Properties profile = new Properties();
                profile.load(stream);
                Properties properties = profile;
                return properties;
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    public static final int getFragmentNumber(String version) {
        char[] charArray;
        int length;
        if (version == null) {
            throw new IllegalArgumentException("The given version should not be null");
        }
        int index = version.indexOf(32);
        if (index + 1 >= (length = (charArray = version.toCharArray()).length)) {
            return -1;
        }
        int counter = 1;
        int i = index + 1;
        while (i < length) {
            switch (charArray[i]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    ++counter;
                    break;
                }
                default: {
                    return -1;
                }
            }
            ++i;
        }
        return counter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IMember getIMember(IDelta delta, IJavaProject javaProject) {
        String typeName = delta.getTypeName();
        if (typeName == null) {
            return null;
        }
        IType type = null;
        try {
            type = javaProject.findType(typeName.replace('$', '.'));
        }
        catch (JavaModelException javaModelException) {}
        if (type == null) {
            return null;
        }
        String key = delta.getKey();
        switch (delta.getElementType()) {
            case 7: {
                IField field = type.getField(key);
                if (!field.exists()) return null;
                return field;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                switch (delta.getKind()) {
                    case 1: {
                        switch (delta.getFlags()) {
                            case 16: {
                                IField field = type.getField(key);
                                if (!field.exists()) return type;
                                return field;
                            }
                            case 8: 
                            case 25: {
                                int indexOf = key.indexOf(40);
                                if (indexOf == -1) {
                                    return null;
                                }
                                int index = indexOf;
                                String selector = key.substring(0, index);
                                String descriptor = key.substring(index, key.length());
                                return Util.getMethod(type, selector, descriptor);
                            }
                            case 48: {
                                IType type2 = type.getType(key);
                                if (!type2.exists()) return type;
                                return type2;
                            }
                        }
                        return type;
                    }
                }
                return type;
            }
            case 5: 
            case 10: {
                int indexOf = key.indexOf(40);
                if (indexOf == -1) {
                    return null;
                }
                int index = indexOf;
                String selector = key.substring(0, index);
                String descriptor = key.substring(index, key.length());
                return Util.getMethod(type, selector, descriptor);
            }
            case 2: {
                return type;
            }
        }
        return null;
    }

    private static IMember getMethod(IType type, String selector, String descriptor) {
        IMethod method = null;
        String signature = descriptor.replace('/', '.');
        String[] parameterTypes = Signature.getParameterTypes((String)signature);
        try {
            method = type.getMethod(selector, parameterTypes);
        }
        catch (IllegalArgumentException e) {
            ApiPlugin.log(e);
        }
        if (method == null) {
            return null;
        }
        if (method.exists()) {
            return method;
        }
        IMethod[] methods = null;
        try {
            methods = type.getMethods();
        }
        catch (JavaModelException e) {
            ApiPlugin.log(e);
            ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", NLS.bind((String)UtilMessages.Util_6, (Object[])new String[]{selector, descriptor})));
            return null;
        }
        ArrayList<IMethod> list = new ArrayList<IMethod>();
        int i = 0;
        int max = methods.length;
        while (i < max) {
            IMethod method2 = methods[i];
            if (selector.equals(method2.getElementName())) {
                list.add(method2);
            }
            ++i;
        }
        switch (list.size()) {
            case 0: {
                ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", NLS.bind((String)UtilMessages.Util_6, (Object[])new String[]{selector, descriptor})));
                return null;
            }
            case 1: {
                return (IMember)list.get(0);
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IMethod method2 = (IMethod)iterator.next();
            try {
                if (!Util.matchesSignatures(method2.getSignature(), signature)) continue;
                return method2;
            }
            catch (JavaModelException javaModelException) {}
        }
        ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", NLS.bind((String)UtilMessages.Util_6, (Object[])new String[]{selector, descriptor})));
        return null;
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        Charset charset = null;
        try {
            charset = Charset.forName(encoding);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            System.err.println("Illegal charset name : " + encoding);
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            System.err.println("Unsupported charset : " + encoding);
            return null;
        }
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] contents = Util.getInputStreamAsByteArray(stream, length);
        ByteBuffer byteBuffer = ByteBuffer.allocate(contents.length);
        byteBuffer.put(contents);
        byteBuffer.flip();
        return charsetDecoder.decode(byteBuffer).array();
    }

    public static IResource getManifestFile(IProject currentProject) {
        return currentProject.findMember("META-INF/MANIFEST.MF");
    }

    public static String getProblemCategory(int category) {
        if (category == 0x10000000) {
            return "COMPATIBILITY";
        }
        if (category == 0x40000000) {
            return "SINCETAGS";
        }
        if (category == 0x20000000) {
            return "USAGE";
        }
        if (category == 0x30000000) {
            return "VERSION";
        }
        if (category == 0x50000000) {
            return "API_PROFILE";
        }
        return "UNKNOWN_CATEGORY";
    }

    public static String getProblemElementKind(int category, int kind) {
        switch (category) {
            case 0x10000000: 
            case 0x40000000: {
                return Util.getDeltaElementType(kind);
            }
            case 0x20000000: 
            case 0x30000000: 
            case 0x50000000: {
                return Util.getDescriptorKind(kind);
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getProblemFlagsName(int category, int flags) {
        switch (category) {
            case 0x10000000: {
                return Util.getDeltaFlagsName(flags);
            }
            case 0x20000000: 
            case 0x30000000: 
            case 0x40000000: 
            case 0x50000000: {
                switch (flags) {
                    case 1: {
                        return "LEAK_EXTENDS";
                    }
                    case 3: {
                        return "LEAK_FIELD";
                    }
                    case 2: {
                        return "LEAK_IMPLEMENTS";
                    }
                    case 5: {
                        return "LEAK_METHOD_PARAMETER";
                    }
                    case 4: {
                        return "LEAK_RETURN_TYPE";
                    }
                    case 7: {
                        return "CONSTRUCTOR_METHOD";
                    }
                    case 0: {
                        return "NO_FLAGS";
                    }
                }
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getProblemKind(int category, int kind) {
        switch (category) {
            case 0x10000000: {
                return Util.getDeltaKindName(kind);
            }
            case 0x40000000: {
                return Util.getTagsProblemKindName(kind);
            }
            case 0x20000000: {
                return Util.getUsageProblemKindName(kind);
            }
            case 0x30000000: {
                return Util.getVersionProblemKindName(kind);
            }
            case 0x50000000: {
                return Util.getApiProfileProblemKindName(kind);
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getApiProfileProblemKindName(int kind) {
        switch (kind) {
            case 1: {
                return "API_PROFILE_MISSING";
            }
        }
        return UNKNOWN_KIND;
    }

    public static String getVersionProblemKindName(int kind) {
        switch (kind) {
            case 2: {
                return "MINOR_VERSION_CHANGE";
            }
            case 1: {
                return "MAJOR_VERSION_CHANGE";
            }
            case 3: {
                return "MAJOR_VERSION_CHANGE_NO_BREAKAGE";
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getUsageProblemKindName(int kind) {
        switch (kind) {
            case 1: {
                return "ILLEGAL_EXTEND";
            }
            case 4: {
                return "ILLEGAL_IMPLEMENT";
            }
            case 2: {
                return "ILLEGAL_INSTANTIATE";
            }
            case 3: {
                return "ILLEGAL_REFERENCE";
            }
            case 5: {
                return "ILLEGAL_OVERRIDE";
            }
            case 6: {
                return "API_LEAK";
            }
            case 7: {
                return "UNSUPPORTED_TAG_USE";
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getTagsProblemKindName(int kind) {
        switch (kind) {
            case 1: {
                return "INVALID_SINCE_TAGS";
            }
            case 2: {
                return "MALFORMED_SINCE_TAGS";
            }
            case 3: {
                return "MISSING_SINCE_TAGS";
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getMethodSignatureFromNode(MethodDeclaration node) {
        Assert.isNotNull((Object)node);
        List params = node.parameters();
        List rparams = Util.getParametersTypeNames(params);
        if (rparams.size() == params.size()) {
            if (!node.isConstructor()) {
                String rtype;
                Type returnType = node.getReturnType2();
                if (returnType != null && (rtype = Util.getTypeSignature(returnType)) != null) {
                    return Signature.createMethodSignature((String[])rparams.toArray(new String[rparams.size()]), (String)rtype);
                }
            } else {
                StringBuffer buffer = new StringBuffer();
                buffer.append("<init>");
                buffer.append(Signature.createMethodSignature((String[])rparams.toArray(new String[rparams.size()]), (String)"V"));
                return buffer.toString();
            }
        }
        return null;
    }

    public static List getParametersTypeNames(List rawparams) {
        ArrayList<String> rparams = new ArrayList<String>(rawparams.size());
        SingleVariableDeclaration param = null;
        String pname = null;
        Iterator iter = rawparams.iterator();
        while (iter.hasNext()) {
            param = (SingleVariableDeclaration)iter.next();
            pname = Util.getTypeSignature(param.getType());
            if (pname == null) continue;
            rparams.add(pname);
        }
        return rparams;
    }

    public static String getPackageName(String typeName) {
        int index = typeName.lastIndexOf(46);
        return index == -1 ? "" : typeName.substring(0, index);
    }

    public static String getDescriptorKind(int kind) {
        switch (kind) {
            case 1: {
                return "PACKAGE";
            }
            case 4: {
                return "ARRAY_TYPE";
            }
            case 5: {
                return "FIELD";
            }
            case 6: {
                return "METHOD";
            }
            case 3: {
                return "PRIMITIVE_TYPE";
            }
            case 2: {
                return "REFERENCE_TYPE";
            }
            case 7: {
                return "RESOURCE";
            }
        }
        return UNKNOWN_ELEMENT_TYPE;
    }

    public static String getVisibilityKind(int kind) {
        switch (kind) {
            case 65535: {
                return "ALL_VISIBILITIES";
            }
            case 1: {
                return "API";
            }
            case 2: {
                return "PRIVATE";
            }
            case 8: {
                return "PRIVATE_PERMISSIBLE";
            }
            case 4: {
                return "SPI";
            }
            case 0: {
                return "INHERITED";
            }
        }
        return null;
    }

    public static String getRestrictionKind(int kind) {
        StringBuffer buffer = new StringBuffer();
        if (kind == 0) {
            return "NO_RESTRICTIONS";
        }
        if (kind == 65535) {
            buffer.append("ALL_RESTRICTIONS");
        } else {
            if ((kind & 0x200) > 0) {
                buffer.append("NO_EXTEND");
            }
            if ((kind & 0x100) > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" | ");
                }
                buffer.append("NO_IMPLEMENT");
            }
            if ((kind & 0x400) > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" | ");
                }
                buffer.append("NO_INSTANTIATE");
            }
            if ((kind & 0x800) > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" | ");
                }
                buffer.append("NO_REFERENCE");
            }
            if (0 > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" | ");
                }
                buffer.append("NO_RESTRICTIONS");
            }
            if ((kind & 0x1000) > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" | ");
                }
                buffer.append("NO_OVERRIDE");
            }
        }
        if (buffer.length() == 0) {
            return "UNKNOWN_KIND";
        }
        return buffer.toString();
    }

    public static final String getReferenceKind(int kind) {
        StringBuffer buffer = new StringBuffer();
        if ((kind & 1) > 0) {
            buffer.append("EXTENDS");
        }
        if ((kind & 2) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("IMPLEMENTS");
        }
        if ((kind & 0x100000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("INVOKED_SPECIAL");
        }
        if ((kind & 0x80) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("INVOKED_STATIC");
        }
        if ((kind & 0x4000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("PUT_FIELD");
        }
        if ((kind & 0x1000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("PUT_STATIC_FIELD");
        }
        if ((kind & 4) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("DECLARED_FIELD");
        }
        if ((kind & 0x200000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("DECLARED_PARAMETERIZED_TYPE");
        }
        if ((kind & 0x400000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("DECLARED_PARAMETERIZED_FIELD");
        }
        if ((kind & 0x800000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("DECLARED_PARAMETERIZED_METHOD");
        }
        if ((kind & 0x10) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("PARAMETER");
        }
        if ((kind & 0x2000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("LOCAL_VAR_DECLARED");
        }
        if ((kind & 0x1000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("DECLARED_PARAMETERIZED_VARIABLE");
        }
        if ((kind & 0x20) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("THROWS");
        }
        if ((kind & 0x40000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("CASTS");
        }
        if ((kind & 0x8000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("ALLOCATES_ARRAY");
        }
        if ((kind & 0x20000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("CATCHES_EXCEPTION");
        }
        if ((kind & 0x2000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("GETS_FIELD");
        }
        if ((kind & 0x800) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("GETS_STATIC_FIELD");
        }
        if ((kind & 0x80000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("INSTANCEOF");
        }
        if ((kind & 0x200) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("INTERFACE_METHOD");
        }
        if ((kind & 0x40) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("CONSTRUCTOR_METHOD");
        }
        if ((kind & 0x10000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("LOCAL_VARIABLE");
        }
        if ((kind & 0x400) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("PASSED_PARAMETER");
        }
        if ((kind & 8) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("RETURN_TYPE");
        }
        if ((kind & 0x100) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("VIRTUAL_METHOD");
        }
        if ((kind & 0x4000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("CONSTANT_POOL");
        }
        if ((kind & 0x8000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("INSTANTIATION");
        }
        if ((kind & 0x10000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("OVERRIDE");
        }
        return buffer.toString();
    }

    public static IReferenceTypeDescriptor getType(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        String pkg = index == -1 ? "" : fullyQualifiedName.substring(0, index);
        String type = index == -1 ? fullyQualifiedName : fullyQualifiedName.substring(index + 1);
        return Factory.packageDescriptor(pkg).getType(type);
    }

    public static IReferenceTypeDescriptor getType(String fullyQualifiedName, int modifiers) {
        int index = fullyQualifiedName.lastIndexOf(46);
        String pkg = index == -1 ? "" : fullyQualifiedName.substring(0, index);
        String type = index == -1 ? fullyQualifiedName : fullyQualifiedName.substring(index + 1);
        return Factory.packageDescriptor(pkg).getType(type, modifiers);
    }

    public static String getTypeName(String qualifiedname) {
        int idx = qualifiedname.lastIndexOf(46);
        if (++idx > 0) {
            return qualifiedname.substring(idx, qualifiedname.length());
        }
        return qualifiedname;
    }

    public static String getTypeSignature(Type type) {
        switch (type.getNodeType()) {
            case 43: {
                return Signature.createTypeSignature((String)((SimpleType)type).getName().getFullyQualifiedName(), (boolean)false);
            }
            case 75: {
                return Signature.createTypeSignature((String)((QualifiedType)type).getName().getFullyQualifiedName(), (boolean)false);
            }
            case 5: {
                ArrayType a = (ArrayType)type;
                return Signature.createArraySignature((String)Util.getTypeSignature(a.getElementType()), (int)a.getDimensions());
            }
            case 74: {
                return Util.getTypeSignature(((ParameterizedType)type).getType());
            }
            case 39: {
                return Signature.createTypeSignature((String)((PrimitiveType)type).getPrimitiveTypeCode().toString(), (boolean)false);
            }
        }
        return null;
    }

    public static boolean isAbstract(int accessFlags) {
        return (accessFlags & 0x400) != 0;
    }

    public static boolean isAnnotation(int accessFlags) {
        return (accessFlags & 0x2000) != 0;
    }

    public static boolean isApiProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isApiProject(IJavaProject project) {
        return Util.isApiProject(project.getProject());
    }

    public static boolean isArchive(String fileName) {
        String normalizedFileName = fileName.toLowerCase();
        return normalizedFileName.endsWith(".zip") || normalizedFileName.endsWith(".jar");
    }

    public static boolean isBridge(int accessFlags) {
        return (accessFlags & 0x40) != 0;
    }

    public static boolean isClass(int accessFlags) {
        return (accessFlags & 0x6200) == 0;
    }

    public static boolean isClassFile(String fileName) {
        return fileName.toLowerCase().endsWith(DOT_CLASS_SUFFIX);
    }

    public static boolean isDefault(int accessFlags) {
        return (accessFlags & 7) == 0;
    }

    public static boolean isDeprecated(int accessFlags) {
        return (accessFlags & 0x20000) != 0;
    }

    public static boolean isEnum(int accessFlags) {
        return (accessFlags & 0x4000) != 0;
    }

    public static boolean isFinal(int accessFlags) {
        return (accessFlags & 0x10) != 0;
    }

    public static final boolean isGreatherVersion(String versionToBeChecked, String referenceVersion) {
        SinceTagVersion sinceTagVersion1 = null;
        SinceTagVersion sinceTagVersion2 = null;
        try {
            sinceTagVersion1 = new SinceTagVersion(versionToBeChecked);
            sinceTagVersion2 = new SinceTagVersion(referenceVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        Version version1 = sinceTagVersion1.getVersion();
        Version version2 = sinceTagVersion2.getVersion();
        if (version1.getMajor() > version2.getMajor()) {
            return true;
        }
        if (version1.getMinor() > version2.getMinor()) {
            return true;
        }
        if (version1.getMicro() > version2.getMicro()) {
            return true;
        }
        String qualifier1 = version1.getQualifier();
        String qualifier2 = version2.getQualifier();
        if (qualifier1 == null) {
            return false;
        }
        if (qualifier2 == null) {
            return true;
        }
        return qualifier1.compareTo(qualifier2) > 0;
    }

    public static final boolean isDifferentVersion(String versionToBeChecked, String referenceVersion) {
        SinceTagVersion sinceTagVersion1 = null;
        SinceTagVersion sinceTagVersion2 = null;
        try {
            sinceTagVersion1 = new SinceTagVersion(versionToBeChecked);
            sinceTagVersion2 = new SinceTagVersion(referenceVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        Version version1 = sinceTagVersion1.getVersion();
        Version version2 = sinceTagVersion2.getVersion();
        if (version1.getMajor() != version2.getMajor()) {
            return true;
        }
        if (version1.getMinor() != version2.getMinor()) {
            return true;
        }
        return version1.getMicro() != version2.getMicro();
    }

    public static boolean isInterface(int accessFlags) {
        return (accessFlags & 0x200) != 0;
    }

    public static boolean isJavaFileName(String fileName) {
        return fileName.toLowerCase().endsWith(".java");
    }

    public static boolean isJavaLangObject(String name) {
        return name != null && name.equals(JAVA_LANG_OBJECT);
    }

    public static boolean isJavaLangRuntimeException(String name) {
        return name != null && name.equals(JAVA_LANG_RUNTIMEEXCEPTION);
    }

    public static boolean isNative(int accessFlags) {
        return (accessFlags & 0x100) != 0;
    }

    public static boolean isPrivate(int accessFlags) {
        return (accessFlags & 2) != 0;
    }

    public static boolean isProtected(int accessFlags) {
        return (accessFlags & 4) != 0;
    }

    public static boolean isPublic(int accessFlags) {
        return (accessFlags & 1) != 0;
    }

    public static boolean isStatic(int accessFlags) {
        return (accessFlags & 8) != 0;
    }

    public static boolean isStrict(int accessFlags) {
        return (accessFlags & 0x800) != 0;
    }

    public static boolean isSynchronized(int accessFlags) {
        return (accessFlags & 0x20) != 0;
    }

    public static boolean isSynthetic(int accessFlags) {
        return (accessFlags & 0x1000) != 0;
    }

    public static boolean isTransient(int accessFlags) {
        return (accessFlags & 0x80) != 0;
    }

    public static boolean isVarargs(int accessFlags) {
        return (accessFlags & 0x80) != 0;
    }

    public static boolean isVolatile(int accessFlags) {
        return (accessFlags & 0x40) != 0;
    }

    public static boolean isVisible(IDelta delta) {
        int modifiers = delta.getModifiers();
        return Util.isProtected(modifiers) || Util.isPublic(modifiers);
    }

    public static org.w3c.dom.Document newDocument() throws CoreException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = dfactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Util.abort("Unable to create new XML document.", e);
        }
        org.w3c.dom.Document doc = docBuilder.newDocument();
        return doc;
    }

    /*
     * Exception decompiling
     */
    public static Element parseDocument(String document) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void saveFile(File file, String contents) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
            writer.flush();
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static InputStream getInputStreamFromString(String string) {
        try {
            return new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            ApiPlugin.log(uee);
            return null;
        }
    }

    public static String serializeDocument(org.w3c.dom.Document document) throws CoreException {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            return s.toString("UTF-8");
        }
        catch (TransformerException e) {
            Util.abort("Unable to serialize XML document.", e);
        }
        catch (IOException e) {
            Util.abort("Unable to serialize XML document.", e);
        }
        return null;
    }

    public static void unzip(String zipPath, String destDirPath) throws IOException {
        block18: {
            FileInputStream zipIn = new FileInputStream(zipPath);
            byte[] buf = new byte[8192];
            File destDir = new File(destDirPath);
            ZipInputStream zis = new ZipInputStream(zipIn);
            FileOutputStream fos = null;
            try {
                try {
                    ZipEntry zEntry;
                    while ((zEntry = zis.getNextEntry()) != null) {
                        if (zEntry.isDirectory()) {
                            new File(destDir, zEntry.getName()).mkdirs();
                            continue;
                        }
                        String filePath = zEntry.getName();
                        int lastSeparator = filePath.lastIndexOf("/");
                        String fileDir = "";
                        if (lastSeparator >= 0) {
                            fileDir = filePath.substring(0, lastSeparator);
                        }
                        new File(destDir, fileDir).mkdirs();
                        File outFile = new File(destDir, filePath);
                        fos = new FileOutputStream(outFile);
                        int n = 0;
                        while ((n = zis.read(buf)) >= 0) {
                            fos.write(buf, 0, n);
                        }
                        fos.close();
                    }
                }
                catch (IOException iOException) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    try {
                        ((InputStream)zipIn).close();
                        zis.close();
                    }
                    catch (IOException iOException3) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)zipIn).close();
                    zis.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)zipIn).close();
                zis.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static File getEEDescriptionFile() {
        File fakeEEFile = null;
        PrintWriter writer = null;
        try {
            try {
                fakeEEFile = File.createTempFile("eefile", ".ee");
                writer = new PrintWriter(new BufferedWriter(new FileWriter(fakeEEFile)));
                writer.print("-Djava.home=");
                writer.println(System.getProperty("java.home"));
                writer.print("-Dee.bootclasspath=");
                writer.println(Util.getJavaClassLibsAsString());
                writer.println("-Dee.language.level=1.6");
                writer.println("-Dee.class.library.level=JavaSE-1.6");
                writer.flush();
            }
            catch (IOException iOException) {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return fakeEEFile;
    }

    public static String getJavaClassLibsAsString() {
        String[] libs = Util.getJavaClassLibs();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int max = libs.length;
        while (i < max) {
            if (i > 0) {
                buffer.append(File.pathSeparatorChar);
            }
            buffer.append(libs[i]);
            ++i;
        }
        return String.valueOf(buffer);
    }

    public static String[] getJavaClassLibs() {
        String bootclasspathProperty = System.getProperty("sun.boot.class.path");
        if (!(bootclasspathProperty != null && bootclasspathProperty.length() != 0 || (bootclasspathProperty = System.getProperty("vm.boot.class.path")) != null && bootclasspathProperty.length() != 0)) {
            bootclasspathProperty = System.getProperty("org.apache.harmony.boot.class.path");
        }
        String[] jars = null;
        if (bootclasspathProperty != null && bootclasspathProperty.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(bootclasspathProperty, File.pathSeparator);
            int size = tokenizer.countTokens();
            jars = new String[size];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String fileName = Util.toNativePath(tokenizer.nextToken());
                if (!new File(fileName).exists()) continue;
                jars[i] = fileName;
                ++i;
            }
            if (size != i) {
                String[] stringArray = jars;
                jars = new String[i];
                System.arraycopy(stringArray, 0, jars, 0, i);
            }
        } else {
            String jreDir = System.getProperty("java.home");
            String osName = System.getProperty("os.name");
            if (jreDir == null) {
                return new String[0];
            }
            if (osName.startsWith("Mac")) {
                return new String[]{Util.toNativePath(String.valueOf(jreDir) + "/../Classes/classes.jar")};
            }
            String vmName = System.getProperty("java.vm.name");
            if ("J9".equals(vmName)) {
                return new String[]{Util.toNativePath(String.valueOf(jreDir) + "/lib/jclMax/classes.zip")};
            }
            String[] jarsNames = null;
            ArrayList paths = new ArrayList();
            if ("DRLVM".equals(vmName)) {
                FilenameFilter jarFilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar") & !name.endsWith("-src.jar");
                    }
                };
                jarsNames = new File(String.valueOf(jreDir) + "/lib/boot/").list(jarFilter);
                Util.addJarEntries(String.valueOf(jreDir) + "/lib/boot/", jarsNames, paths);
            } else {
                jarsNames = new String[]{"/lib/vm.jar", "/lib/rt.jar", "/lib/core.jar", "/lib/security.jar", "/lib/xml.jar", "/lib/graphics.jar"};
                Util.addJarEntries(jreDir, jarsNames, paths);
            }
            jars = new String[paths.size()];
            paths.toArray(jars);
        }
        return jars;
    }

    public static String toNativePath(String path) {
        String nativePath = path.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return nativePath.endsWith("/") || nativePath.endsWith("\\") ? nativePath.substring(0, nativePath.length() - 1) : nativePath;
    }

    private static void addJarEntries(String jreDir, String[] jarNames, ArrayList paths) {
        int i = 0;
        int max = jarNames.length;
        while (i < max) {
            String currentName = String.valueOf(jreDir) + jarNames[i];
            File f = new File(currentName);
            if (f.exists()) {
                paths.add(Util.toNativePath(currentName));
            }
            ++i;
        }
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            Util.flushDirectoryContent(file);
        }
        file.delete();
        if (Util.isFileDeleted(file)) {
            return true;
        }
        return Util.waitUntilFileDeleted(file);
    }

    public static void flushDirectoryContent(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        int max = files.length;
        while (i < max) {
            Util.delete(files[i]);
            ++i;
        }
    }

    private static boolean waitUntilFileDeleted(File file) {
        int count = 0;
        int delay = 10;
        int maxRetry = DELETE_MAX_WAIT / delay;
        int time = 0;
        while (count < maxRetry) {
            block8: {
                block7: {
                    ++count;
                    Thread.sleep(delay);
                    if ((time += delay) > DELETE_MAX_TIME) {
                        DELETE_MAX_TIME = time;
                    }
                    if (DELETE_DEBUG) {
                        System.out.print('.');
                    }
                    if (!file.exists() || !file.delete()) break block7;
                    return true;
                }
                if (!Util.isFileDeleted(file)) break block8;
                return true;
            }
            try {
                if (count < 10 || delay > 100) continue;
                count = 1;
                maxRetry = DELETE_MAX_WAIT / (delay *= 10);
                if (DELETE_MAX_WAIT % delay == 0) continue;
                ++maxRetry;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        System.err.println();
        System.err.println("\t!!! ERROR: " + file + " was never deleted even after having waited " + DELETE_MAX_TIME + "ms!!!");
        System.err.println();
        return false;
    }

    public static boolean isFileDeleted(File file) {
        return !file.exists() && Util.getParentChildFile(file) == null;
    }

    private static File getParentChildFile(File file) {
        int length;
        File parent = file.getParentFile();
        if (parent == null || !parent.exists()) {
            return null;
        }
        File[] files = parent.listFiles();
        int n = length = files == null ? 0 : files.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (files[i] == file) {
                    return files[i];
                }
                if (files[i].equals(file)) {
                    return files[i];
                }
                if (files[i].getPath().equals(file.getPath())) {
                    return files[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean matchesSignatures(String signature, String signature2) {
        String[] parameterTypes2;
        int length2;
        if (!Util.matches(Signature.getReturnType((String)signature), Signature.getReturnType((String)signature2))) {
            return false;
        }
        String[] parameterTypes = Signature.getParameterTypes((String)signature);
        int length = parameterTypes.length;
        if (length != (length2 = (parameterTypes2 = Signature.getParameterTypes((String)signature2)).length)) {
            return false;
        }
        int i = 0;
        while (i < length2) {
            if (!Util.matches(parameterTypes[i], parameterTypes2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean matches(String type, String type2) {
        if (type.length() == 1) {
            if (type2.length() != 1) {
                return false;
            }
            return type.charAt(0) == type2.charAt(0);
        }
        if (type2.length() == 1) {
            return false;
        }
        char[] typeChars = type.toCharArray();
        char[] type2Chars = type2.toCharArray();
        if (typeChars[0] == '[') {
            if (type2Chars[0] != '[') {
                return false;
            }
            int dims1 = Signature.getArrayCount((char[])typeChars);
            if (dims1 != Signature.getArrayCount((char[])type2Chars)) {
                return false;
            }
            return Util.matches(CharOperation.subarray((char[])typeChars, (int)dims1, (int)typeChars.length), CharOperation.subarray((char[])type2Chars, (int)dims1, (int)type2Chars.length));
        }
        if (type2.charAt(0) == '[') {
            return false;
        }
        return Util.matches(typeChars, type2Chars);
    }

    private static boolean matches(char[] type, char[] type2) {
        char[] typeName = Signature.toCharArray((char[])type);
        char[] typeName2 = Signature.toCharArray((char[])type2);
        if (CharOperation.lastIndexOf((char)'$', (char[])typeName2) == -1) {
            int index = CharOperation.indexOf((char[])typeName, (char[])typeName2, (boolean)true);
            return index != -1 && index + typeName.length == typeName2.length;
        }
        int index = CharOperation.indexOf((char[])typeName, (char[])typeName2, (boolean)true);
        if (index != -1 && index + typeName.length == typeName2.length) {
            return true;
        }
        int dotIndex = CharOperation.lastIndexOf((char)'.', (char[])typeName);
        if (dotIndex == -1) {
            return false;
        }
        typeName[dotIndex] = 36;
        index = CharOperation.indexOf((char[])typeName, (char[])typeName2, (boolean)true);
        return index != -1 && index + typeName.length == typeName2.length;
    }

    public static Set convertAsSet(String[] values) {
        HashSet<String> set = new HashSet<String>();
        if (values != null && values.length != 0) {
            int i = 0;
            int max = values.length;
            while (i < max) {
                set.add(values[i]);
                ++i;
            }
        }
        return set;
    }

    public static String getDeltaComponentID(IApiComponent component) {
        StringBuffer buffer = new StringBuffer(component.getId());
        String version = component.getVersion();
        if (version != null) {
            buffer.append('_');
            try {
                Version version2 = new Version(version);
                buffer.append(version2.getMajor()).append('.').append(version2.getMinor()).append('.').append(version2.getMicro());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                buffer.append(version);
            }
        }
        return String.valueOf(buffer);
    }

    public static String getDeltaRestrictions(int restrictions) {
        StringBuffer buffer = new StringBuffer();
        if (RestrictionModifiers.isExtendRestriction(restrictions)) {
            buffer.append("NO_EXTEND");
        }
        if (RestrictionModifiers.isImplementRestriction(restrictions)) {
            buffer.append("NO_IMPLEMENT");
        }
        if (RestrictionModifiers.isOverrideRestriction(restrictions)) {
            buffer.append("NO_OVERRIDEN");
        }
        if (RestrictionModifiers.isInstantiateRestriction(restrictions)) {
            buffer.append("NO_INSTANTIATE");
        }
        if (RestrictionModifiers.isReferenceRestriction(restrictions)) {
            buffer.append("NO_REFERENCE");
        }
        if (RestrictionModifiers.isUnrestricted(restrictions)) {
            buffer.append("NO_RESTRICTIONS");
        }
        return String.valueOf(buffer);
    }

    public static String getDescriptorName(TypeDescriptor descriptor) {
        String typeName = descriptor.name;
        int index = typeName.lastIndexOf(36);
        if (index != -1) {
            return typeName.replace('$', '.');
        }
        return typeName;
    }

    public static String getDeltaArgumentString(IDelta delta) {
        String[] arguments = delta.getArguments();
        switch (delta.getFlags()) {
            case 46: 
            case 48: {
                return arguments[0];
            }
            case 8: 
            case 12: 
            case 16: 
            case 25: 
            case 27: 
            case 28: {
                return arguments[1];
            }
        }
        return "";
    }

    private static final class BuildJob
    extends Job {
        private final IProject[] fProjects;
        private int fBuildType;

        private BuildJob(String name, IProject[] projects) {
            this(name, projects, 6);
        }

        private BuildJob(String name, IProject[] projects, int buildType) {
            super(name);
            this.fProjects = projects;
            this.fBuildType = buildType;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }

        public boolean isCoveredBy(BuildJob other) {
            if (other.fProjects == null) {
                return true;
            }
            if (this.fProjects != null) {
                int i = 0;
                int max = this.fProjects.length;
                while (i < max) {
                    if (!other.contains(this.fProjects[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public boolean contains(IProject project) {
            if (project == null) {
                return false;
            }
            int i = 0;
            int max = this.fProjects.length;
            while (i < max) {
                if (project.equals((Object)this.fProjects[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] buildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int i = 0;
                while (i < buildJobs.length) {
                    BuildJob job;
                    Job curr = buildJobs[i];
                    if (curr != this && curr instanceof BuildJob && (job = (BuildJob)curr).isCoveredBy(this)) {
                        curr.cancel();
                    }
                    ++i;
                }
            }
            try {
                IStatus iStatus;
                try {
                    if (this.fProjects != null) {
                        int length = this.fProjects.length;
                        monitor.beginTask(UtilMessages.Util_0, length);
                        int i = 0;
                        while (i < length) {
                            IProject project = this.fProjects[i];
                            monitor.subTask(NLS.bind((String)UtilMessages.Util_5, (Object)project.getName()));
                            project.build(this.fBuildType, "org.eclipse.pde.api.tools.apiAnalysisBuilder", null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            monitor.worked(1);
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    iStatus = e.getStatus();
                    monitor.done();
                    return iStatus;
                }
                catch (OperationCanceledException operationCanceledException) {
                    iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

