/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.util.Util;

public class SDKTesterCreator {
    private static final String DEBUG_PROPERTY = "DEBUG";
    private static final String OVERRIDE = "-o";
    private static boolean DEBUG = false;
    static final CRC32 CRC32 = new CRC32();
    static boolean override = false;

    public static void main(String[] args) {
        File file;
        int i;
        File pluginsRoot;
        File componentXmlRoot;
        boolean bl = DEBUG = System.getProperty(DEBUG_PROPERTY) != null;
        if (args.length < 2) {
            return;
        }
        if (args.length == 3 && args[2].equals(OVERRIDE)) {
            override = true;
        }
        if (!(componentXmlRoot = new File(args[0])).exists() || !componentXmlRoot.isDirectory()) {
            System.err.println("Invalid component.xml root : " + args[0]);
            return;
        }
        File[] allComponentXmlFiles = Util.getAllFiles(componentXmlRoot, new FileFilter(){

            public boolean accept(File path) {
                return path.isFile() && path.getName().equals("component.xml") || path.isDirectory();
            }
        });
        if (allComponentXmlFiles == null) {
            System.err.println("No component.xml to process");
            return;
        }
        String[] allComponentXmlFileNames = new String[allComponentXmlFiles.length];
        int beginIndex = componentXmlRoot.getAbsolutePath().length() + 1;
        int i2 = 0;
        int max = allComponentXmlFiles.length;
        while (i2 < max) {
            File file2 = allComponentXmlFiles[i2];
            allComponentXmlFileNames[i2] = file2.getAbsolutePath().substring(beginIndex);
            ++i2;
        }
        Arrays.sort(allComponentXmlFileNames, new Comparator(){

            public int compare(Object o1, Object o2) {
                String fileName1 = (String)o1;
                String fileName2 = (String)o2;
                return fileName1.compareTo(fileName2);
            }
        });
        if (DEBUG) {
            int max2 = allComponentXmlFileNames.length;
            System.out.println(max2 + " files found");
            int i3 = 0;
            while (i3 < max2) {
                System.out.println("component.xml [" + i3 + "] = " + allComponentXmlFileNames[i3]);
                ++i3;
            }
        }
        if (!(pluginsRoot = new File(args[1])).exists() || !pluginsRoot.isDirectory()) {
            System.err.println("Invalid plugins root : " + args[1]);
            return;
        }
        File[] allPluginsFiles = pluginsRoot.listFiles();
        if (DEBUG && allPluginsFiles != null) {
            int max3 = allPluginsFiles.length;
            System.out.println(max3 + " plugins found");
            i = 0;
            int max2 = allPluginsFiles.length;
            while (i < max2) {
                file = allPluginsFiles[i];
                System.out.println(file.getAbsolutePath());
                ++i;
            }
        }
        if (allPluginsFiles == null) {
            System.err.println("No plugins to process");
            return;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        i = 0;
        int max4 = allPluginsFiles.length;
        while (i < max4) {
            file = allPluginsFiles[i];
            int result = SDKTesterCreator.getComponentXmlIndex(allComponentXmlFileNames, file);
            if (result >= 0) {
                list.add(new Integer(result));
                if (file.isDirectory()) {
                    SDKTesterCreator.processDirectoryEntry(file, new File(componentXmlRoot, allComponentXmlFileNames[result]));
                } else {
                    File outputFile = new File(file.getParent(), String.valueOf(file.getName()) + "_0");
                    if (SDKTesterCreator.processJarFile(file, outputFile, new File(componentXmlRoot, allComponentXmlFileNames[result]))) {
                        File oldFile = new File(file.getParent(), String.valueOf(file.getName()) + "_old");
                        if (Util.copy(file, oldFile)) {
                            if (file.delete()) {
                                if (outputFile.renameTo(file)) {
                                    oldFile.delete();
                                } else {
                                    System.err.println("Rename " + outputFile + " to " + file + " failed");
                                    outputFile.delete();
                                    oldFile.renameTo(file);
                                }
                            } else {
                                System.err.println("Could not delete " + file);
                                outputFile.delete();
                                oldFile.delete();
                            }
                        } else {
                            System.err.println("Could not create a backup for " + file);
                        }
                    } else {
                        outputFile.delete();
                    }
                }
            }
            ++i;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer index = (Integer)iterator.next();
            allComponentXmlFileNames[index.intValue()] = null;
        }
        i = 0;
        max = allComponentXmlFileNames.length;
        while (i < max) {
            String componentXmlFileName = allComponentXmlFileNames[i];
            if (componentXmlFileName != null) {
                System.err.println("This component.xml file " + componentXmlFileName + " was not matched");
            }
            ++i;
        }
    }

    private static void processDirectoryEntry(File file, File componentXmlFile) {
        block35: {
            File currentComponentXmlFile = new File(file, "component.xml");
            if (currentComponentXmlFile.exists()) {
                System.out.println("component.xml already exists");
                if (override) {
                    System.out.println("overriding component.xml for " + file);
                    if (!currentComponentXmlFile.delete()) {
                        System.err.println("Could not delete existing component.xml file (" + currentComponentXmlFile + ")");
                        return;
                    }
                } else {
                    return;
                }
            }
            if (DEBUG) {
                System.out.println("Add component.xml in " + file);
            }
            BufferedInputStream inputStream = null;
            FilterOutputStream outputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(componentXmlFile));
                byte[] bytes = Util.getInputStreamAsByteArray(inputStream, -1);
                outputStream = new BufferedOutputStream(new FileOutputStream(new File(file, "component.xml")));
                outputStream.write(bytes);
                ((BufferedOutputStream)outputStream).flush();
            }
            catch (FileNotFoundException e) {
                ApiPlugin.log(e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    break block35;
                }
                catch (IOException iOException) {}
                break block35;
            }
            catch (IOException e) {
                try {
                    ApiPlugin.log(e);
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    break block35;
                }
                catch (IOException iOException) {}
                break block35;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Loose catch block
     */
    private static boolean processJarFile(File inputFile, File outputFile, File componentXMLFile) {
        block28: {
            ZipOutputStream zipOutputStream;
            ZipInputStream inputStream;
            block25: {
                block26: {
                    inputStream = null;
                    zipOutputStream = null;
                    try {
                        zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                    }
                    catch (FileNotFoundException e) {
                        ApiPlugin.log(e);
                    }
                    if (zipOutputStream == null) {
                        System.err.println("Could not create the output file : " + outputFile);
                        return false;
                    }
                    inputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
                    if (!SDKTesterCreator.processArchiveEntry(inputStream, zipOutputStream, componentXMLFile) || !DEBUG) break block25;
                    System.out.println("Add component.xml in " + inputFile);
                    if (inputStream == null) break block26;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    zipOutputStream.flush();
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
                return true;
                catch (IOException e) {
                    block27: {
                        try {
                            ApiPlugin.log(e);
                            if (inputStream == null) break block27;
                        }
                        catch (Throwable throwable) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            try {
                                zipOutputStream.flush();
                                zipOutputStream.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    try {
                        zipOutputStream.flush();
                        zipOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block28;
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            try {
                zipOutputStream.flush();
                zipOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private static boolean processArchiveEntry(ZipInputStream inputStream, ZipOutputStream zipOutputStream, File componentXmlFile) throws IOException {
        byte[] bytes = null;
        ZipEntry zipEntry = inputStream.getNextEntry();
        boolean containsComponentXML = false;
        while (zipEntry != null) {
            String name = zipEntry.getName();
            bytes = Util.getInputStreamAsByteArray(inputStream, (int)zipEntry.getSize());
            if (name.equals("component.xml")) {
                containsComponentXML = true;
                if (override) {
                    bytes = null;
                    containsComponentXML = false;
                }
            }
            if (bytes != null) {
                SDKTesterCreator.writeZipFileEntry(zipOutputStream, name, bytes, CRC32);
            }
            inputStream.closeEntry();
            zipEntry = inputStream.getNextEntry();
        }
        if (!containsComponentXML && componentXmlFile != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(componentXmlFile));
            bytes = Util.getInputStreamAsByteArray(bufferedInputStream, -1);
            bufferedInputStream.close();
            if (bytes != null) {
                SDKTesterCreator.writeZipFileEntry(zipOutputStream, "component.xml", bytes, CRC32);
                return true;
            }
            System.err.println("Could not retrieve the contents of " + componentXmlFile);
        }
        return false;
    }

    private static void writeZipFileEntry(ZipOutputStream outputStream, String entryName, byte[] bytes, CRC32 crc32) throws IOException {
        crc32.reset();
        int byteArraySize = bytes.length;
        crc32.update(bytes, 0, byteArraySize);
        ZipEntry entry = new ZipEntry(entryName);
        entry.setMethod(8);
        entry.setSize(byteArraySize);
        entry.setCrc(crc32.getValue());
        outputStream.putNextEntry(entry);
        outputStream.write(bytes, 0, byteArraySize);
        outputStream.closeEntry();
    }

    private static int getComponentXmlIndex(String[] allComponentXmlFileNames, File file) {
        String fileName = file.getName();
        int index = fileName.indexOf(95);
        String key = String.valueOf(index == -1 ? fileName : fileName.substring(0, index)) + File.separator + "component.xml";
        int result = Arrays.binarySearch(allComponentXmlFileNames, key);
        return result;
    }
}

