/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class ApiExtractorAdapter
extends ClassAdapter {
    private List localCollector;
    private boolean ignore = true;
    private String name;
    private Set collector;

    public ApiExtractorAdapter(Set collector) {
        super((ClassVisitor)new EmptyVisitor());
        this.collector = collector;
        this.localCollector = new ArrayList();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 1) != 0) {
            this.ignore = false;
        }
        this.name = name;
    }

    public void visitInnerClass(String innerClassName, String outerName, String innerName, int access) {
        if (this.name.equals(innerClassName) && (outerName == null || innerName == null)) {
            this.ignore = true;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 5) != 0) {
            StringBuffer buffer = new StringBuffer(this.name);
            buffer.append('#').append(name).append(desc);
            this.collect(String.valueOf(buffer));
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 5) != 0) {
            StringBuffer buffer = new StringBuffer(this.name);
            buffer.append('#').append(name).append(desc);
            this.collect(String.valueOf(buffer));
        }
        return null;
    }

    private void collect(String value) {
        this.localCollector.add(value);
    }

    public void visitEnd() {
        if (!this.ignore) {
            this.collector.addAll(this.localCollector);
        }
    }
}

