/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchScope;

public class TypeScope
implements IApiSearchScope {
    private IApiComponent fComponent;
    private Map fPackageToTypes;

    public TypeScope(IApiComponent component, IReferenceTypeDescriptor[] types) {
        this.fComponent = component;
        this.fPackageToTypes = new HashMap();
        int i = 0;
        while (i < types.length) {
            IReferenceTypeDescriptor type = types[i];
            String name = type.getPackage().getName();
            HashSet<IReferenceTypeDescriptor> set = (HashSet<IReferenceTypeDescriptor>)this.fPackageToTypes.get(name);
            if (set == null) {
                set = new HashSet<IReferenceTypeDescriptor>();
                this.fPackageToTypes.put(name, set);
            }
            set.add(type);
            ++i;
        }
    }

    public boolean encloses(String componentId, IElementDescriptor element) {
        if (this.getOrigin().equals(componentId)) {
            IReferenceTypeDescriptor type;
            String pkg;
            Set types;
            if (element.getElementType() == 5 || element.getElementType() == 6) {
                element = ((IMemberDescriptor)element).getEnclosingType();
            }
            if (element.getElementType() == 2 && (types = (Set)this.fPackageToTypes.get(pkg = (type = (IReferenceTypeDescriptor)element).getPackage().getName())) != null) {
                return types.contains(type);
            }
        }
        return false;
    }

    public String getOrigin() {
        return this.fComponent.getId();
    }

    public String[] getPackageNames() throws CoreException {
        Set pkgs = this.fPackageToTypes.keySet();
        return pkgs.toArray(new String[pkgs.size()]);
    }

    public void accept(ClassFileContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this.fComponent)) {
            Set entrySet = this.fPackageToTypes.entrySet();
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String pkg = (String)entry.getKey();
                if (visitor.visitPackage(pkg)) {
                    Set types = (Set)entry.getValue();
                    Iterator typeIter = types.iterator();
                    while (typeIter.hasNext()) {
                        IReferenceTypeDescriptor type = (IReferenceTypeDescriptor)typeIter.next();
                        IClassFile classFile = this.fComponent.findClassFile(type.getQualifiedName());
                        if (classFile == null) continue;
                        visitor.visit(pkg, classFile);
                        visitor.end(pkg, classFile);
                    }
                }
                visitor.endVisitPackage(pkg);
            }
        }
        visitor.end(this.fComponent);
    }

    public void close() throws CoreException {
    }

    public IClassFile findClassFile(String qualifiedName) throws CoreException {
        IReferenceTypeDescriptor descriptor = Factory.typeDescriptor(qualifiedName);
        if (this.encloses(this.getOrigin(), descriptor)) {
            return this.fComponent.findClassFile(qualifiedName);
        }
        return null;
    }

    public IClassFile findClassFile(String qualifiedName, String id) throws CoreException {
        if (this.getOrigin().equals(id)) {
            return this.findClassFile(qualifiedName);
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("*** Type Search Scope ***\n");
        buffer.append("Component: ").append(this.fComponent);
        if (this.fPackageToTypes != null) {
            String pack = null;
            Iterator iter = this.fPackageToTypes.keySet().iterator();
            while (iter.hasNext()) {
                pack = (String)iter.next();
                buffer.append("Package: ").append(pack).append("\n");
                buffer.append("Types: ").append(this.fPackageToTypes.get(pack).toString()).append("\n");
            }
        }
        return buffer.toString();
    }
}

