/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.util.ClassVisitorAdapter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.MethodVisitor;

public class MethodExtractor
extends ClassVisitorAdapter {
    private List fMethods = new ArrayList();
    private IMethodDescriptor[] fDescriptors = null;
    private IReferenceTypeDescriptor fType;
    private String fSuperName;
    private String[] fInterfaces;

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.fType = Util.getType(name.replace('/', '.'));
        if (superName != null) {
            this.fSuperName = superName.replace('/', '.');
        }
        if (interfaces != null) {
            this.fInterfaces = new String[interfaces.length];
            int i = 0;
            while (i < interfaces.length) {
                this.fInterfaces[i] = interfaces[i].replace('/', '.');
                ++i;
            }
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.fMethods.add(this.fType.getMethod(name, desc, access));
        return null;
    }

    public IMethodDescriptor[] getMethods() {
        if (this.fDescriptors == null) {
            this.fDescriptors = this.fMethods.toArray(new IMethodDescriptor[this.fMethods.size()]);
        }
        return this.fDescriptors;
    }

    public String getSuperclassName() {
        return this.fSuperName;
    }

    public String[] getInteraces() {
        return this.fInterfaces;
    }
}

