/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.ILocation;
import org.eclipse.pde.api.tools.internal.util.Util;

public class Location
implements ILocation {
    private IApiComponent fComponent = null;
    private IMemberDescriptor fElement;
    private int linenumber = -1;

    public Location(IApiComponent component, IMemberDescriptor element) {
        this.fComponent = component;
        this.fElement = element;
    }

    public boolean equals(Object obj) {
        Location loc;
        if (obj instanceof Location && (loc = (Location)obj).getMember().equals(this.getMember()) && loc.getLineNumber() == this.getLineNumber()) {
            return Util.equalsOrNull(this.getApiComponent(), loc.getApiComponent());
        }
        return false;
    }

    public IApiComponent getApiComponent() {
        return this.fComponent;
    }

    public int getLineNumber() {
        return this.linenumber;
    }

    public IMemberDescriptor getMember() {
        return this.fElement;
    }

    public IReferenceTypeDescriptor getType() {
        IMemberDescriptor member = this.getMember();
        if (member instanceof IReferenceTypeDescriptor) {
            return (IReferenceTypeDescriptor)member;
        }
        return member.getEnclosingType();
    }

    public int hashCode() {
        return this.fElement.hashCode() + this.linenumber;
    }

    public void setApiComponent(IApiComponent component) {
        this.fComponent = component;
    }

    public void setLineNumber(int value) {
        this.linenumber = value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("location [");
        buffer.append(this.getMember().toString());
        buffer.append(" from: ");
        if (this.fComponent == null) {
            buffer.append(" <unresolved component>");
        } else {
            buffer.append(this.fComponent);
        }
        buffer.append(" line: " + this.linenumber);
        buffer.append("]");
        return buffer.toString();
    }
}

