/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.eclipse.jdt.core.Signature;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.ILocation;
import org.eclipse.pde.api.tools.internal.provisional.search.IReference;
import org.eclipse.pde.api.tools.internal.search.Location;
import org.eclipse.pde.api.tools.internal.search.Reference;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ClassFileVisitor
extends ClassAdapter {
    private static boolean DEBUG = Util.DEBUG;
    private List collector = null;
    private IApiComponent fComponent = null;
    String classname = null;
    private IReferenceTypeDescriptor fType;
    private Stack fMemberStack = new Stack();
    private Stack fSuperStack = new Stack();
    private boolean fIncludeLocalRefs = false;
    private int fReferenceKinds = 0;
    private static final int VISIT_MEMBERS_MASK = 0x7FFFFFFC;
    private boolean fIsVisitMembers = false;
    private ClassFileSignatureVisitor signaturevisitor = new ClassFileSignatureVisitor();
    private static int TYPE = 0;
    private static int FIELD = 1;
    private static int METHOD = 2;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public ClassFileVisitor(IApiComponent component, List collector, int referenceKinds) {
        super((ClassVisitor)new ClassNode());
        this.fComponent = component;
        this.collector = collector;
        this.fReferenceKinds = referenceKinds;
        this.fIsVisitMembers = (0x7FFFFFFC & this.fReferenceKinds) > 0;
    }

    protected boolean consider(String owner) {
        if (this.fIncludeLocalRefs) {
            return true;
        }
        return !this.classname.equals(owner) && !this.classname.startsWith(owner) && !"<clinit>".equals(owner) && !"this".equals(owner);
    }

    protected boolean consider(int refKind, IMemberDescriptor element) {
        IReferenceTypeDescriptor enclosingType;
        if (this.fIncludeLocalRefs) {
            return true;
        }
        if (element.getElementType() == 2 ? ((IReferenceTypeDescriptor)element).isAnonymous() : (enclosingType = element.getEnclosingType()).isAnonymous()) {
            return false;
        }
        if (refKind == 256 || refKind == 0x10000000) {
            return true;
        }
        IElementDescriptor temp = element;
        while (temp.getElementType() != 1) {
            if (this.fType.equals(temp)) {
                return true;
            }
            temp = temp.getParent();
        }
        IReferenceTypeDescriptor enclosing = this.fType.getEnclosingType();
        while (enclosing != null) {
            if (element.equals(enclosing)) {
                return false;
            }
            enclosing = enclosing.getEnclosingType();
        }
        return true;
    }

    protected String processName(String name) {
        String newname = name;
        Type type = Type.getObjectType((String)name);
        if (type != null && type.getSort() == 10) {
            newname = type.getInternalName();
        }
        return newname.replaceAll("/", ".");
    }

    protected IReference addTypeReference(Type type, int kind) {
        Type rtype = this.resolveType(type.getDescriptor());
        if (rtype != null) {
            IReferenceTypeDescriptor target = Util.getType(rtype.getClassName());
            return this.addReference(target, kind);
        }
        return null;
    }

    protected IReference addFieldReference(Type declaringType, String name, int kind) {
        Type rtype = this.resolveType(declaringType.getDescriptor());
        if (rtype != null) {
            IReferenceTypeDescriptor target = Util.getType(rtype.getClassName());
            return this.addReference(target.getField(name), kind);
        }
        return null;
    }

    protected IReference addMethodReference(Type declaringType, String name, String signature, int kind) {
        Type rtype = this.resolveType(declaringType.getDescriptor());
        if (rtype != null) {
            IReferenceTypeDescriptor target = Util.getType(rtype.getClassName());
            return this.addReference(target.getMethod(name, signature), kind);
        }
        return null;
    }

    protected IReference addMethodDeclaration(IMethodDescriptor method) {
        return this.addReference(method, 0x10000000);
    }

    protected IReference addReference(IMemberDescriptor target, int kind) {
        if (this.consider(kind, target)) {
            Reference ref = new Reference(new Location(this.fComponent, this.getMember()), new Location(null, target), kind);
            this.collector.add(ref);
            return ref;
        }
        return null;
    }

    protected List processSignature(String name, String signature, int kind, int type) {
        SignatureReader reader = new SignatureReader(signature);
        this.signaturevisitor.kind = kind;
        this.signaturevisitor.name = this.processName(name);
        this.signaturevisitor.signature = signature;
        this.signaturevisitor.originalkind = kind;
        this.signaturevisitor.argumentcount = 0;
        this.signaturevisitor.type = type;
        if (kind == 0x200000 || kind == 0x800000) {
            reader.accept((SignatureVisitor)this.signaturevisitor);
        } else {
            reader.acceptType((SignatureVisitor)this.signaturevisitor);
        }
        ArrayList result = new ArrayList();
        result.addAll(this.signaturevisitor.references);
        this.collector.addAll(this.signaturevisitor.references);
        this.signaturevisitor.reset();
        return result;
    }

    protected Type resolveType(String desc) {
        Type type = Type.getType((String)desc);
        if (type.getSort() == 10) {
            return type;
        }
        if (type.getSort() == 9 && (type = type.getElementType()).getSort() == 10) {
            return type;
        }
        return null;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classname = this.processName(name);
        this.fType = Util.getType(this.classname, access);
        if (DEBUG) {
            System.out.println("Starting visit of type: [" + this.fType.getQualifiedName() + "]");
        }
        this.enterMember(this.fType);
        if (signature != null) {
            this.processSignature(name, signature, 0x200000, TYPE);
        } else if ((access & 0x200) != 0) {
            Type supertype = null;
            int i = 0;
            while (i < interfaces.length) {
                supertype = Type.getObjectType((String)interfaces[i]);
                IReference typeReference = this.addTypeReference(supertype, 1);
                if (typeReference != null) {
                    this.fSuperStack.add(typeReference.getReferencedLocation().getType());
                }
                ++i;
            }
        } else {
            IReference typeReference;
            Type supertype = null;
            if (superName != null && (typeReference = this.addTypeReference(supertype = Type.getObjectType((String)superName), 1)) != null) {
                this.fSuperStack.add(typeReference.getReferencedLocation().getType());
            }
            int i = 0;
            while (i < interfaces.length) {
                supertype = Type.getObjectType((String)interfaces[i]);
                this.addTypeReference(supertype, 2);
                ++i;
            }
        }
    }

    public void visitEnd() {
        this.exitMember();
        if (!this.fSuperStack.isEmpty()) {
            IReferenceTypeDescriptor type = (IReferenceTypeDescriptor)this.fSuperStack.pop();
            if (DEBUG) {
                System.out.println("ending visit of type: [" + type.getQualifiedName() + "]");
            }
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.fIsVisitMembers) {
            IReferenceTypeDescriptor owner = (IReferenceTypeDescriptor)this.getMember();
            IFieldDescriptor field = owner.getField(name, access);
            this.enterMember(field);
            if ((access & 0x1000) == 0) {
                if (signature != null) {
                    this.processSignature(name, signature, 0x400000, FIELD);
                } else {
                    this.addTypeReference(Type.getType((String)desc), 4);
                }
            }
            this.exitMember();
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.fIsVisitMembers) {
            IMemberDescriptor member = this.getMember();
            IReferenceTypeDescriptor owner = null;
            owner = member instanceof IReferenceTypeDescriptor ? (IReferenceTypeDescriptor)member : member.getEnclosingType();
            IMethodDescriptor method = owner.getMethod(name, desc, access);
            this.enterMember(method);
            if ((access & 5) > 0 && !this.fSuperStack.isEmpty()) {
                IReferenceTypeDescriptor superType = (IReferenceTypeDescriptor)this.fSuperStack.peek();
                this.addMethodDeclaration(superType.getMethod(method.getName(), method.getSignature(), method.getModifiers()));
            }
            if ((access & 0x1000) == 0 && !"<clinit>".equals(name)) {
                int argumentcount = 0;
                if (signature != null) {
                    this.processSignature(name, signature, 0x800000, METHOD);
                    argumentcount = this.signaturevisitor.argumentcount;
                } else {
                    Type[] arguments = Type.getArgumentTypes((String)desc);
                    int i = 0;
                    while (i < arguments.length) {
                        Type type = arguments[i];
                        this.addTypeReference(type, 16);
                        argumentcount += type.getSize();
                        ++i;
                    }
                    this.addTypeReference(Type.getReturnType((String)desc), 8);
                    if (exceptions != null) {
                        i = 0;
                        while (i < exceptions.length) {
                            this.addTypeReference(Type.getObjectType((String)exceptions[i]), 32);
                            ++i;
                        }
                    }
                }
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (mv != null && (access & 0x500) == 0) {
                    return new ClassFileMethodVisitor(mv, name, argumentcount);
                }
            }
        }
        return null;
    }

    protected void enterMember(IMemberDescriptor member) {
        this.fMemberStack.push(member);
    }

    protected void exitMember() {
        this.fMemberStack.pop();
    }

    protected IMemberDescriptor getMember() {
        return (IMemberDescriptor)this.fMemberStack.peek();
    }

    class ClassFileMethodVisitor
    extends MethodAdapter {
        int argumentcount = 0;
        LinePositionTracker linePositionTracker;
        String stringLiteral;
        int lastLineNumber;
        LocalLineNumberMarker localVariableMarker;
        HashMap labelsToLocalMarkers;

        public ClassFileMethodVisitor(MethodVisitor mv, String name, int argumentcount) {
            super(mv);
            this.argumentcount = argumentcount;
            this.linePositionTracker = new LinePositionTracker();
            this.lastLineNumber = -1;
            this.labelsToLocalMarkers = new HashMap();
        }

        public void visitEnd() {
            this.argumentcount = 0;
            ClassFileVisitor.this.exitMember();
            this.linePositionTracker.computeLineNumbers();
            this.labelsToLocalMarkers = null;
        }

        public void visitVarInsn(int opcode, int var) {
            switch (opcode) {
                case 58: {
                    if (this.lastLineNumber == -1) break;
                    this.localVariableMarker = new LocalLineNumberMarker(this.lastLineNumber, var);
                }
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            IReference reference;
            if ((opcode == 179 || opcode == 181 || opcode == 178 || opcode == 180) && (reference = ClassFileVisitor.this.addFieldReference(Type.getObjectType((String)owner), name, opcode == 181 ? 16384 : 4096)) != null) {
                this.linePositionTracker.addLocation(reference.getSourceLocation());
            }
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            Type ctype;
            IReference reference;
            if (type != null && (reference = ClassFileVisitor.this.addTypeReference(ctype = Type.getObjectType((String)type), 131072)) != null) {
                ILocation sourceLocation = reference.getSourceLocation();
                this.linePositionTracker.addCatchLabelInfos(sourceLocation, handler);
                this.linePositionTracker.addLocation(sourceLocation);
            }
        }

        public void visitLabel(Label label) {
            this.linePositionTracker.addLabel(label);
            if (this.localVariableMarker != null) {
                this.localVariableMarker.label = label;
                Object object = this.labelsToLocalMarkers.get(label);
                if (object != null) {
                    if (object instanceof List) {
                        ((List)object).add(this.localVariableMarker);
                    } else {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(object);
                        list.add(this.localVariableMarker);
                        this.labelsToLocalMarkers.put(label, list);
                    }
                } else {
                    this.labelsToLocalMarkers.put(label, this.localVariableMarker);
                }
                this.localVariableMarker = null;
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            IReference reference;
            Type declaringType = Type.getObjectType((String)owner);
            int kind = -1;
            switch (opcode) {
                case 183: {
                    int n = kind = "<init>".equals(name) ? 64 : 0x100000;
                    if (kind != 64 || (reference = ClassFileVisitor.this.addTypeReference(declaringType, 0x8000000)) == null) break;
                    this.linePositionTracker.addLocation(reference.getSourceLocation());
                    break;
                }
                case 184: {
                    Type classLiteral;
                    IReference reference2;
                    kind = 128;
                    if (!name.equals("forName") || !ClassFileVisitor.this.processName(owner).equals("java.lang.Class") || this.stringLiteral == null || (reference2 = ClassFileVisitor.this.addTypeReference(classLiteral = Type.getObjectType((String)this.stringLiteral), 0x4000000)) == null) break;
                    this.linePositionTracker.addLocation(reference2.getSourceLocation());
                    break;
                }
                case 182: {
                    kind = 256;
                    break;
                }
                case 185: {
                    kind = 512;
                }
            }
            if (kind != -1 && (reference = ClassFileVisitor.this.addMethodReference(declaringType, name, desc, kind)) != null) {
                this.linePositionTracker.addLocation(reference.getSourceLocation());
            }
            this.stringLiteral = null;
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            Type type = this.getTypeFromDescription(desc);
            IReference reference = ClassFileVisitor.this.addTypeReference(type, 32768);
            if (reference != null) {
                this.linePositionTracker.addLocation(reference.getSourceLocation());
            }
        }

        public void visitLineNumber(int line, Label start) {
            this.lastLineNumber = line;
            this.linePositionTracker.addLineInfo(line, start);
        }

        private Type getTypeFromDescription(String desc) {
            while (desc.charAt(0) == '[') {
                desc = desc.substring(1);
            }
            Type type = null;
            type = desc.length() == 1 && Signature.getTypeSignatureKind((String)desc) == 2 ? Type.getType((String)desc) : (desc.endsWith(";") ? Type.getType((String)desc) : Type.getObjectType((String)desc));
            return type;
        }

        public void visitTypeInsn(int opcode, String desc) {
            Type type = this.getTypeFromDescription(desc);
            if (type.getSort() == 10) {
                IReference reference;
                int kind = -1;
                switch (opcode) {
                    case 189: {
                        kind = 32768;
                        break;
                    }
                    case 192: {
                        kind = 262144;
                        break;
                    }
                    case 193: {
                        kind = 524288;
                    }
                }
                if (kind != -1 && (reference = ClassFileVisitor.this.addTypeReference(type, kind)) != null) {
                    this.linePositionTracker.addLocation(reference.getSourceLocation());
                }
            }
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (desc.length() == 1) {
                return;
            }
            if (index > this.argumentcount) {
                Object object = this.labelsToLocalMarkers.get(start);
                int lineNumber = -1;
                if (object != null) {
                    if (object instanceof List) {
                        List markersList = (List)object;
                        LocalLineNumberMarker removeMarker = null;
                        Iterator iterator = markersList.iterator();
                        while (iterator.hasNext()) {
                            LocalLineNumberMarker marker = (LocalLineNumberMarker)iterator.next();
                            if (marker.varIndex != index) continue;
                            lineNumber = marker.lineNumber;
                            removeMarker = marker;
                            break;
                        }
                        if (removeMarker != null) {
                            markersList.remove(removeMarker);
                            if (markersList.isEmpty()) {
                                this.labelsToLocalMarkers.remove(start);
                            }
                        }
                    } else {
                        LocalLineNumberMarker marker = (LocalLineNumberMarker)object;
                        if (marker.varIndex == index) {
                            lineNumber = marker.lineNumber;
                            this.labelsToLocalMarkers.remove(start);
                        }
                    }
                }
                if (lineNumber == -1) {
                    return;
                }
                if (signature != null) {
                    List references = ClassFileVisitor.this.processSignature(name, signature, 0x1000000, METHOD);
                    Iterator iterator = references.iterator();
                    while (iterator.hasNext()) {
                        IReference reference = (IReference)iterator.next();
                        ILocation sourceLocation = reference.getSourceLocation();
                        sourceLocation.setLineNumber(lineNumber);
                        ILocation targetLocation = reference.getReferencedLocation();
                        targetLocation.setLineNumber(lineNumber);
                    }
                } else {
                    IReference reference;
                    Type type = Type.getType((String)desc);
                    if (type.getSort() == 10 && (reference = ClassFileVisitor.this.addTypeReference(type, 0x2000000)) != null) {
                        ILocation sourceLocation = reference.getSourceLocation();
                        sourceLocation.setLineNumber(lineNumber);
                    }
                }
            }
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                Type type = (Type)cst;
                IReference reference = ClassFileVisitor.this.addTypeReference(type, 0x4000000);
                if (reference != null) {
                    this.linePositionTracker.addLocation(reference.getSourceLocation());
                }
            } else if (cst instanceof String) {
                this.stringLiteral = (String)cst;
            }
        }
    }

    class ClassFileSignatureVisitor
    implements SignatureVisitor {
        protected int kind = -1;
        protected int originalkind = -1;
        protected int argumentcount = 0;
        protected int type = 0;
        protected String signature = null;
        protected String name = null;
        protected List references = new ArrayList();

        protected void reset() {
            this.kind = -1;
            this.originalkind = -1;
            this.name = null;
            this.signature = null;
            this.type = 0;
            this.references.clear();
        }

        protected void processType(String name) {
            Type type = ClassFileVisitor.this.resolveType(Type.getObjectType((String)name).getDescriptor());
            if (type != null) {
                String tname = type.getClassName();
                if (tname.equals("E") || tname.equals("T")) {
                    type = Type.getObjectType((String)"java.lang.Object");
                    tname = type.getClassName();
                }
                if (ClassFileVisitor.this.consider(tname) && this.kind != -1 && this.name != null && this.signature != null) {
                    IReferenceTypeDescriptor target = Util.getType(tname);
                    target = target.getPackage().getType(target.getName(), this.signature);
                    this.references.add(new Reference(new Location(ClassFileVisitor.this.fComponent, ClassFileVisitor.this.getMember()), new Location(null, target), this.kind));
                }
            }
            this.kind = this.originalkind;
        }

        public void visitClassType(String name) {
            this.processType(name);
        }

        public void visitFormalTypeParameter(String name) {
            if (this.type != TYPE) {
                this.processType(name);
            }
        }

        public void visitTypeVariable(String name) {
            this.processType(name);
        }

        public void visitInnerClassType(String name) {
            this.processType(name);
        }

        public SignatureVisitor visitParameterType() {
            ++this.argumentcount;
            this.kind = 16;
            return this;
        }

        public SignatureVisitor visitInterface() {
            this.kind = 2;
            return this;
        }

        public SignatureVisitor visitExceptionType() {
            this.kind = 32;
            return this;
        }

        public SignatureVisitor visitArrayType() {
            return this;
        }

        public SignatureVisitor visitReturnType() {
            this.kind = 8;
            return this;
        }

        public SignatureVisitor visitClassBound() {
            this.kind = 0x200000;
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            this.kind = 0x200000;
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            this.kind = 1;
            return this;
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return this;
        }

        public void visitEnd() {
        }

        public void visitBaseType(char descriptor) {
            switch (descriptor) {
                case 'D': 
                case 'J': {
                    this.argumentcount += 2;
                    break;
                }
                default: {
                    ++this.argumentcount;
                }
            }
        }

        public void visitTypeArgument() {
        }
    }

    static class LabelInfo {
        public ILocation location;
        public Label label;

        public LabelInfo(ILocation location, Label label) {
            this.location = location;
            this.label = label;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append('(').append(this.label).append(',').append(this.location).append(')');
            return String.valueOf(buffer);
        }
    }

    static class LineInfo
    implements Comparable {
        int line;
        Label label;

        LineInfo(int line, Label label) {
            this.line = line;
            this.label = label;
        }

        public int compareTo(Object o) {
            return this.line - ((LineInfo)o).line;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append('(').append(this.line).append(',').append(this.label).append(')');
            return String.valueOf(buffer);
        }
    }

    static class LinePositionTracker {
        List labelsAndLocations = new ArrayList();
        SortedSet lineInfos = new TreeSet();
        List catchLabelInfos = new ArrayList();
        HashMap lineMap = new HashMap();

        void addLocation(ILocation location) {
            this.labelsAndLocations.add(location);
        }

        void addLineInfo(int line, Label label) {
            this.lineInfos.add(new LineInfo(line, label));
            this.lineMap.put(label, new Integer(line));
        }

        void addCatchLabelInfos(ILocation location, Label label) {
            this.catchLabelInfos.add(new LabelInfo(location, label));
        }

        void addLabel(Label label) {
            this.labelsAndLocations.add(label);
        }

        public void computeLineNumbers() {
            if (this.lineInfos.size() < 1 || this.labelsAndLocations.size() < 1) {
                return;
            }
            Iterator lineInfosIterator = this.lineInfos.iterator();
            LineInfo firstLineInfo = (LineInfo)lineInfosIterator.next();
            int currentLineNumber = firstLineInfo.line;
            ArrayList<LabelInfo> remainingCatchLabelInfos = new ArrayList<LabelInfo>();
            Iterator iterator = this.catchLabelInfos.iterator();
            while (iterator.hasNext()) {
                LabelInfo catchLabelInfo = (LabelInfo)iterator.next();
                Integer lineValue = (Integer)this.lineMap.get(catchLabelInfo.label);
                if (lineValue != null) {
                    catchLabelInfo.location.setLineNumber(lineValue);
                    continue;
                }
                remainingCatchLabelInfos.add(catchLabelInfo);
            }
            ArrayList<LineInfo> computedEntries = new ArrayList<LineInfo>();
            Iterator iterator2 = this.labelsAndLocations.iterator();
            while (iterator2.hasNext()) {
                Object current = iterator2.next();
                if (current instanceof Label) {
                    Integer lineValue = (Integer)this.lineMap.get(current);
                    if (lineValue != null) {
                        computedEntries.add(new LineInfo(lineValue, (Label)current));
                        continue;
                    }
                    computedEntries.add((LineInfo)current);
                    continue;
                }
                computedEntries.add((LineInfo)current);
            }
            Iterator iterator3 = computedEntries.iterator();
            while (iterator3.hasNext()) {
                Object current = iterator3.next();
                if (current instanceof Label) {
                    if (remainingCatchLabelInfos == null) continue;
                    ArrayList<LabelInfo> remaingEntriesTemp = new ArrayList<LabelInfo>();
                    Iterator catchLabelInfosIterator = remainingCatchLabelInfos.iterator();
                    while (catchLabelInfosIterator.hasNext()) {
                        LabelInfo catchLabelInfo = (LabelInfo)catchLabelInfosIterator.next();
                        if (!current.equals(catchLabelInfo.label)) {
                            remaingEntriesTemp.add(catchLabelInfo);
                            continue;
                        }
                        catchLabelInfo.location.setLineNumber(currentLineNumber);
                    }
                    if (remaingEntriesTemp.size() == 0) {
                        remainingCatchLabelInfos = null;
                        continue;
                    }
                    remainingCatchLabelInfos = remaingEntriesTemp;
                    continue;
                }
                if (current instanceof ILocation) {
                    ILocation location = (ILocation)current;
                    if (location.getLineNumber() == -1) {
                        ((ILocation)current).setLineNumber(currentLineNumber);
                        continue;
                    }
                    currentLineNumber = location.getLineNumber();
                    continue;
                }
                if (!(current instanceof LineInfo)) continue;
                LineInfo lineInfo = (LineInfo)current;
                currentLineNumber = lineInfo.line;
            }
        }
    }

    static class LocalLineNumberMarker {
        int lineNumber;
        int varIndex;
        Label label;

        public LocalLineNumberMarker(int line, int varIndex) {
            this.lineNumber = line;
            this.varIndex = varIndex;
        }

        public boolean equals(Object obj) {
            LocalLineNumberMarker marker = (LocalLineNumberMarker)obj;
            return this.lineNumber == marker.lineNumber && this.varIndex == marker.varIndex;
        }

        public int hashCode() {
            return this.varIndex;
        }
    }
}

