/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.scanner;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.pde.api.tools.internal.CompilationUnit;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.search.MethodExtractor;
import org.eclipse.pde.api.tools.internal.util.HashtableOfInt;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class TagScanner {
    private static boolean DEBUG = Util.DEBUG;
    private static TagScanner fSingleton = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public static final TagScanner newScanner() {
        if (fSingleton == null) {
            fSingleton = new TagScanner();
        }
        return fSingleton;
    }

    private TagScanner() {
    }

    public void scan(CompilationUnit source, IApiDescription description) throws CoreException {
        this.scan(source, description, null);
    }

    public void scan(CompilationUnit source, IApiDescription description, IClassFileContainer container) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)3);
        InputStream inputStream = null;
        try {
            try {
                inputStream = source.getInputStream();
                parser.setSource(Util.getInputStreamAsCharArray(inputStream, -1, System.getProperty("file.encoding")));
            }
            catch (FileNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Compilation unit source not found: {0}", source.getName()), (Throwable)e));
            }
            catch (IOException e) {
                if (DEBUG) {
                    System.err.println(source.getName());
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Error reading compilation unit: {0}", source.getName()), (Throwable)e));
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        org.eclipse.jdt.core.dom.CompilationUnit cunit = (org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
        Visitor visitor = new Visitor(description, container);
        cunit.accept((ASTVisitor)visitor);
        if (visitor.getException() != null) {
            throw visitor.getException();
        }
    }

    class Visitor
    extends ASTVisitor {
        private IApiDescription fDescription = null;
        private IPackageDescriptor fPackage = Factory.packageDescriptor("");
        private IReferenceTypeDescriptor fType = null;
        private IClassFileContainer fContainer = null;
        private Map fMethodMappings = null;
        private CoreException fException;

        public Visitor(IApiDescription description, IClassFileContainer container) {
            this.fDescription = description;
            this.fContainer = container;
        }

        public boolean visit(Javadoc node) {
            List tags = node.tags();
            ASTNode parent = node.getParent();
            if (parent != null) {
                switch (parent.getNodeType()) {
                    case 71: {
                        this.processTags(this.fType, tags, 1, 16);
                        break;
                    }
                    case 55: {
                        TypeDeclaration type = (TypeDeclaration)parent;
                        if (type.isInterface()) {
                            this.processTags(this.fType, tags, 2, 16);
                            break;
                        }
                        this.processTags(this.fType, tags, 1, 16);
                        break;
                    }
                    case 31: {
                        MethodDeclaration method = (MethodDeclaration)parent;
                        String signature = Util.getMethodSignatureFromNode(method);
                        if (signature == null) break;
                        String methodname = method.getName().getFullyQualifiedName();
                        int member = 4;
                        if (method.isConstructor()) {
                            member = 32;
                            methodname = "<init>";
                        }
                        IMethodDescriptor descriptor = this.fType.getMethod(methodname, signature);
                        this.processTags(descriptor, tags, this.getEnclosingType((ASTNode)method), member);
                        break;
                    }
                    case 23: {
                        FieldDeclaration field = (FieldDeclaration)parent;
                        List fields = field.fragments();
                        VariableDeclarationFragment fragment = null;
                        Iterator iter = fields.iterator();
                        while (iter.hasNext()) {
                            fragment = (VariableDeclarationFragment)iter.next();
                            this.processTags(this.fType.getField(fragment.getName().getFullyQualifiedName()), tags, this.getEnclosingType((ASTNode)field), 8);
                        }
                        break;
                    }
                }
            }
            return false;
        }

        private int getEnclosingType(ASTNode node) {
            while (!(node instanceof AbstractTypeDeclaration)) {
                node = node.getParent();
            }
            if (node instanceof TypeDeclaration && ((TypeDeclaration)node).isInterface()) {
                return 2;
            }
            return 1;
        }

        private void enterType(SimpleName name) {
            this.fType = this.fType == null ? this.fPackage.getType(name.getFullyQualifiedName()) : this.fType.getType(name.getFullyQualifiedName());
        }

        private void exitType() {
            this.fType = this.fType.getEnclosingType();
        }

        protected void processTags(IElementDescriptor descriptor, List tags, int type, int member) {
            JavadocTagManager jtm = ApiPlugin.getJavadocTagManager();
            TagElement tag = null;
            String tagname = null;
            int restrictions = 0;
            Iterator iter = tags.iterator();
            while (iter.hasNext()) {
                tag = (TagElement)iter.next();
                tagname = tag.getTagName();
                restrictions |= jtm.getRestrictionsForTag(tagname, type, member);
            }
            if (restrictions != 0) {
                if (descriptor.getElementType() == 6) {
                    try {
                        descriptor = this.resolveMethod((IMethodDescriptor)descriptor);
                    }
                    catch (CoreException e) {
                        this.fException = e;
                    }
                }
                this.fDescription.setRestrictions(descriptor, restrictions);
            }
        }

        private boolean isContinue() {
            return this.fException == null;
        }

        CoreException getException() {
            return this.fException;
        }

        public boolean visit(TypeDeclaration node) {
            this.enterType(node.getName());
            return this.isContinue();
        }

        public void endVisit(TypeDeclaration node) {
            this.exitType();
        }

        public boolean visit(EnumDeclaration node) {
            this.enterType(node.getName());
            return this.isContinue();
        }

        public void endVisit(EnumDeclaration node) {
            this.exitType();
        }

        public boolean visit(PackageDeclaration node) {
            Name name = node.getName();
            this.fPackage = Factory.packageDescriptor(name.getFullyQualifiedName());
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            return this.isContinue();
        }

        public boolean visit(FieldDeclaration node) {
            return this.isContinue();
        }

        private IMethodDescriptor resolveMethod(IMethodDescriptor descriptor) throws CoreException {
            if (this.fContainer != null) {
                IReferenceTypeDescriptor type = descriptor.getEnclosingType();
                IClassFile classFile = this.fContainer.findClassFile(type.getQualifiedName());
                if (classFile != null) {
                    Map methodMapping = this.getMethodMapping(classFile);
                    Object object = methodMapping.get(descriptor.getName());
                    if (object == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Unable to resolve method signature: {0}", descriptor.toString()), null));
                    }
                    if (object instanceof IMethodDescriptor) {
                        return (IMethodDescriptor)object;
                    }
                    if (object instanceof HashtableOfInt) {
                        HashtableOfInt hashtableOfInt = (HashtableOfInt)object;
                        int numberOfParameters = Signature.getParameterCount((String)descriptor.getSignature()) + 1;
                        Object object2 = hashtableOfInt.get(numberOfParameters);
                        if (object2 instanceof IMethodDescriptor) {
                            return (IMethodDescriptor)object2;
                        }
                        List methodList = (List)object2;
                        Iterator iterator = methodList.iterator();
                        while (iterator.hasNext()) {
                            IMethodDescriptor methodDescriptor = (IMethodDescriptor)iterator.next();
                            if (!this.matches(descriptor, methodDescriptor)) continue;
                            return methodDescriptor;
                        }
                    }
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Unable to resolve method signature: {0}", descriptor.toString()), null));
            }
            return descriptor;
        }

        private boolean matches(IMethodDescriptor descriptor, IMethodDescriptor methodDescriptor) {
            String signature = descriptor.getSignature();
            String signature2 = methodDescriptor.getSignature();
            return Util.matchesSignatures(signature, signature2);
        }

        private IMethodDescriptor[] getMethods(IClassFile file) throws CoreException {
            MethodExtractor extractor = new MethodExtractor();
            ClassReader reader = new ClassReader(file.getContents());
            reader.accept((ClassVisitor)extractor, 5);
            return extractor.getMethods();
        }

        private Map getMethodMapping(IClassFile file) throws CoreException {
            HashMap<String, Object> mapping;
            if (this.fMethodMappings == null) {
                this.fMethodMappings = new HashMap();
            }
            if ((mapping = (HashMap<String, Object>)this.fMethodMappings.get(file)) == null) {
                mapping = new HashMap<String, Object>();
                IMethodDescriptor[] methods = this.getMethods(file);
                int i = 0;
                while (i < methods.length) {
                    IMethodDescriptor resolved = methods[i];
                    String selector = resolved.getName();
                    Object methodsCache = mapping.get(selector);
                    if (methodsCache != null) {
                        int numberOfParameter = Signature.getParameterCount((String)resolved.getSignature()) + 1;
                        if (methodsCache instanceof HashtableOfInt) {
                            HashtableOfInt hashtableOfInt = (HashtableOfInt)methodsCache;
                            Object object = hashtableOfInt.get(numberOfParameter);
                            if (object == null) {
                                hashtableOfInt.put(numberOfParameter, resolved);
                            } else if (object instanceof List) {
                                List existingMethodsList = (List)object;
                                existingMethodsList.add(resolved);
                            } else {
                                ArrayList<Object> methodsList = new ArrayList<Object>();
                                methodsList.add(object);
                                methodsList.add(resolved);
                                hashtableOfInt.put(numberOfParameter, methodsList);
                            }
                        } else {
                            IMethodDescriptor previousMethod = (IMethodDescriptor)methodsCache;
                            HashtableOfInt hashtableOfInt = new HashtableOfInt();
                            int numberOfParametersForPrevious = Signature.getParameterCount((String)previousMethod.getSignature()) + 1;
                            if (numberOfParametersForPrevious != numberOfParameter) {
                                hashtableOfInt.put(numberOfParameter, resolved);
                                hashtableOfInt.put(numberOfParametersForPrevious, previousMethod);
                            } else {
                                ArrayList<IMethodDescriptor> methodsList = new ArrayList<IMethodDescriptor>();
                                methodsList.add(previousMethod);
                                methodsList.add(resolved);
                                hashtableOfInt.put(numberOfParameter, methodsList);
                            }
                            mapping.put(selector, hashtableOfInt);
                        }
                    } else {
                        mapping.put(selector, resolved);
                    }
                    ++i;
                }
                this.fMethodMappings.put(file, mapping);
            }
            return mapping;
        }
    }
}

