/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.comparator;

import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.util.Util;

public class DeltaProcessor {
    public static boolean isCompatible(IDelta delta) {
        if (delta.getChildren().length != 0) {
            class CompatibleVisitor
            extends DeltaVisitor {
                boolean isCompatible;

                CompatibleVisitor() {
                    this.isCompatible = true;
                }

                public boolean visit(IDelta delta) {
                    return this.isCompatible;
                }

                public void endVisit(IDelta delta) {
                    if (this.isCompatible) {
                        this.isCompatible = DeltaProcessor.access$0(delta);
                    }
                }
            }
            CompatibleVisitor visitor = new CompatibleVisitor();
            delta.accept(visitor);
            return visitor.isCompatible;
        }
        return DeltaProcessor.isCompatible0(delta);
    }

    private static boolean isCompatible0(IDelta delta) {
        switch (delta.getElementType()) {
            case 3: {
                return DeltaProcessor.isApiProfileCompatible(delta);
            }
            case 2: {
                return DeltaProcessor.isApiComponentCompatible(delta);
            }
            case 8: {
                return DeltaProcessor.isInterfaceCompatible(delta);
            }
            case 1: {
                return DeltaProcessor.isAnnotationCompatible(delta);
            }
            case 10: {
                return DeltaProcessor.isMethodCompatible(delta);
            }
            case 5: {
                return DeltaProcessor.isConstructorCompatible(delta);
            }
            case 7: {
                return DeltaProcessor.isFieldCompatible(delta);
            }
            case 4: {
                return DeltaProcessor.isClassCompatible(delta);
            }
            case 6: {
                return DeltaProcessor.isEnumCompatible(delta);
            }
        }
        return true;
    }

    private static boolean isApiProfileCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 3: {
                switch (delta.getFlags()) {
                    case 3: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isApiComponentCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 3: {
                switch (delta.getFlags()) {
                    case 46: 
                    case 56: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isAnnotationCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 16: 
                    case 25: {
                        return RestrictionModifiers.isImplementRestriction(delta.getRestrictions());
                    }
                    case 6: 
                    case 23: 
                    case 24: 
                    case 28: 
                    case 49: {
                        return false;
                    }
                }
                break;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 16: 
                    case 23: 
                    case 24: 
                    case 27: 
                    case 28: 
                    case 48: 
                    case 49: 
                    case 51: {
                        return false;
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 10: 
                    case 23: 
                    case 37: 
                    case 42: 
                    case 43: 
                    case 44: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isMethodCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 3: {
                switch (delta.getFlags()) {
                    case 2: 
                    case 6: 
                    case 23: 
                    case 24: 
                    case 49: 
                    case 51: {
                        return !Util.isVisible(delta);
                    }
                }
                break;
            }
            case 1: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 23: 
                    case 24: 
                    case 49: {
                        return !Util.isVisible(delta);
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 23: 
                    case 30: 
                    case 33: 
                    case 38: 
                    case 55: {
                        return !Util.isVisible(delta);
                    }
                    case 11: {
                        return false;
                    }
                    case 31: {
                        int restrictions = delta.getRestrictions();
                        return !Util.isVisible(delta) || RestrictionModifiers.isOverrideRestriction(restrictions) || RestrictionModifiers.isExtendRestriction(restrictions);
                    }
                }
            }
        }
        return true;
    }

    private static boolean isFieldCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 3: {
                switch (delta.getFlags()) {
                    case 54: {
                        if (Util.isProtected(delta.getModifiers())) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                        }
                        return !Util.isPublic(delta.getModifiers());
                    }
                    case 47: {
                        return !Util.isVisible(delta);
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 31: 
                    case 33: 
                    case 38: 
                    case 46: 
                    case 47: {
                        return !Util.isVisible(delta);
                    }
                    case 20: 
                    case 54: {
                        if (Util.isProtected(delta.getModifiers())) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                        }
                        return !Util.isPublic(delta.getModifiers());
                    }
                    case 11: {
                        return false;
                    }
                }
                break;
            }
            case 1: {
                switch (delta.getFlags()) {
                    case 54: {
                        return !Util.isVisible(delta);
                    }
                }
            }
        }
        return true;
    }

    private static boolean isConstructorCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 3: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 23: 
                    case 24: 
                    case 49: 
                    case 51: {
                        return !Util.isVisible(delta);
                    }
                }
                break;
            }
            case 1: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 23: 
                    case 24: 
                    case 49: {
                        return !Util.isVisible(delta);
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 23: 
                    case 30: 
                    case 33: 
                    case 38: 
                    case 55: {
                        return !Util.isVisible(delta);
                    }
                    case 11: {
                        return false;
                    }
                    case 31: {
                        return !Util.isVisible(delta) || RestrictionModifiers.isOverrideRestriction(delta.getRestrictions());
                    }
                }
            }
        }
        return true;
    }

    private static boolean isEnumCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 16: 
                    case 25: {
                        return !Util.isVisible(delta) || RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                    }
                }
                break;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 8: 
                    case 12: 
                    case 16: 
                    case 25: 
                    case 48: {
                        return !Util.isVisible(delta);
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 10: 
                    case 30: 
                    case 37: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: {
                        return !Util.isVisible(delta);
                    }
                    case 11: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isClassCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 16: {
                        if (Util.isVisible(delta)) {
                            if (Util.isStatic(delta.getModifiers())) {
                                return true;
                            }
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions()) || Util.isProtected(delta.getModifiers());
                        }
                        return true;
                    }
                    case 25: {
                        if (Util.isVisible(delta)) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions()) || !Util.isAbstract(delta.getModifiers());
                        }
                        return true;
                    }
                    case 6: 
                    case 23: 
                    case 24: 
                    case 49: {
                        return !Util.isVisible(delta);
                    }
                }
                break;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 16: 
                    case 25: 
                    case 48: {
                        if (Util.isVisible(delta)) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions()) && Util.isProtected(delta.getModifiers());
                        }
                        return true;
                    }
                    case 8: {
                        if (Util.isVisible(delta)) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions()) && (Util.isProtected(delta.getModifiers()) || RestrictionModifiers.isInstantiateRestriction(delta.getRestrictions()));
                        }
                        return true;
                    }
                    case 6: 
                    case 23: 
                    case 24: 
                    case 49: 
                    case 51: {
                        return !Util.isVisible(delta);
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 9: 
                    case 10: 
                    case 23: 
                    case 30: 
                    case 31: 
                    case 33: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 41: 
                    case 43: 
                    case 44: {
                        return !Util.isVisible(delta);
                    }
                    case 11: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isInterfaceCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 16: 
                    case 25: {
                        return RestrictionModifiers.isImplementRestriction(delta.getRestrictions());
                    }
                    case 6: 
                    case 23: 
                    case 24: 
                    case 49: {
                        return false;
                    }
                }
                break;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 16: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 48: 
                    case 49: 
                    case 51: {
                        return false;
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 10: 
                    case 23: 
                    case 37: 
                    case 41: 
                    case 42: 
                    case 43: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    static /* synthetic */ boolean access$0(IDelta iDelta) {
        return DeltaProcessor.isCompatible0(iDelta);
    }
}

