/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.comparator;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.ApiProfileManager;
import org.eclipse.pde.api.tools.internal.comparator.DeltaXmlVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;

public class Compare {
    private static final String BASELINE = "-baseline";
    private static final String PROFILE = "-profile";
    private static final String OUTPUT = "-output";
    private static final String OPTIONS = "-options";
    private String baseline;
    private String output;
    private String profile;

    public static void main(String[] args) {
        Compare compare = new Compare();
        try {
            compare.configure(args);
            if (compare.isVerbose()) {
                long time = System.currentTimeMillis();
                compare.process();
                System.out.println(System.currentTimeMillis() - time + "ms spent");
            } else {
                compare.process();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void configure(String[] args) {
        int mode = 0;
        int i = 0;
        int max = args.length;
        while (i < max) {
            String currentArg = args[i];
            switch (mode) {
                case 0: {
                    if (BASELINE.equals(currentArg)) {
                        mode = 1;
                        break;
                    }
                    if (OUTPUT.equals(currentArg)) {
                        mode = 4;
                        break;
                    }
                    if (PROFILE.equals(currentArg)) {
                        mode = 2;
                        break;
                    }
                    if (OPTIONS.equals(currentArg)) {
                        mode = 3;
                        break;
                    }
                    System.err.println("Unknown option : " + currentArg);
                    break;
                }
                case 1: {
                    if (this.baseline != null) {
                        throw new IllegalArgumentException("Cannot set the baseline value more than once");
                    }
                    this.baseline = currentArg;
                    mode = 0;
                    break;
                }
                case 2: {
                    if (this.profile != null) {
                        throw new IllegalArgumentException("Cannot set the profile value more than once");
                    }
                    this.profile = currentArg;
                    mode = 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    if (this.output != null) {
                        throw new IllegalArgumentException("Cannot set the output value more than once");
                    }
                    this.output = currentArg;
                }
            }
            ++i;
        }
        if (this.baseline == null || this.profile == null || this.output == null) {
            this.printUsage();
            throw new IllegalArgumentException("Missing arguments");
        }
    }

    private void printUsage() {
        System.out.println("Usage: Compare -baseline <path> -profile <path> -output <path to xml file>");
    }

    private boolean isVerbose() {
        return true;
    }

    private void process() {
        block65: {
            File outputFile;
            IApiProfile profile;
            IApiProfile baseline;
            block64: {
                BufferedInputStream inputStream;
                block63: {
                    inputStream = null;
                    baseline = null;
                    try {
                        inputStream = new BufferedInputStream(new FileInputStream(this.baseline));
                        baseline = ApiProfileManager.restoreProfile(inputStream);
                    }
                    catch (FileNotFoundException e) {
                        ApiPlugin.log(e);
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block63;
                        }
                        catch (IOException iOException) {}
                        break block63;
                    }
                    catch (CoreException e) {
                        try {
                            ApiPlugin.log(e);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block63;
                        }
                        catch (IOException iOException) {}
                        break block63;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = null;
                profile = null;
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(this.profile));
                    profile = ApiProfileManager.restoreProfile(inputStream);
                }
                catch (FileNotFoundException e) {
                    ApiPlugin.log(e);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block64;
                    }
                    catch (IOException iOException) {}
                    break block64;
                }
                catch (CoreException e) {
                    try {
                        ApiPlugin.log(e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block64;
                    }
                    catch (IOException iOException) {}
                    break block64;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (!(outputFile = new File(this.output)).exists()) {
                File parentFile = outputFile.getParentFile();
                if (parentFile != null) {
                    if (!parentFile.exists() && !parentFile.mkdirs()) {
                        System.err.println("Could not create the output folder for : " + this.output);
                        return;
                    }
                } else {
                    System.err.println("Could not retrieve the parent of the output file : " + this.output);
                    return;
                }
            }
            if (baseline == null) {
                System.err.println("Could not setup the baseline profile : " + this.baseline);
                return;
            }
            if (profile == null) {
                System.err.println("Could not setup the profile to compare with the baseline profile : " + this.profile);
                return;
            }
            IDelta delta = ApiComparator.compare(baseline, profile, 1);
            if (delta == null) {
                System.err.println("An error occured during the comparison");
                return;
            }
            if (delta != ApiComparator.NO_DELTA) {
                BufferedWriter writer = null;
                try {
                    if (outputFile.exists()) {
                        outputFile.delete();
                    }
                    writer = new BufferedWriter(new FileWriter(outputFile));
                    DeltaXmlVisitor visitor = new DeltaXmlVisitor();
                    delta.accept(visitor);
                    writer.write(visitor.getXML());
                    writer.flush();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block65;
                    }
                    catch (IOException iOException) {}
                    break block65;
                }
                catch (CoreException e) {
                    try {
                        ApiPlugin.log(e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block65;
                    }
                    catch (IOException iOException) {}
                    break block65;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

