/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.ApiFilterStore;
import org.eclipse.pde.api.tools.internal.ApiProfile;
import org.eclipse.pde.api.tools.internal.ApiProfileManager;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.PluginProjectApiComponent;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.comparator.ClassFileComparator;
import org.eclipse.pde.api.tools.internal.descriptors.ElementDescriptorImpl;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfileManager;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemTypes;
import org.eclipse.pde.api.tools.internal.provisional.scanner.TagScanner;
import org.eclipse.pde.api.tools.internal.search.ClassFileVisitor;
import org.eclipse.pde.api.tools.internal.search.SearchEngine;
import org.osgi.framework.BundleContext;

public class ApiPlugin
extends Plugin
implements ISaveParticipant {
    public static final String EXTENSION_JAVADOC_TAGS = "apiJavadocTags";
    public static final String PLUGIN_ID = "org.eclipse.pde.api.tools";
    public static final String NATURE_ID = "org.eclipse.pde.api.tools.apiAnalysisNature";
    public static final int INTERNAL_ERROR = 120;
    public static final int ERROR = 121;
    public static final int SEVERITY_IGNORE = 0;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_ERROR = 2;
    public static final String VALUE_IGNORE = "Ignore";
    public static final String VALUE_WARNING = "Warning";
    public static final String VALUE_ERROR = "Error";
    public static final String BUILDER_ID = "org.eclipse.pde.api.tools.apiAnalysisBuilder";
    public static final String WORKSPACE_API_PROFILE_ID = "workspace";
    private static ApiPlugin fgDefault = null;
    private static JavadocTagManager fgTagManager = null;
    private static final String BUILDER_DEBUG = "org.eclipse.pde.api.tools/debug/builder";
    private static final String DELTA_DEBUG = "org.eclipse.pde.api.tools/debug/delta";
    private static final String CLASSFILE_VISITOR_DEBUG = "org.eclipse.pde.api.tools/debug/classfilevisitor";
    private static final String SEARCH_DEBUG = "org.eclipse.pde.api.tools/debug/search";
    private static final String DESCRIPTOR_FRAMEWORK_DEBUG = "org.eclipse.pde.api.tools/debug/descriptor/framework";
    private static final String TAG_SCANNER_DEBUG = "org.eclipse.pde.api.tools/debug/tagscanner";
    private static final String PLUGIN_WORKSPACE_COMPONENT_DEBUG = "org.eclipse.pde.api.tools/debug/pluginworkspacecomponent";
    private static final String API_PROFILE_MANAGER_DEBUG = "org.eclipse.pde.api.tools/debug/profilemanager";
    private static final String API_PROFILE_DEBUG = "org.eclipse.pde.api.tools/debug/apiprofile";
    private static final String API_FILTER_STORE_DEBUG = "org.eclipse.pde.api.tools/debug/apifilterstore";
    private static final String API_ANALYZER_DEBUG = "org.eclipse.pde.api.tools/debug/apianalyzer";
    public static final String TRUE = "true";
    public static String[] AllCompatibilityKeys = new String[]{IApiProblemTypes.API_PROFILE_REMOVED_API_COMPONENT, IApiProblemTypes.API_COMPONENT_REMOVED_TYPE, IApiProblemTypes.API_COMPONENT_REMOVED_API_TYPE, IApiProblemTypes.ANNOTATION_ADDED_TYPE_MEMBER, IApiProblemTypes.ANNOTATION_ADDED_FIELD, IApiProblemTypes.ANNOTATION_ADDED_METHOD, IApiProblemTypes.ANNOTATION_REMOVED_FIELD, IApiProblemTypes.ANNOTATION_REMOVED_METHOD_DEFAULT_VALUE, IApiProblemTypes.ANNOTATION_REMOVED_METHOD_NO_DEFAULT_VALUE, IApiProblemTypes.ANNOTATION_REMOVED_TYPE_MEMBER, IApiProblemTypes.ANNOTATION_REMOVED_TYPE_PARAMETERS, IApiProblemTypes.ANNOTATION_REMOVED_TYPE_PARAMETER, IApiProblemTypes.ANNOTATION_REMOVED_CLASS_BOUND, IApiProblemTypes.ANNOTATION_REMOVED_INTERFACE_BOUND, IApiProblemTypes.ANNOTATION_REMOVED_INTERFACE_BOUNDS, IApiProblemTypes.ANNOTATION_CHANGED_INTERFACE_BOUNDS, IApiProblemTypes.ANNOTATION_CHANGED_CONTRACTED_SUPERINTERFACES_SET, IApiProblemTypes.ANNOTATION_CHANGED_CLASS_BOUND, IApiProblemTypes.ANNOTATION_CHANGED_INTERFACE_BOUND, IApiProblemTypes.ANNOTATION_CHANGED_TO_CLASS, IApiProblemTypes.ANNOTATION_CHANGED_TO_ENUM, IApiProblemTypes.ANNOTATION_CHANGED_TO_INTERFACE, IApiProblemTypes.ANNOTATION_CHANGED_RESTRICTIONS, IApiProblemTypes.ANNOTATION_ADDED_TYPE_PARAMETER, IApiProblemTypes.ANNOTATION_ADDED_CLASS_BOUND, IApiProblemTypes.ANNOTATION_ADDED_INTERFACE_BOUND, IApiProblemTypes.ANNOTATION_ADDED_INTERFACE_BOUNDS, IApiProblemTypes.ANNOTATION_ADDED_METHOD_NO_DEFAULT_VALUE, IApiProblemTypes.INTERFACE_ADDED_FIELD, IApiProblemTypes.INTERFACE_ADDED_METHOD, IApiProblemTypes.INTERFACE_ADDED_TYPE_MEMBER, IApiProblemTypes.INTERFACE_ADDED_CLASS_BOUND, IApiProblemTypes.INTERFACE_ADDED_INTERFACE_BOUND, IApiProblemTypes.INTERFACE_ADDED_INTERFACE_BOUNDS, IApiProblemTypes.INTERFACE_ADDED_TYPE_PARAMETER, IApiProblemTypes.INTERFACE_REMOVED_TYPE_PARAMETER, IApiProblemTypes.INTERFACE_REMOVED_TYPE_PARAMETERS, IApiProblemTypes.INTERFACE_REMOVED_CLASS_BOUND, IApiProblemTypes.INTERFACE_REMOVED_INTERFACE_BOUND, IApiProblemTypes.INTERFACE_REMOVED_INTERFACE_BOUNDS, IApiProblemTypes.INTERFACE_REMOVED_FIELD, IApiProblemTypes.INTERFACE_REMOVED_METHOD, IApiProblemTypes.INTERFACE_REMOVED_TYPE_MEMBER, IApiProblemTypes.INTERFACE_CHANGED_CLASS_BOUND, IApiProblemTypes.INTERFACE_CHANGED_INTERFACE_BOUND, IApiProblemTypes.INTERFACE_CHANGED_INTERFACE_BOUNDS, IApiProblemTypes.INTERFACE_CHANGED_TO_CLASS, IApiProblemTypes.INTERFACE_CHANGED_TO_ENUM, IApiProblemTypes.INTERFACE_CHANGED_TO_ANNOTATION, IApiProblemTypes.INTERFACE_CHANGED_CONTRACTED_SUPERINTERFACES_SET, IApiProblemTypes.INTERFACE_CHANGED_RESTRICTIONS, IApiProblemTypes.ENUM_ADDED_FIELD, IApiProblemTypes.ENUM_ADDED_METHOD, IApiProblemTypes.ENUM_CHANGED_CONTRACTED_SUPERINTERFACES_SET, IApiProblemTypes.ENUM_CHANGED_TO_ANNOTATION, IApiProblemTypes.ENUM_CHANGED_TO_CLASS, IApiProblemTypes.ENUM_CHANGED_TO_INTERFACE, IApiProblemTypes.ENUM_CHANGED_RESTRICTIONS, IApiProblemTypes.ENUM_REMOVED_FIELD, IApiProblemTypes.ENUM_REMOVED_ENUM_CONSTANT, IApiProblemTypes.ENUM_REMOVED_METHOD, IApiProblemTypes.ENUM_REMOVED_CONSTRUCTOR, IApiProblemTypes.ENUM_REMOVED_TYPE_MEMBER, IApiProblemTypes.CLASS_ADDED_FIELD, IApiProblemTypes.CLASS_ADDED_METHOD, IApiProblemTypes.CLASS_ADDED_TYPE_PARAMETER, IApiProblemTypes.CLASS_ADDED_CLASS_BOUND, IApiProblemTypes.CLASS_ADDED_INTERFACE_BOUND, IApiProblemTypes.CLASS_ADDED_INTERFACE_BOUNDS, IApiProblemTypes.CLASS_CHANGED_CONTRACTED_SUPERINTERFACES_SET, IApiProblemTypes.CLASS_CHANGED_CONTRACTED_SUPERCLASS_SET, IApiProblemTypes.CLASS_CHANGED_SUPERCLASS, IApiProblemTypes.CLASS_CHANGED_CLASS_BOUND, IApiProblemTypes.CLASS_CHANGED_INTERFACE_BOUND, IApiProblemTypes.CLASS_CHANGED_NON_ABSTRACT_TO_ABSTRACT, IApiProblemTypes.CLASS_CHANGED_NON_FINAL_TO_FINAL, IApiProblemTypes.CLASS_CHANGED_TO_ANNOTATION, IApiProblemTypes.CLASS_CHANGED_TO_ENUM, IApiProblemTypes.CLASS_CHANGED_TO_INTERFACE, IApiProblemTypes.CLASS_CHANGED_DECREASE_ACCESS, IApiProblemTypes.CLASS_CHANGED_RESTRICTIONS, IApiProblemTypes.CLASS_REMOVED_FIELD, IApiProblemTypes.CLASS_REMOVED_METHOD, IApiProblemTypes.CLASS_REMOVED_CONSTRUCTOR, IApiProblemTypes.CLASS_REMOVED_TYPE_MEMBER, IApiProblemTypes.CLASS_REMOVED_TYPE_PARAMETER, IApiProblemTypes.CLASS_REMOVED_TYPE_PARAMETERS, IApiProblemTypes.CLASS_REMOVED_CLASS_BOUND, IApiProblemTypes.CLASS_REMOVED_INTERFACE_BOUND, IApiProblemTypes.CLASS_REMOVED_INTERFACE_BOUNDS, IApiProblemTypes.FIELD_ADDED_VALUE, IApiProblemTypes.FIELD_CHANGED_TYPE, IApiProblemTypes.FIELD_CHANGED_VALUE, IApiProblemTypes.FIELD_CHANGED_DECREASE_ACCESS, IApiProblemTypes.FIELD_CHANGED_FINAL_TO_NON_FINAL_STATIC_CONSTANT, IApiProblemTypes.FIELD_CHANGED_NON_FINAL_TO_FINAL, IApiProblemTypes.FIELD_CHANGED_STATIC_TO_NON_STATIC, IApiProblemTypes.FIELD_CHANGED_NON_STATIC_TO_STATIC, IApiProblemTypes.FIELD_REMOVED_VALUE, IApiProblemTypes.FIELD_REMOVED_TYPE_ARGUMENTS, IApiProblemTypes.METHOD_ADDED_CLASS_BOUND, IApiProblemTypes.METHOD_ADDED_INTERFACE_BOUND, IApiProblemTypes.METHOD_ADDED_INTERFACE_BOUNDS, IApiProblemTypes.METHOD_ADDED_TYPE_PARAMETER, IApiProblemTypes.METHOD_CHANGED_CLASS_BOUND, IApiProblemTypes.METHOD_CHANGED_INTERFACE_BOUND, IApiProblemTypes.METHOD_CHANGED_TYPE_PARAMETER, IApiProblemTypes.METHOD_CHANGED_VARARGS_TO_ARRAY, IApiProblemTypes.METHOD_CHANGED_DECREASE_ACCESS, IApiProblemTypes.METHOD_CHANGED_NON_ABSTRACT_TO_ABSTRACT, IApiProblemTypes.METHOD_CHANGED_NON_STATIC_TO_STATIC, IApiProblemTypes.METHOD_CHANGED_STATIC_TO_NON_STATIC, IApiProblemTypes.METHOD_CHANGED_NON_FINAL_TO_FINAL, IApiProblemTypes.METHOD_REMOVED_ANNOTATION_DEFAULT_VALUE, IApiProblemTypes.METHOD_REMOVED_TYPE_PARAMETERS, IApiProblemTypes.METHOD_REMOVED_TYPE_PARAMETER, IApiProblemTypes.METHOD_REMOVED_CLASS_BOUND, IApiProblemTypes.METHOD_REMOVED_INTERFACE_BOUND, IApiProblemTypes.METHOD_REMOVED_INTERFACE_BOUNDS, IApiProblemTypes.CONSTRUCTOR_ADDED_CLASS_BOUND, IApiProblemTypes.CONSTRUCTOR_ADDED_INTERFACE_BOUND, IApiProblemTypes.CONSTRUCTOR_ADDED_INTERFACE_BOUNDS, IApiProblemTypes.CONSTRUCTOR_ADDED_TYPE_PARAMETER, IApiProblemTypes.CONSTRUCTOR_CHANGED_CLASS_BOUND, IApiProblemTypes.CONSTRUCTOR_CHANGED_INTERFACE_BOUND, IApiProblemTypes.CONSTRUCTOR_CHANGED_TYPE_PARAMETER, IApiProblemTypes.CONSTRUCTOR_CHANGED_VARARGS_TO_ARRAY, IApiProblemTypes.CONSTRUCTOR_CHANGED_DECREASE_ACCESS, IApiProblemTypes.CONSTRUCTOR_CHANGED_NON_ABSTRACT_TO_ABSTRACT, IApiProblemTypes.CONSTRUCTOR_CHANGED_NON_STATIC_TO_STATIC, IApiProblemTypes.CONSTRUCTOR_CHANGED_STATIC_TO_NON_STATIC, IApiProblemTypes.CONSTRUCTOR_CHANGED_NON_FINAL_TO_FINAL, IApiProblemTypes.CONSTRUCTOR_REMOVED_ANNOTATION_DEFAULT_VALUE, IApiProblemTypes.CONSTRUCTOR_REMOVED_TYPE_PARAMETERS, IApiProblemTypes.CONSTRUCTOR_REMOVED_TYPE_PARAMETER, IApiProblemTypes.CONSTRUCTOR_REMOVED_CLASS_BOUND, IApiProblemTypes.CONSTRUCTOR_REMOVED_INTERFACE_BOUND, IApiProblemTypes.CONSTRUCTOR_REMOVED_INTERFACE_BOUNDS};
    private HashSet savelisteners = new HashSet();

    public ApiPlugin() {
        fgDefault = this;
    }

    public static ApiPlugin getDefault() {
        return fgDefault;
    }

    public static String getPluginIdentifier() {
        return PLUGIN_ID;
    }

    public static void log(IStatus status) {
        if (ApiPlugin.getDefault() == null) {
            Throwable exception = status.getException();
            if (exception != null) {
                exception.printStackTrace();
            }
        } else {
            ApiPlugin.getDefault().getLog().log(status);
        }
    }

    public static void log(Throwable t) {
        ApiPlugin.log(ApiPlugin.newErrorStatus("Error logged from API Tools Core: ", t));
    }

    public static void logErrorMessage(String message) {
        ApiPlugin.log(ApiPlugin.newErrorStatus("Internal message logged from API Tools Core: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, ApiPlugin.getPluginIdentifier(), 120, message, exception);
    }

    public static boolean isRunningInFramework() {
        return fgDefault != null;
    }

    public IApiProfileManager getApiProfileManager() {
        return ApiProfileManager.getManager();
    }

    public static JavadocTagManager getJavadocTagManager() {
        if (fgTagManager == null) {
            fgTagManager = new JavadocTagManager();
        }
        return fgTagManager;
    }

    public void addSaveParticipant(ISaveParticipant participant) {
        if (participant != null) {
            this.savelisteners.add(participant);
        }
    }

    public void removeSaveParticipant(ISaveParticipant participant) {
        if (participant != null) {
            this.savelisteners.remove(participant);
        }
    }

    public void doneSaving(ISaveContext context) {
        ISaveParticipant sp = null;
        Iterator iter = this.savelisteners.iterator();
        while (iter.hasNext()) {
            sp = (ISaveParticipant)iter.next();
            sp.doneSaving(context);
        }
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
        ISaveParticipant sp = null;
        Iterator iter = this.savelisteners.iterator();
        while (iter.hasNext()) {
            sp = (ISaveParticipant)iter.next();
            sp.prepareToSave(context);
        }
    }

    public void rollback(ISaveContext context) {
        ISaveParticipant sp = null;
        Iterator iter = this.savelisteners.iterator();
        while (iter.hasNext()) {
            sp = (ISaveParticipant)iter.next();
            sp.rollback(context);
        }
    }

    public void saving(ISaveContext context) throws CoreException {
        if (context.getKind() == 1) {
            context.needDelta();
        }
        ISaveParticipant sp = null;
        Iterator iter = this.savelisteners.iterator();
        while (iter.hasNext()) {
            sp = (ISaveParticipant)iter.next();
            sp.saving(context);
        }
        this.savePluginPreferences();
    }

    public void start(BundleContext context) throws Exception {
        try {
            super.start(context);
        }
        finally {
            ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, (ISaveParticipant)this);
            this.configurePluginDebugOptions();
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            ApiDescriptionManager.shutdown();
            ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
        }
        finally {
            super.stop(context);
        }
    }

    public int getSeverityLevel(String prefkey, IProject project) {
        String value;
        IPreferencesService service = Platform.getPreferencesService();
        ArrayList<Object> scopes = new ArrayList<Object>();
        scopes.add(new InstanceScope());
        if (project != null) {
            scopes.add(new ProjectScope(project));
        }
        if ((value = service.getString(ApiPlugin.getPluginIdentifier(), prefkey, null, scopes.toArray(new IScopeContext[scopes.size()]))) == null) {
            value = this.getPluginPreferences().getDefaultString(prefkey);
        }
        if (VALUE_ERROR.equals(value)) {
            return 2;
        }
        if (VALUE_WARNING.equals(value)) {
            return 1;
        }
        return 0;
    }

    public void configurePluginDebugOptions() {
        if (ApiPlugin.getDefault().isDebugging()) {
            boolean debugValue;
            String option = Platform.getDebugOption((String)BUILDER_DEBUG);
            if (option != null) {
                debugValue = option.equalsIgnoreCase(TRUE);
                ApiAnalysisBuilder.setDebug(debugValue);
            }
            if ((option = Platform.getDebugOption((String)DELTA_DEBUG)) != null) {
                debugValue = option.equalsIgnoreCase(TRUE);
                ClassFileComparator.setDebug(debugValue);
                ApiComparator.setDebug(debugValue);
            }
            if ((option = Platform.getDebugOption((String)CLASSFILE_VISITOR_DEBUG)) != null) {
                ClassFileVisitor.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)SEARCH_DEBUG)) != null) {
                SearchEngine.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)DESCRIPTOR_FRAMEWORK_DEBUG)) != null) {
                ElementDescriptorImpl.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)TAG_SCANNER_DEBUG)) != null) {
                TagScanner.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)PLUGIN_WORKSPACE_COMPONENT_DEBUG)) != null) {
                PluginProjectApiComponent.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)API_PROFILE_MANAGER_DEBUG)) != null) {
                ApiProfileManager.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)API_PROFILE_DEBUG)) != null) {
                ApiProfile.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)API_FILTER_STORE_DEBUG)) != null) {
                ApiFilterStore.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)API_ANALYZER_DEBUG)) != null) {
                ApiFilterStore.setDebug(option.equalsIgnoreCase(TRUE));
            }
        }
    }
}

