/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.problems;

import org.eclipse.core.runtime.Path;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiProblem
implements IApiProblem {
    private String fMessage = null;
    private String fResourcePath = null;
    private int fId = 0;
    private String[] fExtraArgumentIds = null;
    private Object[] fExtraArguments = null;
    private String[] fMessageArguments = null;
    private int fLineNumber = -1;
    private int fCharStart = -1;
    private int fCharEnd = -1;
    public static final int CATEGORY_MASK = -268435456;
    public static final int ELEMENT_KIND_MASK = 0xF000000;
    public static final int KIND_MASK = 0xF00000;
    public static final int FLAGS_MASK = 1044480;
    public static final int MESSAGE_MASK = 4095;
    public static final String COMPATIBILITY_STATUS = "compatibilityStatus";

    public ApiProblem(String path, String[] messageargs, String[] argumentids, Object[] arguments, int linenumber, int charstart, int charend, int id) {
        this.fResourcePath = path;
        this.fId = id;
        this.fExtraArgumentIds = argumentids;
        this.fExtraArguments = arguments;
        this.fLineNumber = linenumber;
        this.fCharStart = charstart;
        this.fCharEnd = charend;
        this.fMessageArguments = messageargs;
    }

    public int getId() {
        return this.fId;
    }

    public int getCategory() {
        return this.fId & 0xF0000000;
    }

    public int getMessageid() {
        return (this.fId & 0xFFF) >> 0;
    }

    public int getFlags() {
        return (this.fId & 0xFF000) >> 12;
    }

    public int getKind() {
        return (this.fId & 0xF00000) >> 20;
    }

    public String getMessage() {
        if (this.fMessage == null) {
            this.fMessage = ApiProblemFactory.getLocalizedMessage(this);
        }
        return this.fMessage;
    }

    public String getResourcePath() {
        return this.fResourcePath;
    }

    public int getSeverity() {
        if (ApiPlugin.isRunningInFramework()) {
            return ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId(this), null);
        }
        return 1;
    }

    public int getElementKind() {
        return (this.fId & 0xF000000) >> 24;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getCharStart() {
        return this.fCharStart;
    }

    public int getCharEnd() {
        return this.fCharEnd;
    }

    public String[] getExtraMarkerAttributeIds() {
        if (this.fExtraArguments == null || this.fExtraArgumentIds == null) {
            return new String[0];
        }
        if (this.fExtraArgumentIds.length != this.fExtraArguments.length) {
            return new String[0];
        }
        return this.fExtraArgumentIds;
    }

    public Object[] getExtraMarkerAttributeValues() {
        if (this.fExtraArguments == null || this.fExtraArgumentIds == null) {
            return new String[0];
        }
        if (this.fExtraArgumentIds.length != this.fExtraArguments.length) {
            return new String[0];
        }
        return this.fExtraArguments;
    }

    public String[] getMessageArguments() {
        if (this.fMessageArguments == null) {
            return new String[0];
        }
        return this.fMessageArguments;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiProblem) {
            IApiProblem problem = (IApiProblem)obj;
            return problem.getId() == this.fId && new Path(problem.getResourcePath()).equals((Object)new Path(this.fResourcePath)) && this.argumentsEqual(problem.getMessageArguments());
        }
        return super.equals(obj);
    }

    private boolean argumentsEqual(String[] arguments) {
        String[] currentArguments = this.getMessageArguments();
        if (currentArguments == null && arguments != null || currentArguments != null && arguments == null) {
            return false;
        }
        boolean equal = true;
        if (currentArguments.length != arguments.length) {
            return false;
        }
        int i = 0;
        while (i < currentArguments.length) {
            equal &= currentArguments[i].equals(arguments[i]);
            ++i;
        }
        return equal;
    }

    private int argumentsHashcode(String[] arguments) {
        if (this.fMessageArguments == null) {
            return 0;
        }
        int hashcode = 0;
        int i = 0;
        while (i < this.fMessageArguments.length) {
            hashcode += this.fMessageArguments[i].hashCode();
            ++i;
        }
        return hashcode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Api problem: ");
        buffer.append(this.fResourcePath).append("\n");
        buffer.append("\tseverity: ");
        buffer.append(Util.getSeverity(this.getSeverity())).append("\n");
        buffer.append("\tcategory: ");
        buffer.append(Util.getProblemCategory(this.getCategory())).append("\n");
        buffer.append("\telement kind: ");
        buffer.append(Util.getProblemElementKind(this.getCategory(), this.getElementKind())).append("\n");
        buffer.append("\tkind: ");
        buffer.append(Util.getProblemKind(this.getCategory(), this.getKind())).append("\n");
        buffer.append("\tflags: ");
        buffer.append(Util.getProblemFlagsName(this.getCategory(), this.getFlags())).append("\n");
        buffer.append("\tmessage id: ");
        buffer.append(this.getMessageid());
        return buffer.toString();
    }

    public int hashCode() {
        return this.getId() + this.fResourcePath.hashCode() + this.argumentsHashcode(this.fMessageArguments);
    }
}

