/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.descriptors;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.Signature;
import org.eclipse.pde.api.tools.internal.descriptors.MemberDescriptorImpl;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;

public class MethodDescriptorImpl
extends MemberDescriptorImpl
implements IMethodDescriptor {
    private String fSignature;

    MethodDescriptorImpl(String name, IReferenceTypeDescriptor enclosingType, String signature, int modifiers) {
        super(name, enclosingType, modifiers);
        this.fSignature = signature.replace('/', '.');
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getEnclosingType().getQualifiedName());
        buffer.append("#");
        buffer.append(Signature.toString((String)this.getSignature(), (String)this.getName(), null, (boolean)true, (boolean)true));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IMethodDescriptor) {
            IMethodDescriptor method = (IMethodDescriptor)obj;
            return this.getName().equals(method.getName()) && this.getEnclosingType().equals(method.getEnclosingType()) && this.getSignature().equals(method.getSignature());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getEnclosingType().hashCode() + this.getSignature().hashCode();
    }

    public int getElementType() {
        return 6;
    }

    public String getSignature() {
        return this.fSignature;
    }

    public boolean isSynthetic() {
        return Flags.isSynthetic((int)this.getModifiers());
    }

    public boolean isConstructor() {
        return "<init>".equals(this.getName());
    }
}

