/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.descriptors;

import org.eclipse.pde.api.tools.internal.descriptors.ElementDescriptorImpl;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IArrayTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.ITypeDescriptor;

public class ArrayDescriptorImpl
extends ElementDescriptorImpl
implements IArrayTypeDescriptor {
    private ITypeDescriptor fComponentType;
    private int fDimensions;

    ArrayDescriptorImpl(ITypeDescriptor componentType, int dimensions) {
        this.fComponentType = componentType;
        this.fDimensions = dimensions;
    }

    public ITypeDescriptor getComponentType() {
        return this.fComponentType;
    }

    public int getDimensions() {
        return this.fDimensions;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getComponentType().toString());
        int i = 0;
        while (i < this.getDimensions()) {
            buffer.append('[').append(']');
            ++i;
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IArrayTypeDescriptor) {
            IArrayTypeDescriptor array = (IArrayTypeDescriptor)obj;
            return this.getComponentType().equals(array.getComponentType()) && this.getDimensions() == array.getDimensions();
        }
        return false;
    }

    public int hashCode() {
        return this.getComponentType().hashCode() + this.getDimensions();
    }

    protected Comparable getComparable() {
        return this.toString();
    }

    public int getElementType() {
        return 4;
    }

    public String getSignature() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.getDimensions()) {
            buf.append('[');
            ++i;
        }
        buf.append(this.getComponentType().getSignature());
        return buf.toString();
    }
}

