/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeltaXmlVisitor
extends DeltaVisitor {
    private Document fDoc = Util.newDocument();
    private Element fDeltas = this.fDoc.createElement("deltas");

    public DeltaXmlVisitor() throws CoreException {
        this.fDoc.appendChild(this.fDeltas);
    }

    public boolean visit(IDelta delta) {
        if (delta.getChildren().length == 0) {
            this.processLeafDelta(delta);
        }
        return true;
    }

    protected void processLeafDelta(IDelta delta) {
        Element deltaElement = this.fDoc.createElement("delta");
        deltaElement.setAttribute("flags", Integer.toString(delta.getFlags()));
        deltaElement.setAttribute("kind", Util.getDeltaKindName(delta));
        deltaElement.setAttribute("element_type", Util.getDeltaElementType(delta));
        deltaElement.setAttribute("key", delta.getKey());
        deltaElement.setAttribute("type_name", delta.getTypeName());
        deltaElement.setAttribute("compatible", Boolean.toString(DeltaProcessor.isCompatible(delta)));
        deltaElement.setAttribute("modifiers", Integer.toString(delta.getModifiers()));
        deltaElement.setAttribute("restrictions", Integer.toString(delta.getRestrictions()));
        String apiComponentID = delta.getApiComponentID();
        if (apiComponentID != null) {
            deltaElement.setAttribute("componentId", apiComponentID);
        }
        this.fDeltas.appendChild(deltaElement);
    }

    public void endVisit(IDelta delta) {
    }

    public String getXML() throws CoreException {
        return Util.serializeDocument(this.fDoc);
    }
}

