/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.comparator.ElementDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.FieldDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.MemberTypeDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.MethodDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.SignatureDecoder;
import org.eclipse.pde.api.tools.internal.comparator.SignatureDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.TypeDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.TypeParameterDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassFileComparator {
    private static boolean DEBUG = Util.DEBUG;
    IApiProfile apiProfile;
    IApiProfile apiProfile2;
    IClassFile classFile;
    IClassFile classFile2;
    IApiComponent component;
    IApiComponent component2;
    Delta delta;
    TypeDescriptor descriptor1;
    TypeDescriptor descriptor2;
    int visibilityModifiers;
    int currentDescriptorRestrictions;
    int initialDescriptorRestrictions;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isCheckedException(IApiProfile profile, IApiComponent apiComponent, String exceptionName) {
        if (profile == null) {
            return true;
        }
        try {
            String packageName = Util.getPackageName(exceptionName);
            IClassFile classFile = Util.getClassFile(profile.resolvePackage(apiComponent, packageName), exceptionName);
            if (classFile == null) return true;
            byte[] contents = classFile.getContents();
            TypeDescriptor typeDescriptor = new TypeDescriptor(contents);
            do {
                if (Util.isJavaLangObject(typeDescriptor.name)) {
                    return true;
                }
                String superName = typeDescriptor.superName;
                packageName = Util.getPackageName(superName);
                classFile = Util.getClassFile(profile.resolvePackage(apiComponent, packageName), superName);
                if (classFile == null) {
                    if (!DEBUG) return true;
                    System.err.println("CHECKED EXCEPTION LOOKUP: Could not find " + superName + " in profile " + profile.getName() + " from component " + apiComponent.getId());
                    return true;
                }
                typeDescriptor = new TypeDescriptor(classFile.getContents());
            } while (!Util.isJavaLangRuntimeException(typeDescriptor.name));
            return false;
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        return true;
    }

    public ClassFileComparator(IClassFile classFile, IClassFile classFile2, IApiComponent component, IApiComponent component2, IApiProfile apiState, IApiProfile apiState2, int visibilityModifiers) {
        try {
            this.component = component;
            this.component2 = component2;
            this.descriptor1 = new TypeDescriptor(classFile.getContents());
            this.descriptor2 = new TypeDescriptor(classFile2.getContents());
            this.apiProfile = apiState;
            this.apiProfile2 = apiState2;
            this.classFile = classFile;
            this.classFile2 = classFile2;
            this.visibilityModifiers = visibilityModifiers;
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
    }

    public ClassFileComparator(TypeDescriptor typeDescriptor, IClassFile classFile2, IApiComponent component, IApiComponent component2, IApiProfile apiState, IApiProfile apiState2, int visibilityModifiers) {
        try {
            this.component = component;
            this.component2 = component2;
            this.descriptor1 = typeDescriptor;
            this.descriptor2 = new TypeDescriptor(classFile2.getContents());
            this.apiProfile = apiState;
            this.apiProfile2 = apiState2;
            this.classFile = typeDescriptor.classFile;
            this.classFile2 = classFile2;
            this.visibilityModifiers = visibilityModifiers;
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
    }

    private void addDelta(IDelta delta) {
        this.delta.add(delta);
    }

    private void addDelta(int elementType, int kind, int flags, int restrictions, int modifiers, IClassFile classFile, String key, String data) {
        this.delta.add(new Delta(Util.getDeltaComponentID(this.component2), elementType, kind, flags, restrictions, modifiers, classFile.getTypeName(), key, data));
    }

    private void addDelta(int elementType, int kind, int flags, int restrictions, int modifiers, IClassFile classFile, String key, String[] datas) {
        this.delta.add(new Delta(Util.getDeltaComponentID(this.component2), elementType, kind, flags, restrictions, modifiers, classFile.getTypeName(), key, datas));
    }

    private void checkSuperclass() {
        Set superclassSet1 = this.getSuperclassSet(this.descriptor1, this.component, this.apiProfile);
        Set superclassSet2 = this.getSuperclassSet(this.descriptor2, this.component2, this.apiProfile2);
        if (superclassSet1 == null) {
            if (superclassSet2 != null) {
                this.addDelta(this.descriptor1.getElementType(), 1, 39, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                return;
            }
            return;
        }
        if (superclassSet2 == null) {
            this.addDelta(this.descriptor1.getElementType(), 2, 39, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            return;
        }
        Iterator iterator = superclassSet1.iterator();
        while (iterator.hasNext()) {
            TypeDescriptor superclassTypeDescriptor = (TypeDescriptor)iterator.next();
            if (superclassSet2.contains(superclassTypeDescriptor)) continue;
            this.addDelta(this.descriptor1.getElementType(), 2, 9, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            return;
        }
        if (superclassSet1.size() < superclassSet2.size()) {
            this.addDelta(this.descriptor1.getElementType(), 2, 14, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
        }
    }

    private void checkSuperInterfaces() {
        Set superinterfacesSet1 = this.getInterfacesSet(this.descriptor1, this.component, this.apiProfile);
        Set superinterfacesSet2 = this.getInterfacesSet(this.descriptor2, this.component2, this.apiProfile2);
        if (superinterfacesSet1 == null) {
            if (superinterfacesSet2 != null) {
                this.addDelta(this.descriptor1.getElementType(), 2, 15, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
        } else if (superinterfacesSet2 == null) {
            this.addDelta(this.descriptor1.getElementType(), 2, 10, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
        } else {
            Iterator iterator = superinterfacesSet1.iterator();
            while (iterator.hasNext()) {
                TypeDescriptor superInterfaceTypeDescriptor = (TypeDescriptor)iterator.next();
                if (superinterfacesSet2.contains(superInterfaceTypeDescriptor)) continue;
                this.addDelta(this.descriptor1.getElementType(), 2, 10, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                return;
            }
            if (superinterfacesSet1.size() < superinterfacesSet2.size()) {
                this.addDelta(this.descriptor1.getElementType(), 2, 15, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
        }
    }

    private void checkTypeMembers() {
        String typeMemberName;
        MemberTypeDescriptor typeMember;
        Iterator iterator;
        Set typeMembers = this.descriptor1.typeMembers;
        Set typeMembers2 = this.descriptor2.typeMembers;
        if (typeMembers != null) {
            if (typeMembers2 == null) {
                Iterator iterator2 = typeMembers.iterator();
                while (iterator2.hasNext()) {
                    try {
                        MemberTypeDescriptor typeMember2 = (MemberTypeDescriptor)iterator2.next();
                        String typeMemberName2 = ((IReferenceTypeDescriptor)typeMember2.handle).getQualifiedName();
                        IApiDescription apiDescription = this.component.getApiDescription();
                        IApiAnnotations memberTypeElementDescription = apiDescription.resolveAnnotations(Factory.typeDescriptor(typeMemberName2));
                        int memberTypeVisibility = 0;
                        if (memberTypeElementDescription != null) {
                            memberTypeVisibility = memberTypeElementDescription.getVisibility();
                        }
                        if ((memberTypeVisibility & this.visibilityModifiers) == 0 || this.visibilityModifiers == 1 && (Util.isDefault(typeMember2.access) || Util.isPrivate(typeMember2.access))) continue;
                        this.addDelta(this.descriptor1.getElementType(), 3, 48, this.currentDescriptorRestrictions, typeMember2.access, this.classFile, typeMember2.name, typeMember2.name.replace('$', '.'));
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e);
                    }
                }
                return;
            }
            ArrayList<MemberTypeDescriptor> removedTypeMembers = new ArrayList<MemberTypeDescriptor>();
            iterator = typeMembers.iterator();
            while (iterator.hasNext()) {
                typeMember = (MemberTypeDescriptor)iterator.next();
                typeMemberName = ((IReferenceTypeDescriptor)typeMember.handle).getQualifiedName();
                if (!typeMembers2.remove(typeMember)) {
                    removedTypeMembers.add(typeMember);
                    continue;
                }
                try {
                    IClassFile memberType2;
                    ClassFileComparator comparator;
                    IDelta delta2;
                    IClassFile memberType1 = this.component.findClassFile(typeMemberName);
                    IApiDescription apiDescription = this.component.getApiDescription();
                    IApiAnnotations memberTypeElementDescription = apiDescription.resolveAnnotations(Factory.typeDescriptor(typeMemberName));
                    int memberTypeVisibility = 0;
                    if (memberTypeElementDescription != null) {
                        memberTypeVisibility = memberTypeElementDescription.getVisibility();
                    }
                    if ((memberTypeVisibility & this.visibilityModifiers) == 0) continue;
                    IApiDescription apiDescription2 = this.component2.getApiDescription();
                    IApiAnnotations memberTypeElementDescription2 = apiDescription2.resolveAnnotations(Factory.typeDescriptor(typeMemberName));
                    int memberTypeVisibility2 = 0;
                    if (memberTypeElementDescription2 != null) {
                        memberTypeVisibility2 = memberTypeElementDescription2.getVisibility();
                    }
                    if (this.visibilityModifiers == 1 && (Util.isDefault(typeMember.access) || Util.isPrivate(typeMember.access))) continue;
                    String deltaComponentID = Util.getDeltaComponentID(this.component2);
                    if ((memberTypeVisibility & 1) != 0 && (memberTypeVisibility2 & 1) == 0) {
                        this.addDelta(new Delta(deltaComponentID, 2, 3, 56, memberTypeElementDescription2 != null ? memberTypeElementDescription2.getRestrictions() : 0, typeMember.access, typeMemberName, typeMemberName, new String[]{typeMemberName.replace('$', '.'), deltaComponentID}));
                        continue;
                    }
                    if ((memberTypeVisibility2 & this.visibilityModifiers) == 0) {
                        this.addDelta(new Delta(deltaComponentID, 2, 2, 52, memberTypeElementDescription2 != null ? memberTypeElementDescription2.getRestrictions() : 0, typeMember.access, typeMemberName, typeMemberName, new String[]{typeMemberName.replace('$', '.'), deltaComponentID}));
                    }
                    if ((delta2 = (comparator = new ClassFileComparator(memberType1, memberType2 = this.component2.findClassFile(typeMemberName), this.component, this.component2, this.apiProfile, this.apiProfile2, this.visibilityModifiers)).getDelta()) == null || delta2 == ApiComparator.NO_DELTA) continue;
                    this.addDelta(delta2);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
            iterator = removedTypeMembers.iterator();
            while (iterator.hasNext()) {
                try {
                    typeMember = (MemberTypeDescriptor)iterator.next();
                    typeMemberName = ((IReferenceTypeDescriptor)typeMember.handle).getQualifiedName();
                    IApiDescription apiDescription = this.component.getApiDescription();
                    IApiAnnotations memberTypeElementDescription = apiDescription.resolveAnnotations(Factory.typeDescriptor(typeMemberName));
                    int memberTypeVisibility = 0;
                    if (memberTypeElementDescription != null) {
                        memberTypeVisibility = memberTypeElementDescription.getVisibility();
                    }
                    if ((memberTypeVisibility & this.visibilityModifiers) == 0 || this.visibilityModifiers == 1 && (Util.isDefault(typeMember.access) || Util.isPrivate(typeMember.access))) continue;
                    this.addDelta(this.descriptor1.getElementType(), 3, 48, memberTypeElementDescription != null ? memberTypeElementDescription.getRestrictions() : 0, typeMember.access, this.classFile, typeMember.name, new String[]{typeMemberName.replace('$', '.'), Util.getDeltaComponentID(this.component2)});
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        if (typeMembers2 == null) {
            return;
        }
        int currentTypeApiRestrictions = this.currentDescriptorRestrictions;
        iterator = typeMembers2.iterator();
        while (iterator.hasNext()) {
            try {
                typeMember = (MemberTypeDescriptor)iterator.next();
                typeMemberName = ((IReferenceTypeDescriptor)typeMember.handle).getQualifiedName();
                IApiDescription apiDescription2 = this.component2.getApiDescription();
                IApiAnnotations memberTypeElementDescription2 = apiDescription2.resolveAnnotations(Factory.typeDescriptor(typeMemberName));
                int memberTypeVisibility2 = 0;
                if (memberTypeElementDescription2 != null) {
                    memberTypeVisibility2 = memberTypeElementDescription2.getVisibility();
                }
                if ((memberTypeVisibility2 & this.visibilityModifiers) == 0 || this.visibilityModifiers == 1 && (Util.isDefault(typeMember.access) || Util.isPrivate(typeMember.access))) continue;
                this.addDelta(this.descriptor1.getElementType(), 1, 48, currentTypeApiRestrictions, typeMember.access, this.classFile, typeMember.name, typeMember.name.replace('$', '.'));
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    private void checkGenericSignature(String signature1, String signature2, ElementDescriptor elementDescriptor1, ElementDescriptor elementDescriptor2) {
        block25: {
            TypeParameterDescriptor[] typeParameterDescriptors2;
            int typeParameterDescriptorsLength2;
            block27: {
                SignatureDescriptor signatureDescriptor;
                block28: {
                    block24: {
                        SignatureDescriptor signatureDescriptor2;
                        block26: {
                            if (signature1 != null) break block24;
                            if (signature2 == null) break block25;
                            signatureDescriptor2 = this.getSignatureDescritor(signature2);
                            if (signatureDescriptor2.getTypeParameterDescriptors().length == 0) break block26;
                            this.addDelta(elementDescriptor1.getElementType(), 1, 51, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1)});
                            break block25;
                        }
                        if (signatureDescriptor2.getTypeArguments().length == 0) break block25;
                        this.addDelta(elementDescriptor1.getElementType(), 1, 47, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1)});
                        break block25;
                    }
                    if (signature2 != null) break block27;
                    signatureDescriptor = this.getSignatureDescritor(signature1);
                    if (signatureDescriptor.getTypeParameterDescriptors().length == 0) break block28;
                    this.addDelta(elementDescriptor1.getElementType(), 3, 51, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1)});
                    break block25;
                }
                if (signatureDescriptor.getTypeArguments().length == 0) break block25;
                this.addDelta(elementDescriptor1.getElementType(), 3, 47, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1)});
                break block25;
            }
            SignatureDescriptor signatureDescriptor = this.getSignatureDescritor(signature1);
            SignatureDescriptor signatureDescriptor2 = this.getSignatureDescritor(signature2);
            TypeParameterDescriptor[] typeParameterDescriptors1 = signatureDescriptor.getTypeParameterDescriptors();
            int typeParameterDescriptorsLength1 = typeParameterDescriptors1.length;
            if (typeParameterDescriptorsLength1 < (typeParameterDescriptorsLength2 = (typeParameterDescriptors2 = signatureDescriptor2.getTypeParameterDescriptors()).length)) {
                this.addDelta(elementDescriptor1.getElementType(), 1, 49, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1)});
                return;
            }
            if (typeParameterDescriptorsLength1 > typeParameterDescriptorsLength2) {
                this.addDelta(elementDescriptor1.getElementType(), 3, 49, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1)});
                return;
            }
            int i = 0;
            while (i < typeParameterDescriptorsLength1) {
                TypeParameterDescriptor parameterDescriptor1 = typeParameterDescriptors1[i];
                TypeParameterDescriptor parameterDescriptor2 = typeParameterDescriptors2[i];
                String name = parameterDescriptor1.name;
                if (!name.equals(parameterDescriptor2.name)) {
                    this.addDelta(elementDescriptor1.getElementType(), 2, 50, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                }
                if (parameterDescriptor1.classBound == null) {
                    if (parameterDescriptor2.classBound != null) {
                        this.addDelta(elementDescriptor1.getElementType(), 1, 6, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                    }
                } else if (parameterDescriptor2.classBound == null) {
                    this.addDelta(elementDescriptor1.getElementType(), 3, 6, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                } else if (!parameterDescriptor1.classBound.equals(parameterDescriptor2.classBound)) {
                    this.addDelta(elementDescriptor1.getElementType(), 2, 6, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                }
                List interfaceBounds1 = parameterDescriptor1.interfaceBounds;
                List interfaceBounds2 = parameterDescriptor2.interfaceBounds;
                if (interfaceBounds1 == null) {
                    if (interfaceBounds2 != null) {
                        this.addDelta(elementDescriptor1.getElementType(), 1, 24, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                    }
                } else if (interfaceBounds2 == null) {
                    this.addDelta(elementDescriptor1.getElementType(), 3, 24, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                } else if (interfaceBounds1.size() < interfaceBounds2.size()) {
                    this.addDelta(elementDescriptor1.getElementType(), 1, 23, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                } else if (interfaceBounds1.size() > interfaceBounds2.size()) {
                    this.addDelta(elementDescriptor1.getElementType(), 3, 23, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                } else {
                    int j = 0;
                    int max = interfaceBounds1.size();
                    while (j < max) {
                        if (!interfaceBounds1.get(j).equals(interfaceBounds2.get(j))) {
                            this.addDelta(elementDescriptor1.getElementType(), 2, 23, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (typeParameterDescriptorsLength2 > 0 || typeParameterDescriptorsLength1 > 0) {
                return;
            }
            String[] typeArguments = signatureDescriptor.getTypeArguments();
            String[] typeArguments2 = signatureDescriptor2.getTypeArguments();
            int length = typeArguments.length;
            int i2 = 0;
            while (i2 < length) {
                if (!typeArguments[i2].equals(typeArguments2[i2])) {
                    this.addDelta(elementDescriptor1.getElementType(), 2, 47, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1)});
                    return;
                }
                ++i2;
            }
        }
    }

    private void collectAllInterfaces(TypeDescriptor typeDescriptor, IApiComponent apiComponent, IApiProfile profile, Set set) {
        try {
            String superclassName;
            Set interfaces = typeDescriptor.interfaces;
            if (interfaces != null) {
                Iterator iterator = interfaces.iterator();
                while (iterator.hasNext()) {
                    String interfaceName = (String)iterator.next();
                    String packageName = Util.getPackageName(interfaceName);
                    IApiComponent[] components = profile.resolvePackage(apiComponent, packageName);
                    if (components == null) {
                        if (!DEBUG) continue;
                        System.err.println("SUPERINTERFACES LOOKUP: Could not find package " + packageName + " in profile " + profile.getName() + " from component " + apiComponent.getId());
                        continue;
                    }
                    IClassFile superinterface = Util.getClassFile(components, interfaceName);
                    if (superinterface == null) {
                        if (!DEBUG) continue;
                        System.err.println("SUPERINTERFACES LOOKUP: Could not find interface " + interfaceName + " in profile " + profile.getName() + " from component " + apiComponent.getId());
                        continue;
                    }
                    TypeDescriptor typeDescriptor2 = new TypeDescriptor(superinterface.getContents());
                    set.add(typeDescriptor2);
                    this.collectAllInterfaces(typeDescriptor2, apiComponent, profile, set);
                }
            }
            if (!Util.isJavaLangObject(superclassName = typeDescriptor.superName)) {
                String packageName = Util.getPackageName(superclassName);
                IApiComponent[] components = profile.resolvePackage(apiComponent, packageName);
                if (components == null) {
                    if (DEBUG) {
                        System.err.println("SUPERINTERFACES LOOKUP: Could not find package " + packageName + " in profile " + profile.getName() + " from component " + apiComponent.getId());
                    }
                    return;
                }
                IClassFile superclass = Util.getClassFile(components, superclassName);
                if (superclass == null) {
                    if (DEBUG) {
                        System.err.println("SUPERINTERFACES LOOKUP: Could not find class " + superclassName + " in profile " + profile.getName() + " from component " + apiComponent.getId());
                    }
                    return;
                }
                TypeDescriptor typeDescriptor2 = new TypeDescriptor(superclass.getContents());
                this.collectAllInterfaces(typeDescriptor2, apiComponent, profile, set);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
    }

    private String getDataFor(ElementDescriptor descriptor, TypeDescriptor typeDescriptor) {
        switch (descriptor.getElementType()) {
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                return descriptor.name;
            }
            case 5: 
            case 10: {
                StringBuffer buffer = new StringBuffer();
                buffer.append(typeDescriptor.name).append('.').append(this.getMethodDisplayName((MethodDescriptor)descriptor, typeDescriptor));
                return String.valueOf(buffer);
            }
            case 9: {
                return descriptor.name.replace('$', '.');
            }
            case 7: {
                StringBuffer buffer = new StringBuffer();
                buffer.append(typeDescriptor.name).append('.').append(descriptor.name);
                return String.valueOf(buffer);
            }
        }
        return null;
    }

    public IDelta getDelta() {
        try {
            MethodDescriptor methodDescriptor;
            Iterator iterator2;
            Object object;
            FieldDescriptor fieldDescriptor;
            this.delta = new Delta();
            int typeAccess = this.descriptor1.access;
            IApiDescription component2ApiDescription = this.component2.getApiDescription();
            IApiAnnotations elementDescription2 = component2ApiDescription.resolveAnnotations(this.descriptor2.handle);
            this.initialDescriptorRestrictions = 0;
            this.currentDescriptorRestrictions = 0;
            if (elementDescription2 != null) {
                int restrictions2 = elementDescription2.getRestrictions();
                IApiDescription apiDescription = this.component.getApiDescription();
                IApiAnnotations componentApiDescription = apiDescription.resolveAnnotations(this.descriptor1.handle);
                if (componentApiDescription != null) {
                    int restrictions;
                    this.initialDescriptorRestrictions = restrictions = componentApiDescription.getRestrictions();
                    if (restrictions2 != restrictions) {
                        if (RestrictionModifiers.isUnrestricted(restrictions)) {
                            this.addDelta(this.descriptor1.getElementType(), 2, 37, restrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                        } else if (!RestrictionModifiers.isUnrestricted(restrictions2)) {
                            this.addDelta(this.descriptor1.getElementType(), 2, 37, restrictions2, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                        }
                    }
                }
                this.currentDescriptorRestrictions = restrictions2;
            }
            int typeAccess2 = this.descriptor2.access;
            if (Util.isProtected(typeAccess)) {
                if (Util.isPrivate(typeAccess2) || Util.isDefault(typeAccess2)) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 11, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
                if (Util.isPublic(typeAccess2)) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 22, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
            } else {
                if (Util.isPublic(typeAccess) && (Util.isProtected(typeAccess2) || Util.isPrivate(typeAccess2) || Util.isDefault(typeAccess2))) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 11, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
                if (Util.isDefault(typeAccess) && (Util.isPublic(typeAccess2) || Util.isProtected(typeAccess2))) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 22, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
                if (Util.isPrivate(typeAccess) && (Util.isDefault(typeAccess2) || Util.isPublic(typeAccess2) || Util.isProtected(typeAccess2))) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 22, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
            }
            if (Util.isAnnotation(typeAccess)) {
                if (!Util.isAnnotation(typeAccess2)) {
                    if (Util.isInterface(typeAccess2)) {
                        this.addDelta(1, 2, 44, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    } else if (Util.isEnum(typeAccess2)) {
                        this.addDelta(1, 2, 43, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    } else {
                        this.addDelta(1, 2, 42, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    }
                    return this.delta;
                }
            } else if (Util.isInterface(typeAccess)) {
                if (Util.isAnnotation(typeAccess2)) {
                    this.addDelta(8, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
                if (!Util.isInterface(typeAccess2)) {
                    if (Util.isEnum(typeAccess2)) {
                        this.addDelta(8, 2, 43, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    } else {
                        this.addDelta(8, 2, 42, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    }
                    return this.delta;
                }
            } else if (Util.isEnum(typeAccess)) {
                if (!Util.isEnum(typeAccess2)) {
                    if (Util.isAnnotation(typeAccess2)) {
                        this.addDelta(6, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    } else if (Util.isInterface(typeAccess2)) {
                        this.addDelta(6, 2, 44, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    } else {
                        this.addDelta(6, 2, 42, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    }
                    return this.delta;
                }
            } else if (!Util.isClass(typeAccess2)) {
                if (Util.isAnnotation(typeAccess2)) {
                    this.addDelta(4, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                } else if (Util.isInterface(typeAccess2)) {
                    this.addDelta(4, 2, 44, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                } else {
                    this.addDelta(4, 2, 43, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                }
                return this.delta;
            }
            if (Util.isStatic(typeAccess)) {
                if (!Util.isStatic(typeAccess2)) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 38, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                }
            } else if (Util.isStatic(typeAccess2)) {
                this.addDelta(this.descriptor1.getElementType(), 2, 33, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
            this.checkSuperclass();
            this.checkSuperInterfaces();
            Iterator iterator = this.descriptor1.fields.values().iterator();
            while (iterator.hasNext()) {
                fieldDescriptor = (FieldDescriptor)iterator.next();
                this.getDeltaForFieldDescriptor(fieldDescriptor);
            }
            iterator = this.descriptor2.fields.values().iterator();
            while (iterator.hasNext()) {
                fieldDescriptor = (FieldDescriptor)iterator.next();
                this.reportFieldAddition(fieldDescriptor, this.descriptor1);
            }
            iterator = this.descriptor1.methods.values().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object instanceof List) {
                    List list = (List)object;
                    iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        methodDescriptor = (MethodDescriptor)iterator2.next();
                        this.getDeltaForMethodDescriptor(methodDescriptor);
                    }
                    continue;
                }
                MethodDescriptor methodDescriptor2 = (MethodDescriptor)object;
                this.getDeltaForMethodDescriptor(methodDescriptor2);
            }
            iterator = this.descriptor2.methods.values().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object instanceof List) {
                    List list = (List)object;
                    iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        methodDescriptor = (MethodDescriptor)iterator2.next();
                        this.reportMethodAddition(methodDescriptor, this.descriptor1);
                    }
                    continue;
                }
                MethodDescriptor methodDescriptor3 = (MethodDescriptor)object;
                this.reportMethodAddition(methodDescriptor3, this.descriptor1);
            }
            if (Util.isAbstract(typeAccess)) {
                if (!Util.isAbstract(typeAccess2)) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 1, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                }
            } else if (Util.isAbstract(typeAccess2)) {
                this.addDelta(this.descriptor1.getElementType(), 2, 30, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
            if (Util.isFinal(typeAccess)) {
                if (!Util.isFinal(typeAccess2)) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 18, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                }
            } else if (Util.isFinal(typeAccess2)) {
                this.addDelta(this.descriptor1.getElementType(), 2, 31, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
            String signature1 = this.descriptor1.signature;
            String signature2 = this.descriptor2.signature;
            this.checkGenericSignature(signature1, signature2, this.descriptor1, this.descriptor2);
            this.checkTypeMembers();
            return this.delta.isEmpty() ? ApiComparator.NO_DELTA : this.delta;
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return null;
        }
    }

    private void getDeltaForFieldDescriptor(FieldDescriptor fieldDescriptor) {
        int access = fieldDescriptor.access;
        if (Util.isSynthetic(access)) {
            return;
        }
        String name = fieldDescriptor.name;
        FieldDescriptor fieldDescriptor2 = this.getFieldDescriptor(this.descriptor2, name);
        if (fieldDescriptor2 == null) {
            if (Util.isPrivate(access) || Util.isDefault(access)) {
                this.addDelta(this.descriptor1.getElementType(), 3, 16, this.currentDescriptorRestrictions, access, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            } else {
                boolean found = false;
                if (this.component2 != null) {
                    if (this.descriptor1.isInterface()) {
                        Set interfacesSet = this.getInterfacesSet(this.descriptor2, this.component2, this.apiProfile2);
                        if (interfacesSet != null) {
                            Iterator iterator = interfacesSet.iterator();
                            while (iterator.hasNext()) {
                                TypeDescriptor superTypeDescriptor = (TypeDescriptor)iterator.next();
                                FieldDescriptor fieldDescriptor3 = this.getFieldDescriptor(superTypeDescriptor, name);
                                if (fieldDescriptor3 == null) continue;
                                this.addDelta(this.descriptor1.getElementType(), 3, 17, this.currentDescriptorRestrictions, fieldDescriptor.access, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                                found = true;
                                break;
                            }
                        }
                    } else {
                        Set superclassSet = this.getSuperclassSet(this.descriptor2, this.component2, this.apiProfile2);
                        if (superclassSet != null) {
                            Iterator iterator = superclassSet.iterator();
                            while (iterator.hasNext()) {
                                int access3;
                                TypeDescriptor superTypeDescriptor = (TypeDescriptor)iterator.next();
                                FieldDescriptor fieldDescriptor3 = this.getFieldDescriptor(superTypeDescriptor, name);
                                if (fieldDescriptor3 == null || !Util.isPublic(access3 = fieldDescriptor3.access) && !Util.isProtected(access3)) continue;
                                this.addDelta(this.descriptor1.getElementType(), 3, 17, this.currentDescriptorRestrictions, fieldDescriptor3.access, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                                found = true;
                                break;
                            }
                        }
                    }
                }
                if (!found) {
                    if (fieldDescriptor.isEnum()) {
                        this.addDelta(this.descriptor1.getElementType(), 3, 12, this.currentDescriptorRestrictions, this.descriptor2.access, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                        return;
                    }
                    this.addDelta(this.descriptor1.getElementType(), 3, 16, this.currentDescriptorRestrictions, fieldDescriptor.access, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                }
            }
            return;
        }
        int restrictions = 0;
        try {
            IApiDescription apiDescription = this.component2.getApiDescription();
            IApiAnnotations resolvedAPIDescription = apiDescription.resolveAnnotations(fieldDescriptor2.handle);
            if (resolvedAPIDescription != null) {
                restrictions = resolvedAPIDescription.getRestrictions();
            }
        }
        catch (CoreException coreException) {}
        if (RestrictionModifiers.isUnrestricted(restrictions)) {
            restrictions = this.currentDescriptorRestrictions;
        }
        int access2 = fieldDescriptor2.access;
        if (!fieldDescriptor.descriptor.equals(fieldDescriptor2.descriptor)) {
            this.addDelta(fieldDescriptor.getElementType(), 2, 46, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        } else {
            String signature1 = fieldDescriptor.signature;
            String signature2 = fieldDescriptor2.signature;
            this.checkGenericSignature(signature1, signature2, fieldDescriptor, fieldDescriptor2);
        }
        if (fieldDescriptor.value != null) {
            if (fieldDescriptor2.value == null) {
                this.addDelta(7, 3, 54, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name, String.valueOf(fieldDescriptor.value)});
            } else if (!fieldDescriptor.value.equals(fieldDescriptor2.value)) {
                if (Util.isFinal(this.descriptor2.access)) {
                    this.addDelta(7, 2, 54, restrictions | 0x200, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name, String.valueOf(fieldDescriptor.value)});
                } else {
                    this.addDelta(7, 2, 54, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name, String.valueOf(fieldDescriptor.value)});
                }
            }
        } else if (fieldDescriptor2.value != null) {
            this.addDelta(7, 1, 54, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name, String.valueOf(fieldDescriptor2.value)});
        }
        if (Util.isProtected(access)) {
            if (Util.isPrivate(access2) || Util.isDefault(access2)) {
                this.addDelta(7, 2, 11, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            } else if (Util.isPublic(access2)) {
                this.addDelta(7, 2, 22, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            }
        } else if (Util.isPublic(access) && (Util.isProtected(access2) || Util.isPrivate(access2) || Util.isDefault(access2))) {
            this.addDelta(7, 2, 11, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        } else if (Util.isPrivate(access) && (Util.isProtected(access2) || Util.isDefault(access2) || Util.isPublic(access2))) {
            this.addDelta(7, 2, 22, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        } else if (Util.isDefault(access) && (Util.isProtected(access2) || Util.isPublic(access2))) {
            this.addDelta(7, 2, 22, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        }
        if (Util.isFinal(access)) {
            if (!Util.isFinal(access2)) {
                if (!Util.isStatic(access2)) {
                    this.addDelta(7, 2, 19, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                } else if (fieldDescriptor.value != null) {
                    this.addDelta(7, 2, 20, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                } else {
                    this.addDelta(7, 2, 21, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                }
            }
        } else if (Util.isFinal(access2)) {
            this.addDelta(7, 2, 31, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        }
        if (Util.isStatic(access)) {
            if (!Util.isStatic(access2)) {
                this.addDelta(7, 2, 38, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            }
        } else if (Util.isStatic(access2)) {
            this.addDelta(7, 2, 33, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        }
        if (Util.isTransient(access)) {
            if (!Util.isTransient(access2)) {
                this.addDelta(7, 2, 45, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            }
        } else if (Util.isTransient(access2)) {
            this.addDelta(7, 2, 35, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        }
    }

    private void getDeltaForMethodDescriptor(MethodDescriptor methodDescriptor) {
        String exceptionName;
        Iterator iterator;
        int access = methodDescriptor.access;
        if (Util.isSynthetic(access)) {
            return;
        }
        String name = methodDescriptor.name;
        String descriptor = methodDescriptor.descriptor;
        String key = this.getKeyForMethod(methodDescriptor, this.descriptor1);
        MethodDescriptor methodDescriptor2 = this.getMethodDescriptor(this.descriptor2, name, descriptor);
        String methodDisplayName = this.getMethodDisplayName(methodDescriptor, this.descriptor1);
        if (methodDescriptor2 == null) {
            if (methodDescriptor.isClinit()) {
                this.addDelta(this.descriptor1.getElementType(), 3, 7, this.currentDescriptorRestrictions, access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                return;
            }
            if (Util.isPrivate(access) || Util.isDefault(access)) {
                this.addDelta(this.descriptor1.getElementType(), 3, methodDescriptor.getElementType() == 5 ? 8 : 25, this.currentDescriptorRestrictions, access, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
                return;
            }
            TypeDescriptor typeDescriptor = this.descriptor2;
            boolean found = false;
            if (this.component2 != null) {
                if (this.descriptor1.isInterface()) {
                    Set interfacesSet = this.getInterfacesSet(typeDescriptor, this.component2, this.apiProfile2);
                    if (interfacesSet != null) {
                        Iterator iterator2 = interfacesSet.iterator();
                        while (iterator2.hasNext()) {
                            TypeDescriptor superTypeDescriptor = (TypeDescriptor)iterator2.next();
                            MethodDescriptor methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                            if (methodDescriptor3 == null) continue;
                            this.addDelta(this.descriptor1.getElementType(), 3, 26, this.currentDescriptorRestrictions, access, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
                            found = true;
                            break;
                        }
                    }
                } else {
                    Set superclassSet = this.getSuperclassSet(typeDescriptor, this.component2, this.apiProfile2);
                    if (superclassSet != null) {
                        Iterator iterator3 = superclassSet.iterator();
                        while (iterator3.hasNext()) {
                            int access3;
                            TypeDescriptor superTypeDescriptor = (TypeDescriptor)iterator3.next();
                            MethodDescriptor methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                            if (methodDescriptor3 == null || !Util.isPublic(access3 = methodDescriptor3.access) && !Util.isProtected(access3)) continue;
                            this.addDelta(this.descriptor1.getElementType(), 3, 26, this.currentDescriptorRestrictions, access, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
                            found = true;
                            break;
                        }
                    }
                }
            }
            if (!found) {
                if (this.descriptor1.isAnnotation()) {
                    this.addDelta(this.descriptor1.getElementType(), 3, methodDescriptor.defaultValue != null ? 27 : 28, this.currentDescriptorRestrictions, methodDescriptor.access, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
                } else {
                    this.addDelta(this.descriptor1.getElementType(), 3, methodDescriptor.isConstructor() ? 8 : 25, Util.isAbstract(this.descriptor1.access) ? this.currentDescriptorRestrictions | 0x400 : this.currentDescriptorRestrictions, methodDescriptor.access, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
                }
            }
            return;
        }
        int restrictions = 0;
        try {
            IApiDescription apiDescription = this.component2.getApiDescription();
            IApiAnnotations resolvedAPIDescription = apiDescription.resolveAnnotations(methodDescriptor2.handle);
            if (resolvedAPIDescription != null) {
                restrictions = resolvedAPIDescription.getRestrictions();
            }
        }
        catch (CoreException coreException) {}
        if (methodDescriptor.exceptions != null) {
            if (methodDescriptor2.exceptions == null) {
                iterator = methodDescriptor.exceptions.iterator();
                while (iterator.hasNext()) {
                    exceptionName = ((String)iterator.next()).replace('/', '.');
                    if (ClassFileComparator.isCheckedException(this.apiProfile, this.component, exceptionName)) {
                        this.addDelta(methodDescriptor.getElementType(), 3, 5, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName});
                        break;
                    }
                    this.addDelta(methodDescriptor.getElementType(), 3, 53, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName});
                }
            } else {
                String exceptionName2;
                ArrayList<String> removedExceptions = new ArrayList<String>();
                Iterator iterator4 = methodDescriptor.exceptions.iterator();
                while (iterator4.hasNext()) {
                    exceptionName2 = ((String)iterator4.next()).replace('/', '.');
                    if (methodDescriptor2.exceptions.remove(exceptionName2)) continue;
                    removedExceptions.add(exceptionName2);
                }
                if (removedExceptions.size() != 0) {
                    iterator4 = removedExceptions.iterator();
                    while (iterator4.hasNext()) {
                        exceptionName2 = ((String)iterator4.next()).replace('/', '.');
                        if (ClassFileComparator.isCheckedException(this.apiProfile, this.component, exceptionName2)) {
                            this.addDelta(methodDescriptor.getElementType(), 3, 5, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName2});
                            break;
                        }
                        this.addDelta(methodDescriptor.getElementType(), 3, 53, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName2});
                    }
                }
                iterator4 = methodDescriptor2.exceptions.iterator();
                while (iterator4.hasNext()) {
                    exceptionName2 = ((String)iterator4.next()).replace('/', '.');
                    if (ClassFileComparator.isCheckedException(this.apiProfile2, this.component2, exceptionName2)) {
                        this.addDelta(methodDescriptor.getElementType(), 1, 5, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName2});
                        break;
                    }
                    this.addDelta(methodDescriptor.getElementType(), 1, 53, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName2});
                }
            }
        } else if (methodDescriptor2.exceptions != null) {
            iterator = methodDescriptor2.exceptions.iterator();
            while (iterator.hasNext()) {
                exceptionName = ((String)iterator.next()).replace('/', '.');
                if (ClassFileComparator.isCheckedException(this.apiProfile2, this.component2, exceptionName)) {
                    this.addDelta(methodDescriptor.getElementType(), 1, 5, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName});
                    break;
                }
                this.addDelta(methodDescriptor.getElementType(), 1, 53, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName});
            }
        }
        int access2 = methodDescriptor2.access;
        if (Util.isVarargs(access)) {
            if (!Util.isVarargs(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 55, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isVarargs(access2)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 4, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        if (Util.isProtected(access)) {
            if (Util.isPrivate(access2) || Util.isDefault(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 11, restrictions, methodDescriptor.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            } else if (Util.isPublic(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 22, restrictions, methodDescriptor.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isPublic(access) && (Util.isProtected(access2) || Util.isPrivate(access2) || Util.isDefault(access2))) {
            this.addDelta(methodDescriptor.getElementType(), 2, 11, restrictions, methodDescriptor.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        } else if (Util.isDefault(access) && (Util.isPublic(access2) || Util.isProtected(access2))) {
            this.addDelta(methodDescriptor.getElementType(), 2, 22, restrictions, methodDescriptor.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        } else if (Util.isPrivate(access) && (Util.isDefault(access2) || Util.isPublic(access2) || Util.isProtected(access2))) {
            this.addDelta(methodDescriptor.getElementType(), 2, 22, restrictions, methodDescriptor.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        if (Util.isAbstract(access)) {
            if (!Util.isAbstract(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 1, restrictions, access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isAbstract(access2)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 30, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        if (Util.isFinal(access)) {
            if (!Util.isFinal(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 18, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isFinal(access2)) {
            int res = restrictions;
            if (!RestrictionModifiers.isOverrideRestriction(res)) {
                if (RestrictionModifiers.isExtendRestriction(this.currentDescriptorRestrictions)) {
                    res = this.currentDescriptorRestrictions;
                } else if (RestrictionModifiers.isExtendRestriction(this.initialDescriptorRestrictions)) {
                    res = this.initialDescriptorRestrictions;
                }
            }
            this.addDelta(methodDescriptor2.getElementType(), 2, 31, res, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor2), this.getMethodDisplayName(methodDescriptor2, this.descriptor2)});
        }
        if (Util.isStatic(access)) {
            if (!Util.isStatic(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 38, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isStatic(access2)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 33, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        if (Util.isNative(access)) {
            if (!Util.isNative(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 29, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isNative(access2)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 32, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        if (Util.isSynchronized(access)) {
            if (!Util.isSynchronized(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 40, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isSynchronized(access2)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 34, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        String signature1 = methodDescriptor.signature;
        String signature2 = methodDescriptor2.signature;
        this.checkGenericSignature(signature1, signature2, methodDescriptor, methodDescriptor2);
        if (methodDescriptor.defaultValue == null) {
            if (methodDescriptor2.defaultValue != null) {
                this.addDelta(methodDescriptor.getElementType(), 1, 2, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (methodDescriptor2.defaultValue == null) {
            this.addDelta(methodDescriptor.getElementType(), 3, 2, restrictions, access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        } else if (!methodDescriptor.defaultValue.equals(methodDescriptor2.defaultValue)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 2, restrictions, access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
    }

    FieldDescriptor getFieldDescriptor(TypeDescriptor typeDescriptor, String name) {
        Object object = typeDescriptor.fields.get(name);
        if (object == null) {
            return null;
        }
        FieldDescriptor fieldDescriptor = (FieldDescriptor)object;
        typeDescriptor.fields.remove(name);
        return fieldDescriptor;
    }

    private Set getInterfacesSet(TypeDescriptor typeDescriptor, IApiComponent apiComponent, IApiProfile profile) {
        HashSet set = new HashSet();
        this.collectAllInterfaces(typeDescriptor, apiComponent, profile, set);
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    MethodDescriptor getMethodDescriptor(TypeDescriptor typeDescriptor, String name, String descriptor) {
        Object object = typeDescriptor.methods.get(name);
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MethodDescriptor methodDescriptor = (MethodDescriptor)iterator.next();
                if (!methodDescriptor.name.equals(name) || !methodDescriptor.descriptor.equals(descriptor)) continue;
                list.remove(methodDescriptor);
                if (list.size() == 0) {
                    typeDescriptor.methods.remove(name);
                }
                return methodDescriptor;
            }
            return null;
        }
        MethodDescriptor methodDescriptor = (MethodDescriptor)object;
        if (methodDescriptor.name.equals(name) && methodDescriptor.descriptor.equals(descriptor)) {
            typeDescriptor.methods.remove(name);
            return methodDescriptor;
        }
        return null;
    }

    private String getMethodDisplayName(MethodDescriptor methodDescriptor, TypeDescriptor typeDescriptor) {
        String methodName = methodDescriptor.name;
        if (methodDescriptor.isConstructor()) {
            int index2;
            String typeName = typeDescriptor.name;
            int index = typeName.lastIndexOf(46);
            methodName = index == -1 ? typeName : ((index2 = typeName.lastIndexOf(36)) > index ? typeName.substring(index2 + 1) : typeName.substring(index + 1));
        }
        return Signature.toString((String)methodDescriptor.descriptor, (String)methodName, null, (boolean)false, (boolean)false);
    }

    private SignatureDescriptor getSignatureDescritor(String signature) {
        SignatureDescriptor signatureDescriptor = new SignatureDescriptor();
        SignatureReader signatureReader = new SignatureReader(signature);
        signatureReader.accept((SignatureVisitor)new SignatureDecoder(signatureDescriptor));
        return signatureDescriptor;
    }

    private Set getSuperclassSet(TypeDescriptor typeDescriptor, IApiComponent apiComponent, IApiProfile profile) {
        return this.getSuperclassSet(typeDescriptor, apiComponent, profile, false);
    }

    private Set getSuperclassSet(TypeDescriptor typeDescriptor, IApiComponent apiComponent, IApiProfile profile, boolean includeObject) {
        TypeDescriptor descriptor = typeDescriptor;
        String superName = descriptor.superName;
        if (Util.isJavaLangObject(superName) && !includeObject) {
            return null;
        }
        HashSet<TypeDescriptor> set = new HashSet<TypeDescriptor>();
        IApiComponent sourceComponent = apiComponent;
        try {
            while (superName != null && (!Util.isJavaLangObject(superName) || includeObject)) {
                String packageName = Util.getPackageName(superName);
                IApiComponent[] components = profile.resolvePackage(sourceComponent, packageName);
                if (components == null) {
                    if (DEBUG) {
                        System.err.println("SUPERCLASS LOOKUP: Could not find package " + packageName + " in profile " + profile.getName() + " from component " + apiComponent.getId());
                    }
                    break;
                }
                sourceComponent = Util.getComponent(components, superName);
                if (sourceComponent == null) {
                    if (DEBUG) {
                        System.err.println("SUPERCLASS LOOKUP: Could not find package " + packageName + " in profile " + profile.getName() + " from component " + apiComponent.getId());
                    }
                    break;
                }
                IClassFile superclass = sourceComponent.findClassFile(superName);
                if (superclass == null) {
                    if (DEBUG) {
                        System.err.println("SUPERCLASS LOOKUP: Could not find class " + superName + " in profile " + profile.getName() + " from component " + sourceComponent.getId());
                    }
                    break;
                }
                descriptor = new TypeDescriptor(superclass.getContents());
                set.add(descriptor);
                superName = descriptor.superName;
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        return set;
    }

    private void reportFieldAddition(FieldDescriptor fieldDescriptor, TypeDescriptor descriptor) {
        int access = fieldDescriptor.access;
        String name = fieldDescriptor.name;
        if (Util.isSynthetic(access)) {
            return;
        }
        if (fieldDescriptor.isEnum()) {
            this.addDelta(descriptor.getElementType(), 1, 12, this.currentDescriptorRestrictions, descriptor.access, this.classFile, name, new String[]{Util.getDescriptorName(descriptor), name});
        } else if (Util.isFinal(descriptor.access)) {
            this.addDelta(descriptor.getElementType(), 1, 16, this.currentDescriptorRestrictions | 0x200, fieldDescriptor.access, this.classFile, name, new String[]{Util.getDescriptorName(descriptor), name});
        } else {
            this.addDelta(descriptor.getElementType(), 1, 16, this.currentDescriptorRestrictions, fieldDescriptor.access, this.classFile, name, new String[]{Util.getDescriptorName(descriptor), name});
        }
    }

    private void reportMethodAddition(MethodDescriptor methodDescriptor, TypeDescriptor typeDescriptor) {
        if (methodDescriptor.isClinit()) {
            this.addDelta(typeDescriptor.getElementType(), 1, 7, this.currentDescriptorRestrictions, methodDescriptor.access, this.classFile, typeDescriptor.name, Util.getDescriptorName(this.descriptor1));
            return;
        }
        int access = methodDescriptor.access;
        if (Util.isSynthetic(access)) {
            return;
        }
        String methodDisplayName = this.getMethodDisplayName(methodDescriptor, typeDescriptor);
        if (Util.isPublic(access) || Util.isProtected(access)) {
            if (methodDescriptor.isConstructor()) {
                this.addDelta(typeDescriptor.getElementType(), 1, 8, this.currentDescriptorRestrictions, access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
            } else if (typeDescriptor.isAnnotation()) {
                if (methodDescriptor.defaultValue != null) {
                    this.addDelta(typeDescriptor.getElementType(), 1, 27, this.currentDescriptorRestrictions, access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
                } else {
                    this.addDelta(typeDescriptor.getElementType(), 1, 28, this.currentDescriptorRestrictions, typeDescriptor.access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
                }
            } else {
                TypeDescriptor typeDescriptor2 = this.descriptor2;
                boolean found = false;
                if (this.component2 != null) {
                    String name = methodDescriptor.name;
                    String descriptor = methodDescriptor.descriptor;
                    if (this.descriptor1.isInterface()) {
                        Set interfacesSet = this.getInterfacesSet(typeDescriptor2, this.component2, this.apiProfile2);
                        if (interfacesSet != null) {
                            Iterator iterator = interfacesSet.iterator();
                            while (iterator.hasNext()) {
                                TypeDescriptor superTypeDescriptor = (TypeDescriptor)iterator.next();
                                MethodDescriptor methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                                if (methodDescriptor3 == null) continue;
                                found = true;
                                break;
                            }
                        }
                    } else {
                        Set superclassSet = this.getSuperclassSet(typeDescriptor2, this.component2, this.apiProfile2, true);
                        if (superclassSet != null) {
                            Iterator iterator = superclassSet.iterator();
                            while (iterator.hasNext()) {
                                int access3;
                                TypeDescriptor superTypeDescriptor = (TypeDescriptor)iterator.next();
                                MethodDescriptor methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                                if (methodDescriptor3 == null || !Util.isPublic(access3 = methodDescriptor3.access) && !Util.isProtected(access3)) continue;
                                found = true;
                                break;
                            }
                        }
                    }
                }
                this.addDelta(typeDescriptor.getElementType(), 1, found ? 36 : 25, this.currentDescriptorRestrictions, methodDescriptor.access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
            }
        } else {
            this.addDelta(typeDescriptor.getElementType(), 1, methodDescriptor.isConstructor() ? 8 : 25, this.currentDescriptorRestrictions, methodDescriptor.access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
        }
    }

    private String getKeyForMethod(MethodDescriptor methodDescriptor, TypeDescriptor typeDescriptor) {
        StringBuffer buffer = new StringBuffer();
        if (methodDescriptor.isConstructor()) {
            String name = typeDescriptor.name;
            int index = name.lastIndexOf(46);
            int dollarIndex = name.lastIndexOf(36);
            if (dollarIndex != -1 && typeDescriptor.isNestedType()) {
                buffer.append(typeDescriptor.name.substring(dollarIndex + 1));
            } else {
                buffer.append(typeDescriptor.name.substring(index + 1));
            }
        } else {
            buffer.append(methodDescriptor.name);
        }
        buffer.append(methodDescriptor.descriptor);
        return String.valueOf(buffer);
    }
}

