/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;

public class TagValidator
extends ASTVisitor {
    private HashSet fTagProblems = null;
    private ICompilationUnit fCompilationUnit = null;

    public TagValidator(ICompilationUnit parent) {
        this.fCompilationUnit = parent;
    }

    public boolean visit(Javadoc node) {
        ASTNode parent = node.getParent();
        if (parent != null) {
            List tags = node.tags();
            this.validateTags(parent, tags);
        }
        return false;
    }

    private void validateTags(ASTNode node, List tags) {
        if (tags.size() == 0) {
            return;
        }
        JavadocTagManager jtm = ApiPlugin.getJavadocTagManager();
        switch (node.getNodeType()) {
            case 55: {
                TypeDeclaration type = (TypeDeclaration)node;
                IApiJavadocTag[] validtags = jtm.getTagsForType(type.isInterface() ? 2 : 1, 16);
                String context = type.isInterface() ? BuilderMessages.TagValidator_an_interface : BuilderMessages.TagValidator_a_class;
                this.processTags(tags, validtags, 2, context);
                break;
            }
            case 31: {
                MethodDeclaration method = (MethodDeclaration)node;
                IApiJavadocTag[] validtags = jtm.getTagsForType(this.getParentKind(node), method.isConstructor() ? 32 : 4);
                String context = method.isConstructor() ? BuilderMessages.TagValidator_a_constructor : BuilderMessages.TagValidator_a_method;
                this.processTags(tags, validtags, 6, context);
                break;
            }
            case 23: {
                FieldDeclaration field = (FieldDeclaration)node;
                IApiJavadocTag[] validtags = jtm.getTagsForType(this.getParentKind(node), 8);
                boolean isfinal = Flags.isFinal((int)field.getModifiers());
                String context = isfinal ? BuilderMessages.TagValidator_a_final_field : BuilderMessages.TagValidator_a_field;
                this.processTags(tags, isfinal ? new IApiJavadocTag[]{} : validtags, 5, context);
            }
        }
    }

    private void processTags(List tags, IApiJavadocTag[] validtags, int element, String context) {
        IApiJavadocTag[] alltags = ApiPlugin.getJavadocTagManager().getAllTags();
        HashSet<String> invalidtags = new HashSet<String>(alltags.length);
        int i = 0;
        while (i < alltags.length) {
            invalidtags.add(alltags[i].getTagLabel());
            ++i;
        }
        i = 0;
        while (i < validtags.length) {
            invalidtags.remove(validtags[i]);
            ++i;
        }
        if (invalidtags.size() == 0) {
            return;
        }
        TagElement tag = null;
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            tag = (TagElement)iter.next();
            if (!invalidtags.contains(tag.getTagName())) continue;
            this.processTagProblem(tag, element, context);
        }
    }

    private void processTagProblem(TagElement tag, int element, String context) {
        if (this.fTagProblems == null) {
            this.fTagProblems = new HashSet(10);
        }
        int charstart = tag.getStartPosition();
        int charend = charstart + tag.getTagName().length();
        int linenumber = -1;
        try {
            IDocument document = Util.getDocument(this.fCompilationUnit);
            linenumber = document.getLineOfOffset(charstart);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {}
        try {
            IApiProblem problem = ApiProblemFactory.newApiProblem(this.fCompilationUnit.getCorrespondingResource().getProjectRelativePath().toPortableString(), new String[]{tag.getTagName(), context}, new String[]{"apiMarkerID", "org.eclipse.jdt.internal.core.JavaModelManager.handleId"}, new Object[]{new Integer(6), this.fCompilationUnit.getHandleIdentifier()}, linenumber, charstart, charend, 0x20000000, element, 7, 0);
            this.fTagProblems.add(problem);
        }
        catch (JavaModelException javaModelException) {}
    }

    private int getParentKind(ASTNode node) {
        if (node == null) {
            return -1;
        }
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).isInterface() ? 2 : 1;
        }
        return this.getParentKind(node.getParent());
    }

    public IApiProblem[] getTagProblems() {
        if (this.fTagProblems == null) {
            return new IApiProblem[0];
        }
        return this.fTagProblems.toArray(new IApiProblem[this.fTagProblems.size()]);
    }
}

