/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiProfileManager;
import org.eclipse.pde.api.tools.internal.PluginProjectApiComponent;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.builder.ApiUseAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.builder.SinceTagChecker;
import org.eclipse.pde.api.tools.internal.builder.TagValidator;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiAnalyzer;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchScope;
import org.eclipse.pde.api.tools.internal.util.SinceTagVersion;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Version;

public class BaseApiAnalyzer
implements IApiAnalyzer {
    private static boolean DEBUG = Util.DEBUG;
    private HashSet fProblems = new HashSet(25);
    private List fPendingDeltaInfos = new ArrayList(3);
    private BuildState fBuildState = null;
    private IJavaProject fJavaProject = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public void analyzeComponent(BuildState state, IApiProfile baseline, IApiComponent component, String[] typenames, String[] changedtypes, IProgressMonitor monitor) {
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_analyzing_api, (int)(3 + (typenames == null ? 0 : typenames.length)));
        try {
            this.fJavaProject = this.getJavaProject(component);
            if (baseline == null) {
                this.checkDefaultBaselineSet();
                this.updateMonitor((IProgressMonitor)localMonitor, 3);
                return;
            }
            IApiComponent reference = baseline.getApiComponent(component.getId());
            this.fBuildState = state;
            if (this.fBuildState == null) {
                this.fBuildState = this.getBuildState();
            }
            if (reference != null) {
                localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_comparing_api_profiles, (Object)reference.getId()));
                if (typenames != null) {
                    int i = 0;
                    while (i < typenames.length) {
                        this.checkCompatibility(typenames[i], reference, component);
                        this.updateMonitor((IProgressMonitor)localMonitor);
                        ++i;
                    }
                } else {
                    this.checkCompatibility(reference, component);
                    this.updateMonitor((IProgressMonitor)localMonitor);
                }
            }
            this.checkApiUsage(component, this.getSearchScope(component, typenames), (IProgressMonitor)localMonitor);
            this.updateMonitor((IProgressMonitor)localMonitor);
            this.checkApiComponentVersion(reference, component);
            this.updateMonitor((IProgressMonitor)localMonitor);
            this.checkTagValidation(changedtypes, component, (IProgressMonitor)localMonitor);
            this.updateMonitor((IProgressMonitor)localMonitor);
        }
        finally {
            localMonitor.done();
        }
    }

    private CompilationUnit createAST(ITypeRoot root, int offset) {
        if (this.fJavaProject == null) {
            return null;
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setFocalPosition(offset);
        parser.setResolveBindings(false);
        parser.setSource(root);
        Map options = this.fJavaProject.getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        return (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    private BuildState getBuildState() {
        IProject project = null;
        if (this.fJavaProject != null) {
            project = this.fJavaProject.getProject();
        }
        if (project == null) {
            return new BuildState();
        }
        try {
            BuildState state = ApiAnalysisBuilder.getLastBuiltState(project);
            if (state != null) {
                return state;
            }
        }
        catch (CoreException coreException) {}
        return new BuildState();
    }

    private IApiSearchScope getSearchScope(IApiComponent component, String[] typenames) {
        if (typenames == null) {
            return Factory.newScope(new IApiComponent[]{component});
        }
        return Factory.newTypeScope(component, this.getScopedElements(typenames));
    }

    private IReferenceTypeDescriptor[] getScopedElements(String[] typenames) {
        ArrayList<IReferenceTypeDescriptor> types = new ArrayList<IReferenceTypeDescriptor>(typenames.length);
        int i = 0;
        while (i < typenames.length) {
            types.add(Util.getType(typenames[i]));
            ++i;
        }
        return types.toArray(new IReferenceTypeDescriptor[types.size()]);
    }

    public IApiProblem[] getProblems() {
        if (this.fProblems == null) {
            return new IApiProblem[0];
        }
        return this.fProblems.toArray(new IApiProblem[this.fProblems.size()]);
    }

    public void dispose() {
        if (this.fProblems != null) {
            this.fProblems.clear();
            this.fProblems = null;
        }
        if (this.fPendingDeltaInfos != null) {
            this.fPendingDeltaInfos.clear();
            this.fPendingDeltaInfos = null;
        }
        if (this.fBuildState != null) {
            this.fBuildState = null;
        }
    }

    private boolean ignoreApiUsageScan() {
        if (this.fJavaProject == null) {
            return false;
        }
        IProject project = this.fJavaProject.getProject();
        boolean ignore = true;
        ApiPlugin plugin = ApiPlugin.getDefault();
        ignore &= plugin.getSeverityLevel("ILLEGAL_EXTEND", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_IMPLEMENT", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_INSTANTIATE", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_REFERENCE", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_EXTEND", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_FIELD_DECL", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_IMPLEMENT", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_METHOD_PARAM", project) == 0;
        return ignore &= plugin.getSeverityLevel("LEAK_METHOD_RETURN_TYPE", project) == 0;
    }

    private boolean ignoreDefaultBaselineCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("missing_default_api_profile", this.fJavaProject.getProject().getProject()) == 0;
    }

    private boolean ignoreSinceTagCheck(String pref) {
        if (this.fJavaProject == null) {
            return true;
        }
        IProject project = this.fJavaProject.getProject();
        ApiPlugin plugin = ApiPlugin.getDefault();
        if (pref == null) {
            boolean ignore = plugin.getSeverityLevel("malformed_since_tag", project) == 0;
            ignore &= plugin.getSeverityLevel("invalid_since_tag_version", project) == 0;
            return ignore &= plugin.getSeverityLevel("missing_since_tag", project) == 0;
        }
        return plugin.getSeverityLevel(pref, project) == 0;
    }

    private boolean ignoreComponentVersionCheck() {
        if (this.fJavaProject == null) {
            return false;
        }
        return ApiPlugin.getDefault().getSeverityLevel("incompatible_api_component_version", this.fJavaProject.getProject().getProject()) == 0;
    }

    private boolean ignoreInvalidTagCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("INVALID_JAVADOC_TAG", this.fJavaProject.getProject()) == 0;
    }

    private void checkTagValidation(String[] typenames, IApiComponent component, IProgressMonitor monitor) {
        if (this.ignoreInvalidTagCheck()) {
            return;
        }
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_validating_javadoc_tags, (int)(1 + (typenames == null ? component.getClassFileContainers().length : typenames.length)));
        try {
            if (typenames == null) {
                IClassFileContainer[] containers = component.getClassFileContainers();
                ClassFileVisitor visitor = new ClassFileVisitor();
                int i = 0;
                while (i < containers.length) {
                    try {
                        localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_scanning_0, (Object)containers[i].getOrigin()));
                        containers[i].accept(visitor);
                        this.updateMonitor((IProgressMonitor)localMonitor);
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
            } else {
                int i = 0;
                while (i < typenames.length) {
                    localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_scanning_0, (Object)typenames[i]));
                    this.processType(typenames[i]);
                    this.updateMonitor((IProgressMonitor)localMonitor);
                    ++i;
                }
            }
            this.updateMonitor((IProgressMonitor)localMonitor);
        }
        finally {
            localMonitor.done();
        }
    }

    private void processType(String typename) {
        try {
            ICompilationUnit cunit;
            IType type = this.fJavaProject.findType(typename);
            if (type != null && (cunit = type.getCompilationUnit()) != null) {
                TagValidator tv = new TagValidator(cunit);
                CompilationUnit comp = this.createAST((ITypeRoot)cunit, 0);
                if (comp == null) {
                    return;
                }
                comp.accept((ASTVisitor)tv);
                IApiProblem[] tagProblems = tv.getTagProblems();
                int i = 0;
                while (i < tagProblems.length) {
                    IApiProblem apiProblem = tagProblems[i];
                    this.addProblem(apiProblem);
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void checkApiUsage(IApiComponent component, IApiSearchScope scope, IProgressMonitor monitor) {
        if (this.ignoreApiUsageScan()) {
            if (DEBUG) {
                System.out.println("Ignoring API usage scan");
            }
            return;
        }
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format((String)BuilderMessages.checking_api_usage, (Object[])new String[]{component.getId()}), (int)2);
        ApiUseAnalyzer analyzer = new ApiUseAnalyzer();
        try {
            try {
                long start = System.currentTimeMillis();
                IApiProblem[] illegal = analyzer.findIllegalApiUse(component, scope, monitor);
                this.updateMonitor((IProgressMonitor)localMonitor);
                long end = System.currentTimeMillis();
                if (DEBUG) {
                    System.out.println("API usage scan: " + (end - start) + " ms\t" + illegal.length + " problems");
                }
                if (illegal.length > 0) {
                    int i = 0;
                    while (i < illegal.length) {
                        this.addProblem(illegal[i]);
                        ++i;
                    }
                }
                this.updateMonitor((IProgressMonitor)localMonitor);
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
                localMonitor.done();
            }
        }
        finally {
            localMonitor.done();
        }
    }

    private void checkCompatibility(String typeName, IApiComponent reference, IApiComponent component) {
        IDelta delta;
        block18: {
            if (DEBUG) {
                System.out.println("comparing profiles [" + reference.getId() + "] and [" + component.getId() + "] for type [" + typeName + "]");
            }
            IClassFile classFile = null;
            try {
                classFile = component.findClassFile(typeName);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
            if (classFile == null) {
                if (DEBUG) {
                    System.err.println("Could not retrieve class file for " + typeName + " in " + component.getId());
                }
                return;
            }
            this.fBuildState.cleanup(typeName);
            delta = null;
            long time = System.currentTimeMillis();
            try {
                try {
                    delta = ApiComparator.compare(classFile, reference, component, reference.getProfile(), component.getProfile(), 1);
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                    if (DEBUG) {
                        System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
                    }
                    this.fPendingDeltaInfos.clear();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
                }
                this.fPendingDeltaInfos.clear();
                throw throwable;
            }
            if (DEBUG) {
                System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
            }
            this.fPendingDeltaInfos.clear();
        }
        if (delta == null) {
            return;
        }
        if (delta != ApiComparator.NO_DELTA) {
            List allDeltas = Util.collectAllDeltas(delta);
            Iterator iterator = allDeltas.iterator();
            while (iterator.hasNext()) {
                this.processDelta((IDelta)iterator.next(), reference, component);
            }
            if (!this.fPendingDeltaInfos.isEmpty()) {
                iterator = this.fPendingDeltaInfos.iterator();
                while (iterator.hasNext()) {
                    this.checkSinceTags((Delta)iterator.next(), component);
                }
            }
        }
    }

    private void checkCompatibility(IApiComponent reference, IApiComponent component) {
        List allDeltas;
        IDelta delta;
        block15: {
            long time = System.currentTimeMillis();
            delta = null;
            if (reference == null) {
                delta = new Delta(null, 3, 1, 3, null, component.getId(), component.getId());
            } else {
                try {
                    try {
                        delta = ApiComparator.compare(reference, component, 1);
                    }
                    catch (Exception e) {
                        ApiPlugin.log(e);
                        if (DEBUG) {
                            System.out.println("Time spent for " + component.getId() + " : " + (System.currentTimeMillis() - time) + "ms");
                        }
                        this.fPendingDeltaInfos.clear();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (DEBUG) {
                        System.out.println("Time spent for " + component.getId() + " : " + (System.currentTimeMillis() - time) + "ms");
                    }
                    this.fPendingDeltaInfos.clear();
                    throw throwable;
                }
                if (DEBUG) {
                    System.out.println("Time spent for " + component.getId() + " : " + (System.currentTimeMillis() - time) + "ms");
                }
                this.fPendingDeltaInfos.clear();
            }
        }
        if (delta == null) {
            return;
        }
        if (delta != ApiComparator.NO_DELTA && (allDeltas = Util.collectAllDeltas(delta)).size() != 0) {
            Iterator iterator = allDeltas.iterator();
            while (iterator.hasNext()) {
                this.processDelta((IDelta)iterator.next(), reference, component);
            }
            if (!this.fPendingDeltaInfos.isEmpty()) {
                iterator = this.fPendingDeltaInfos.iterator();
                while (iterator.hasNext()) {
                    this.checkSinceTags((Delta)iterator.next(), component);
                }
            }
        }
    }

    private void checkSinceTags(Delta delta, IApiComponent component) {
        if (this.ignoreSinceTagCheck(null)) {
            return;
        }
        IMember member = Util.getIMember(delta, this.fJavaProject);
        if (member == null) {
            return;
        }
        ICompilationUnit cunit = member.getCompilationUnit();
        if (cunit == null) {
            return;
        }
        try {
            if (!cunit.isConsistent()) {
                cunit.makeConsistent(null);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        IApiProblem problem = null;
        ISourceRange nameRange = null;
        try {
            nameRange = member.getNameRange();
        }
        catch (JavaModelException e) {
            ApiPlugin.log(e);
            return;
        }
        if (nameRange == null) {
            return;
        }
        try {
            int offset = nameRange.getOffset();
            CompilationUnit comp = this.createAST((ITypeRoot)cunit, offset);
            if (comp == null) {
                return;
            }
            SinceTagChecker visitor = new SinceTagChecker(offset);
            comp.accept((ASTVisitor)visitor);
            String componentVersionString = component.getVersion();
            try {
                String sinceVersion;
                if (visitor.hasNoComment() || visitor.isMissing()) {
                    if (this.ignoreSinceTagCheck("missing_since_tag")) {
                        if (DEBUG) {
                            System.out.println("Ignoring missing since tag problem");
                        }
                        return;
                    }
                    StringBuffer buffer = new StringBuffer();
                    Version componentVersion = new Version(componentVersionString);
                    buffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                    problem = this.createSinceTagProblem(3, new String[]{Util.getDeltaArgumentString(delta)}, delta, member, String.valueOf(buffer));
                } else if (visitor.hasJavadocComment() && (sinceVersion = visitor.getSinceVersion()) != null) {
                    SinceTagVersion tagVersion = new SinceTagVersion(sinceVersion);
                    if (Util.getFragmentNumber(sinceVersion) > 2 || tagVersion.getVersion() == null) {
                        if (this.ignoreSinceTagCheck("malformed_since_tag")) {
                            if (DEBUG) {
                                System.out.println("Ignoring malformed since tag problem");
                            }
                            return;
                        }
                        StringBuffer buffer = new StringBuffer();
                        if (tagVersion.pluginName() != null) {
                            buffer.append(tagVersion.pluginName()).append(' ');
                        }
                        Version componentVersion = new Version(componentVersionString);
                        buffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                        problem = this.createSinceTagProblem(2, new String[]{sinceVersion, Util.getDeltaArgumentString(delta)}, delta, member, String.valueOf(buffer));
                    } else {
                        if (this.ignoreSinceTagCheck("invalid_since_tag_version")) {
                            if (DEBUG) {
                                System.out.println("Ignoring invalid tag version problem");
                            }
                            return;
                        }
                        StringBuffer accurateVersionBuffer = new StringBuffer();
                        Version componentVersion = new Version(componentVersionString);
                        accurateVersionBuffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                        String accurateVersion = String.valueOf(accurateVersionBuffer);
                        if (Util.isDifferentVersion(sinceVersion, accurateVersion)) {
                            StringBuffer buffer = new StringBuffer();
                            if (tagVersion.pluginName() != null) {
                                buffer.append(tagVersion.pluginName()).append(' ');
                            }
                            Version version = new Version(accurateVersion);
                            buffer.append(version.getMajor()).append('.').append(version.getMinor());
                            String accurateSinceTagValue = String.valueOf(buffer);
                            problem = this.createSinceTagProblem(1, new String[]{sinceVersion, accurateSinceTagValue, Util.getDeltaArgumentString(delta)}, delta, member, accurateSinceTagValue);
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                ApiPlugin.log(e);
            }
        }
        catch (RuntimeException e) {
            ApiPlugin.log(e);
        }
        if (problem != null) {
            this.addProblem(problem);
        }
    }

    private IApiProblem createSinceTagProblem(int kind, String[] messageargs, Delta info, IMember member, String version) {
        ICompilationUnit unit;
        IResource resource;
        block8: {
            try {
                resource = null;
                unit = null;
                try {
                    unit = member.getCompilationUnit();
                    if (unit != null) {
                        resource = unit.getCorrespondingResource();
                    }
                }
                catch (JavaModelException e) {
                    ApiPlugin.log(e);
                }
                if (resource != null) break block8;
                return null;
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
                return null;
            }
        }
        int lineNumber = 1;
        int charStart = 0;
        int charEnd = 1;
        ISourceRange range = member.getNameRange();
        charStart = range.getOffset();
        charEnd = charStart + range.getLength();
        try {
            IDocument document = Util.getDocument(unit);
            lineNumber = document.getLineOfOffset(charStart);
        }
        catch (BadLocationException e) {
            ApiPlugin.log(e);
        }
        return ApiProblemFactory.newApiSinceTagProblem(resource.getProjectRelativePath().toPortableString(), messageargs, new String[]{"version", "apiMarkerID", "org.eclipse.jdt.internal.core.JavaModelManager.handleId"}, new Object[]{version, new Integer(5), member.getHandleIdentifier()}, lineNumber, charStart, charEnd, info.getElementType(), kind);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IApiProblem createCompatibilityProblem(IDelta delta, IApiComponent reference, IApiComponent component) {
        try {
            Version referenceVersion = new Version(reference.getVersion());
            Version componentVersion = new Version(component.getVersion());
            if (referenceVersion.getMajor() < componentVersion.getMajor()) {
                this.fBuildState.addBreakingChange(delta);
                return null;
            }
            IResource resource = null;
            IType type = null;
            int lineNumber = 1;
            int charStart = -1;
            int charEnd = 1;
            IMember member = null;
            if (this.fJavaProject != null) {
                try {
                    type = this.fJavaProject.findType(delta.getTypeName().replace('$', '.'));
                }
                catch (JavaModelException e) {
                    ApiPlugin.log(e);
                }
                if (type == null) {
                    IResource manifestFile = Util.getManifestFile(this.fJavaProject.getProject());
                    if (manifestFile == null) {
                        return null;
                    }
                    resource = manifestFile;
                } else {
                    ICompilationUnit unit = type.getCompilationUnit();
                    if (unit != null) {
                        resource = unit.getCorrespondingResource();
                        if (resource == null) {
                            return null;
                        }
                    } else {
                        IResource manifestFile = Util.getManifestFile(this.fJavaProject.getProject());
                        if (manifestFile == null) {
                            return null;
                        }
                        resource = manifestFile;
                    }
                }
                member = Util.getIMember(delta, this.fJavaProject);
                if (member != null) {
                    ISourceRange range = member.getNameRange();
                    charStart = range.getOffset();
                    charEnd = charStart + range.getLength();
                    try {
                        IDocument document = Util.getDocument(member.getCompilationUnit());
                        lineNumber = document.getLineOfOffset(charStart);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            String path = null;
            path = resource == null ? delta.getTypeName() : resource.getProjectRelativePath().toPortableString();
            return ApiProblemFactory.newApiProblem(path, delta.getArguments(), new String[]{"org.eclipse.jdt.internal.core.JavaModelManager.handleId", "apiMarkerID"}, new Object[]{member == null ? null : member.getHandleIdentifier(), new Integer(2)}, lineNumber, charStart, charEnd, 0x10000000, delta.getElementType(), delta.getKind(), delta.getFlags());
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return null;
        }
    }

    private void processDelta(IDelta delta, IApiComponent reference, IApiComponent component) {
        int flags = delta.getFlags();
        int kind = delta.getKind();
        if (DeltaProcessor.isCompatible(delta)) {
            if (flags != 13) {
                this.fBuildState.addCompatibleChange(delta);
            }
            if (kind == 1) {
                int modifiers = delta.getModifiers();
                if (Util.isPublic(modifiers)) {
                    switch (flags) {
                        case 8: 
                        case 12: 
                        case 16: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 46: 
                        case 48: {
                            if (DEBUG) {
                                String deltaDetails = "Delta : " + Util.getDetail(delta);
                                System.out.println(String.valueOf(deltaDetails) + " is compatible");
                            }
                            this.fPendingDeltaInfos.add(delta);
                        }
                    }
                } else if (Util.isProtected(modifiers) && !RestrictionModifiers.isExtendRestriction(delta.getRestrictions())) {
                    switch (flags) {
                        case 8: 
                        case 12: 
                        case 16: 
                        case 25: 
                        case 46: 
                        case 48: {
                            if (DEBUG) {
                                String deltaDetails = "Delta : " + Util.getDetail(delta);
                                System.out.println(String.valueOf(deltaDetails) + " is compatible");
                            }
                            this.fPendingDeltaInfos.add(delta);
                        }
                    }
                }
            }
        } else {
            switch (kind) {
                case 1: {
                    switch (flags) {
                        case 8: 
                        case 12: 
                        case 16: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 48: {
                            if (!Util.isVisible(delta)) break;
                            if (DEBUG) {
                                String deltaDetails = "Delta : " + Util.getDetail(delta);
                                System.err.println(String.valueOf(deltaDetails) + " is not compatible");
                            }
                            this.fPendingDeltaInfos.add(delta);
                        }
                    }
                    break;
                }
                case 2: {
                    if (flags != 37) break;
                    return;
                }
            }
            IApiProblem problem = this.createCompatibilityProblem(delta, reference, component);
            if (this.addProblem(problem)) {
                this.fBuildState.addBreakingChange(delta);
            }
        }
    }

    private void checkApiComponentVersion(IApiComponent reference, IApiComponent component) {
        IDelta[] breakingChanges;
        if (this.ignoreComponentVersionCheck() || reference == null || component == null) {
            if (DEBUG) {
                System.out.println("Ignoring component version check");
            }
            return;
        }
        IApiProblem problem = null;
        String refversionval = reference.getVersion();
        String compversionval = component.getVersion();
        Version refversion = new Version(refversionval);
        Version compversion = new Version(compversionval);
        Version newversion = null;
        if (DEBUG) {
            System.out.println("reference version of " + reference.getId() + " : " + refversion);
            System.out.println("component version of " + component.getId() + " : " + compversion);
        }
        if ((breakingChanges = this.fBuildState.getBreakingChanges()).length != 0) {
            if (compversion.getMajor() <= refversion.getMajor()) {
                newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier());
                problem = this.createVersionProblem(1, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(breakingChanges));
            }
        } else {
            IDelta[] compatibleChanges = this.fBuildState.getCompatibleChanges();
            if (compatibleChanges.length != 0) {
                if (compversion.getMajor() != refversion.getMajor()) {
                    newversion = new Version(refversion.getMajor(), compversion.getMinor() + 1, 0, compversion.getQualifier());
                    problem = this.createVersionProblem(3, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(compatibleChanges));
                } else if (compversion.getMinor() <= refversion.getMinor()) {
                    newversion = new Version(compversion.getMajor(), compversion.getMinor() + 1, 0, compversion.getQualifier());
                    problem = this.createVersionProblem(2, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(compatibleChanges));
                }
            }
        }
        if (problem != null) {
            this.addProblem(problem);
        }
    }

    private String collectDetails(IDelta[] deltas) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int max = deltas.length;
        while (i < max) {
            buffer.append("- ");
            buffer.append(deltas[i].getMessage());
            ++i;
        }
        return buffer.toString();
    }

    private IApiProblem createVersionProblem(int kind, String[] messageargs, String version, String description) {
        int charEnd;
        int charStart;
        int lineNumber;
        String path;
        block35: {
            char[] contents;
            block34: {
                IResource manifestFile = null;
                path = "META-INF/MANIFEST.MF";
                if (this.fJavaProject != null) {
                    manifestFile = Util.getManifestFile(this.fJavaProject.getProject());
                }
                lineNumber = -1;
                charStart = 0;
                charEnd = 1;
                contents = null;
                if (manifestFile != null && manifestFile.getType() == 1) {
                    path = manifestFile.getProjectRelativePath().toPortableString();
                    IFile file = (IFile)manifestFile;
                    InputStream inputStream = null;
                    BufferedReader reader = null;
                    try {
                        inputStream = file.getContents(true);
                        contents = Util.getInputStreamAsCharArray(inputStream, -1, "UTF-8");
                        reader = new LineNumberReader(new BufferedReader(new StringReader(new String(contents))));
                        int lineCounter = 0;
                        String line = null;
                        while ((line = ((LineNumberReader)reader).readLine()) != null) {
                            ++lineCounter;
                            if (!line.startsWith("Bundle-Version")) continue;
                            lineNumber = lineCounter;
                            break;
                        }
                    }
                    catch (CoreException coreException) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (reader != null) {
                                reader.close();
                            }
                            break block34;
                        }
                        catch (IOException iOException) {}
                        break block34;
                    }
                    catch (IOException iOException) {
                        try {}
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                            catch (IOException iOException2) {}
                            throw throwable;
                        }
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (reader != null) {
                                reader.close();
                            }
                            break block34;
                        }
                        catch (IOException iOException3) {}
                        break block34;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (lineNumber != -1 && contents != null) {
                int index = CharOperation.indexOf((char[])"Bundle-Version".toCharArray(), (char[])contents, (boolean)true);
                int i = index + "Bundle-Version".length() + 1;
                int max = contents.length;
                while (i < max) {
                    char currentCharacter = contents[i];
                    if (!CharOperation.isWhitespace((char)currentCharacter)) {
                        charStart = i;
                        break;
                    }
                    ++i;
                }
                i = charStart + 1;
                max = contents.length;
                while (i < max) {
                    switch (contents[i]) {
                        case '\n': 
                        case '\r': {
                            charEnd = i;
                            break block35;
                        }
                        default: {
                            ++i;
                        }
                    }
                }
            } else {
                lineNumber = 1;
            }
        }
        return ApiProblemFactory.newApiVersionNumberProblem(path, messageargs, new String[]{"version", "apiMarkerID", "description"}, new Object[]{version, new Integer(4), description}, lineNumber, charStart, charEnd, 7, kind);
    }

    private void checkDefaultBaselineSet() {
        if (this.ignoreDefaultBaselineCheck()) {
            if (DEBUG) {
                System.out.println("Ignoring check for default API baseline");
            }
            return;
        }
        if (DEBUG) {
            System.out.println("Checking if the default api baseline is set");
        }
        IApiProblem problem = ApiProblemFactory.newApiProfileProblem(Path.EMPTY.toPortableString(), null, new String[]{"apiMarkerID"}, new Object[]{new Integer(1)}, -1, -1, -1, 7, 1);
        this.addProblem(problem);
    }

    private void updateMonitor(IProgressMonitor monitor) throws OperationCanceledException {
        this.updateMonitor(monitor, 1);
    }

    private void updateMonitor(IProgressMonitor monitor, int work) throws OperationCanceledException {
        if (monitor != null) {
            monitor.worked(work);
            monitor.setTaskName("");
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }

    private IJavaProject getJavaProject(IApiComponent component) {
        if (component instanceof PluginProjectApiComponent) {
            PluginProjectApiComponent pp = (PluginProjectApiComponent)component;
            return pp.getJavaProject();
        }
        return null;
    }

    private boolean addProblem(IApiProblem problem) {
        if (problem == null || this.isProblemFiltered(problem)) {
            return false;
        }
        return this.fProblems.add(problem);
    }

    private boolean isProblemFiltered(IApiProblem problem) {
        if (this.fJavaProject == null) {
            return false;
        }
        IProject project = this.fJavaProject.getProject();
        if (ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId(problem), project) == 0) {
            return true;
        }
        ApiProfileManager manager = ApiProfileManager.getManager();
        IApiProfile profile = manager.getWorkspaceProfile();
        if (profile == null) {
            return false;
        }
        IApiComponent component = profile.getApiComponent(project.getName());
        if (component != null) {
            try {
                IApiFilterStore filterStore = component.getFilterStore();
                if (filterStore != null) {
                    return filterStore.isFiltered(problem);
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    class ClassFileVisitor
    extends ClassFileContainerVisitor {
        ClassFileVisitor() {
        }

        public void visit(String packageName, IClassFile classFile) {
            BaseApiAnalyzer.this.processType(classFile.getTypeName());
        }
    }
}

