/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.pde.api.tools.internal.PluginProjectApiComponent;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchCriteria;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchEngine;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchResult;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchScope;
import org.eclipse.pde.api.tools.internal.provisional.search.ILocation;
import org.eclipse.pde.api.tools.internal.provisional.search.IReference;
import org.eclipse.pde.api.tools.internal.search.MethodSearchCriteria;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiUseAnalyzer {
    private static final IApiProblem[] EMPTY = new IApiProblem[0];
    private static final boolean DEBUG = Util.DEBUG;

    public IApiProblem[] findIllegalApiUse(IApiComponent component, IApiSearchScope scope, IProgressMonitor monitor) throws CoreException {
        IApiSearchCriteria[] conditions = this.buildSearchConditions(component);
        ArrayList<IApiProblem> problems = new ArrayList<IApiProblem>();
        if (conditions.length > 0) {
            IApiSearchEngine engine = Factory.newSearchEngine();
            IApiSearchResult[] results = engine.search(scope, conditions, monitor);
            IApiProblem problem = null;
            IReference[] references = null;
            ProblemDescriptor desc = null;
            int i = 0;
            while (i < results.length) {
                references = results[i].getReferences();
                desc = (ProblemDescriptor)results[i].getSearchCriteria().getUserData();
                int j = 0;
                while (j < references.length) {
                    problem = this.createProblem(desc.getKind(), desc.getElementType(), desc.getFlags(), references[j]);
                    if (problem != null) {
                        problems.add(problem);
                    }
                    ++j;
                }
                ++i;
            }
            return problems.toArray(new IApiProblem[problems.size()]);
        }
        return EMPTY;
    }

    private IApiProblem createProblem(int kind, int elementType, int flags, IReference reference) {
        IApiComponent component = reference.getSourceLocation().getApiComponent();
        if (component instanceof PluginProjectApiComponent) {
            PluginProjectApiComponent ppac = (PluginProjectApiComponent)component;
            IJavaProject project = ppac.getJavaProject();
            return this.createUsageProblem(kind, elementType, flags, reference, project);
        }
        return this.createUsageProblem(kind, elementType, flags, reference);
    }

    private IApiSearchCriteria[] buildSearchConditions(IApiComponent component) {
        long start = System.currentTimeMillis();
        IApiComponent[] components = component.getProfile().getPrerequisiteComponents(new IApiComponent[]{component});
        UsageVisitor visitor = new UsageVisitor();
        int i = 0;
        while (i < components.length) {
            IApiComponent prereq = components[i];
            if (!prereq.equals(component)) {
                visitor.setOwningComponentId(prereq.getId());
                try {
                    prereq.getApiDescription().accept(visitor);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e.getStatus());
                }
            }
            ++i;
        }
        long end = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("Time to build search conditions: " + (end - start) + "ms");
        }
        List conditions = visitor.getConditions();
        conditions.add(this.createLeakCondition(1, 6, 2, 1, 65535, 5));
        conditions.add(this.createLeakCondition(2, 6, 2, 2, 65535, 5));
        conditions.add(this.createLeakCondition(4, 6, 5, 3, 63487, 5));
        MethodSearchCriteria criteria = new MethodSearchCriteria(8, new ProblemDescriptor(6, 6, 4));
        conditions.add(criteria);
        criteria = new MethodSearchCriteria(16, new ProblemDescriptor(6, 6, 5));
        conditions.add(criteria);
        return conditions.toArray(new IApiSearchCriteria[conditions.size()]);
    }

    private IApiSearchCriteria createLeakCondition(int refKind, int problemKind, int elementType, int flags, int restrictions, int sourcevis) {
        IApiSearchCriteria criteria = Factory.newSearchCriteria();
        criteria.setReferenceKinds(refKind);
        criteria.setReferencedRestrictions(2, 65535);
        criteria.setSourceRestrictions(1, restrictions);
        criteria.setSourceModifiers(sourcevis);
        criteria.setUserData(new ProblemDescriptor(problemKind, elementType, flags));
        return criteria;
    }

    /*
     * Exception decompiling
     */
    private IApiProblem createUsageProblem(int kind, int elementType, int flags, IReference reference, IJavaProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK], 3[TRYBLOCK]], but top level block is 24[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int findMethodNameStart(String namepart, String line, int index) {
        int start = line.indexOf(namepart, index);
        if (start < 0) {
            return -1;
        }
        int offset = start + namepart.length();
        while (line.charAt(offset) == ' ') {
            ++offset;
        }
        if (line.charAt(offset) == '(') {
            return start;
        }
        return this.findMethodNameStart(namepart, line, offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IApiProblem createUsageProblem(int kind, int elementType, int flags, IReference reference) {
        ILocation location = reference.getSourceLocation();
        IReferenceTypeDescriptor refType = location.getType();
        int lineNumber = location.getLineNumber();
        ILocation resolvedLocation = reference.getResolvedLocation();
        String qualifiedTypeName = resolvedLocation.getType().getQualifiedName();
        IMemberDescriptor member = resolvedLocation.getMember();
        String[] messageargs = null;
        switch (kind) {
            case 4: {
                messageargs = new String[]{qualifiedTypeName};
                return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
            }
            case 1: {
                messageargs = new String[]{qualifiedTypeName};
                return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
            }
            case 2: {
                messageargs = new String[]{qualifiedTypeName};
                return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
            }
            case 5: {
                IMethodDescriptor method = (IMethodDescriptor)member;
                messageargs = new String[]{method.getEnclosingType().getQualifiedName(), Signature.toString((String)method.getSignature(), (String)method.getName(), null, (boolean)false, (boolean)false)};
                return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
            }
            case 3: {
                switch (elementType) {
                    case 6: {
                        IMethodDescriptor method = (IMethodDescriptor)member;
                        messageargs = new String[]{method.getEnclosingType().getQualifiedName(), Signature.toString((String)method.getSignature(), (String)method.getName(), null, (boolean)false, (boolean)false)};
                        return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
                    }
                    case 5: {
                        IFieldDescriptor field = (IFieldDescriptor)member;
                        messageargs = new String[]{field.getEnclosingType().getQualifiedName(), field.getName()};
                        return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
                    }
                }
                return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
            }
            case 6: {
                messageargs = new String[]{qualifiedTypeName};
                try {
                    switch (flags) {
                        case 3: {
                            IApiDescription description;
                            IApiAnnotations annotations;
                            IFieldDescriptor field = (IFieldDescriptor)reference.getSourceLocation().getMember();
                            if ((4 & field.getModifiers()) <= 0 || (annotations = (description = reference.getSourceLocation().getApiComponent().getApiDescription()).resolveAnnotations(field.getEnclosingType())) != null && !RestrictionModifiers.isExtendRestriction(annotations.getRestrictions())) return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
                            return null;
                        }
                        case 4: 
                        case 5: {
                            IApiDescription description;
                            IApiAnnotations annotations;
                            IMethodDescriptor method = (IMethodDescriptor)reference.getSourceLocation().getMember();
                            if ((4 & method.getModifiers()) <= 0 || (annotations = (description = reference.getSourceLocation().getApiComponent().getApiDescription()).resolveAnnotations(method.getEnclosingType())) != null && !RestrictionModifiers.isOverrideRestriction(annotations.getRestrictions())) return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
                            return null;
                        }
                        default: {
                            return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
                        }
                    }
                }
                catch (CoreException e) {
                    ApiPlugin.log(e.getStatus());
                }
                return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
            }
        }
        return ApiProblemFactory.newApiUsageProblem(refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, flags);
    }

    class ProblemDescriptor {
        private int fKind;
        private int fElementType;
        private int fFlags;

        ProblemDescriptor(int kind, int elementType) {
            this(kind, elementType, 0);
        }

        ProblemDescriptor(int kind, int elementType, int flags) {
            this.fKind = kind;
            this.fElementType = elementType;
            this.fFlags = flags;
        }

        public int getKind() {
            return this.fKind;
        }

        public int getElementType() {
            return this.fElementType;
        }

        public int getFlags() {
            return this.fFlags;
        }
    }

    class UsageVisitor
    extends ApiDescriptionVisitor {
        private List fConditions = new ArrayList();
        private String fOwningComponentId;

        UsageVisitor() {
        }

        void setOwningComponentId(String id) {
            this.fOwningComponentId = id;
        }

        public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
            int mask = description.getRestrictions();
            if (!RestrictionModifiers.isUnrestricted(mask)) {
                IElementDescriptor[] elements = new IElementDescriptor[]{element};
                if (RestrictionModifiers.isOverrideRestriction(mask)) {
                    this.addCriteria(0x10000000, 4096, elements, 5, 6);
                }
                if (RestrictionModifiers.isExtendRestriction(mask)) {
                    this.addCriteria(1, 512, elements, 1, 2);
                }
                if (RestrictionModifiers.isImplementRestriction(mask)) {
                    this.addCriteria(2, 256, elements, 4, 2);
                    this.addCriteria(1, 256, elements, 4, 2);
                }
                if (RestrictionModifiers.isInstantiateRestriction(mask)) {
                    this.addCriteria(0x8000000, 1024, elements, 2, 2);
                }
                if (RestrictionModifiers.isReferenceRestriction(mask)) {
                    if (element.getElementType() == 6) {
                        this.addCriteria(1049536, 2048, elements, 3, 6);
                    } else if (element.getElementType() == 5) {
                        this.addCriteria(30720, 2048, elements, 3, 5);
                    }
                }
            }
            return true;
        }

        private void addCriteria(int refKind, int restriction, IElementDescriptor[] elements, int problemKind, int elemenType) {
            IApiSearchCriteria condition = Factory.newSearchCriteria();
            condition.addReferencedElementRestriction(this.fOwningComponentId, elements);
            condition.setReferenceKinds(refKind);
            condition.setReferencedRestrictions(65535, restriction);
            condition.setUserData(new ProblemDescriptor(problemKind, elemenType));
            this.fConditions.add(condition);
        }

        List getConditions() {
            return this.fConditions;
        }
    }
}

