/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.api.tools.internal.ResourceClassFile;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;
import org.eclipse.pde.api.tools.internal.util.Util;

public class SourceFolderClassFileContainer
implements IClassFileContainer {
    private IPackageFragmentRoot fRoot;
    private IContainer fOutputLocation;
    private String fOrigin;

    public SourceFolderClassFileContainer(IPackageFragmentRoot root, String origin) {
        this.fRoot = root;
        this.fOrigin = origin;
    }

    public void accept(ClassFileContainerVisitor visitor) throws CoreException {
        IContainer outputLocation = this.getOutputLocation();
        if (outputLocation != null) {
            IJavaElement[] children = this.fRoot.getChildren();
            int i = 0;
            while (i < children.length) {
                IContainer container;
                IResource[] members;
                IPackageFragment fragment = (IPackageFragment)children[i];
                String pkg = fragment.getElementName();
                Object folder = null;
                folder = pkg.length() > 0 ? outputLocation.findMember(fragment.getElementName().replace('.', '/')) : outputLocation;
                if (folder instanceof IContainer && (members = (container = folder).members()).length > 0) {
                    if (visitor.visitPackage(pkg)) {
                        int j = 0;
                        while (j < members.length) {
                            IFile file;
                            IResource res = members[j];
                            if (res.getType() == 1 && Util.isClassFile((file = (IFile)res).getName())) {
                                StringBuffer typeName = new StringBuffer();
                                if (pkg.length() != 0) {
                                    typeName.append(pkg);
                                    typeName.append('.');
                                }
                                String fileName = file.getName();
                                String className = fileName.substring(0, fileName.length() - ".class".length());
                                typeName.append(className);
                                ResourceClassFile cf = new ResourceClassFile(file, typeName.toString());
                                visitor.visit(pkg, cf);
                                visitor.end(pkg, cf);
                            }
                            ++j;
                        }
                    }
                    visitor.endVisitPackage(pkg);
                }
                ++i;
            }
        }
    }

    public synchronized void close() throws CoreException {
        this.fOutputLocation = null;
    }

    private synchronized IContainer getOutputLocation() {
        if (this.fOutputLocation == null) {
            try {
                block1 : switch (this.fRoot.getKind()) {
                    case 1: {
                        IPath location = this.fRoot.getRawClasspathEntry().getOutputLocation();
                        if (location == null) {
                            location = this.fRoot.getJavaProject().getOutputLocation();
                        }
                        this.fOutputLocation = ResourcesPlugin.getWorkspace().getRoot().getFolder(location);
                        if (!this.fOutputLocation.exists()) {
                            this.fOutputLocation = null;
                        }
                        break;
                    }
                    case 2: {
                        IResource resource = this.fRoot.getUnderlyingResource();
                        if (resource == null) break;
                        switch (resource.getType()) {
                            case 4: {
                                this.fOutputLocation = (IProject)resource;
                                break block1;
                            }
                            case 2: {
                                this.fOutputLocation = (IFolder)resource;
                            }
                        }
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return this.fOutputLocation;
    }

    public IClassFile findClassFile(String qualifiedName) throws CoreException {
        IContainer outputLocation = this.getOutputLocation();
        if (outputLocation != null) {
            IPackageFragment fragment;
            int index = qualifiedName.lastIndexOf(46);
            String pkg = "";
            if (index > 0) {
                pkg = qualifiedName.substring(0, index);
            }
            if ((fragment = this.fRoot.getPackageFragment(pkg)).exists()) {
                StringBuffer name = new StringBuffer();
                name.append(qualifiedName.replace('.', '/'));
                name.append(".class");
                IResource member = outputLocation.findMember(name.toString());
                if (member != null && member.getType() == 1) {
                    return new ResourceClassFile((IFile)member, qualifiedName);
                }
            }
        }
        return null;
    }

    public String[] getPackageNames() throws CoreException {
        IJavaElement[] elements = this.fRoot.getChildren();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < elements.length) {
            IPackageFragment fragment = (IPackageFragment)elements[i];
            if (fragment.hasChildren()) {
                names.add(fragment.getElementName());
            }
            ++i;
        }
        return names.toArray(new String[names.size()]);
    }

    public String getOrigin() {
        return this.fOrigin;
    }

    public IClassFile findClassFile(String qualifiedName, String id) throws CoreException {
        return this.findClassFile(qualifiedName);
    }
}

