/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.pde.api.tools.internal.ApiJavadocTag;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;

public class JavadocTagManager {
    private HashMap tagcache = null;
    private IApiJavadocTag[] tags;

    private void initializeJavadocTags() {
        if (this.tagcache == null) {
            this.tagcache = new HashMap();
            ArrayList<ApiJavadocTag> list = new ArrayList<ApiJavadocTag>(4);
            ApiJavadocTag newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noimplement", "noimplement", 256, new int[]{2}, new String[]{"This interface is not intended to be implemented by clients."});
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noextend", "noextend", 512, new int[]{1}, new String[]{"This class is not intended to be subclassed by clients."});
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.nooverride", "nooverride", 4096, new int[]{5}, new String[]{"This method is not intended to be re-implemented or extended by clients."});
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noinstantiate", "noinstantiate", 1024, new int[]{1}, new String[]{"This class is not intended to be instantiated by clients."});
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noreference", "noreference", 2048, new int[]{7, 11, 33}, new String[]{"This method is not intended to be referenced by clients.", "This field is not intended to be referenced by clients.", "This constructor is not intended to be referenced by clients."});
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            this.tags = list.toArray(new IApiJavadocTag[list.size()]);
        }
    }

    public synchronized IApiJavadocTag[] getTagsForType(int type, int member) {
        this.initializeJavadocTags();
        ArrayList<IApiJavadocTag> list = new ArrayList<IApiJavadocTag>();
        int i = 0;
        while (i < this.tags.length) {
            if (this.tags[i].isApplicable(type, member)) {
                list.add(this.tags[i]);
            }
            ++i;
        }
        return list.toArray(new IApiJavadocTag[list.size()]);
    }

    public synchronized IApiJavadocTag getTag(String id) {
        this.initializeJavadocTags();
        return (IApiJavadocTag)this.tagcache.get(id);
    }

    public synchronized IApiJavadocTag[] getAllTags() {
        if (this.tagcache == null) {
            return new IApiJavadocTag[0];
        }
        Collection values = this.tagcache.values();
        return values.toArray(new IApiJavadocTag[values.size()]);
    }

    public synchronized int getRestrictionsForTag(String tagname, int type, int member) {
        if (tagname == null) {
            return 0;
        }
        this.initializeJavadocTags();
        ApiJavadocTag tag = null;
        int i = 0;
        while (i < this.tags.length) {
            tag = (ApiJavadocTag)this.tags[i];
            if (tag.getTagLabel().equals(tagname) && tag.isApplicable(type, member)) {
                return tag.getRestrictionModifier();
            }
            ++i;
        }
        return 0;
    }
}

