/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.api.tools.internal.BundleVersionRange;
import org.eclipse.pde.api.tools.internal.RequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.osgi.framework.BundleException;

public class ComponentManifest {
    private String fId;
    private String fName;
    private String fVersion;
    private String fEnvironment;
    private IRequiredComponentDescription[] fRequired;

    ComponentManifest() {
    }

    public static ComponentManifest fromBundleManifest(InputStream stream) throws CoreException {
        ComponentManifest manifest = new ComponentManifest();
        manifest.initFromBundleManifest(stream);
        return manifest;
    }

    private void initFromBundleManifest(InputStream manifest) throws CoreException {
        try {
            Map headers = ManifestElement.parseBundleManifest((InputStream)manifest, null);
            this.fId = this.getValue("Bundle-SymbolicName", headers);
            this.fName = this.getValue("Bundle-Name", headers);
            this.fVersion = this.getValue("Bundle-Version", headers);
            this.fEnvironment = this.getValue("Bundle-RequiredExecutionEnvironment", headers);
            String value = (String)headers.get("Require-Bundle");
            if (value == null) {
                this.fRequired = new IRequiredComponentDescription[0];
            } else {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Require-Bundle", (String)value);
                this.fRequired = new IRequiredComponentDescription[elements.length];
                int i = 0;
                while (i < elements.length) {
                    ManifestElement element = elements[i];
                    this.fRequired[i] = new RequiredComponentDescription(element.getValue(), new BundleVersionRange(element.getAttribute("bundle-version")), this.isOptional(element));
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.abort("Invalid API component manifest", e);
        }
        catch (BundleException e) {
            this.abort("Invalid API component manifest", e);
        }
    }

    private boolean isOptional(ManifestElement element) {
        return "optional".equals(element.getDirective("resolution")) || "true".equals(element.getAttribute("optional"));
    }

    private void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", message, e));
    }

    private String getValue(String header, Map headers) throws BundleException, CoreException {
        String value = (String)headers.get(header);
        if (value != null) {
            ManifestElement[] elements = ManifestElement.parseHeader((String)header, (String)value);
            if (elements == null) {
                this.abort("Manifest missing required header: " + header, null);
            } else {
                if (elements.length == 1) {
                    return elements[0].getValue();
                }
                this.abort("Manifest has invalid header: " + header, null);
            }
        }
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public String getId() {
        return this.fId;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public String getExecutionEnvironment() {
        return this.fEnvironment;
    }

    public IRequiredComponentDescription[] getRequiredComponents() {
        return this.fRequired;
    }
}

