/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApiSettingsXmlVisitor
extends ApiDescriptionVisitor {
    public static final String VALUE_API = "API";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_PRIVATE = "private";
    public static final String VALUE_PRIVATE_PERMISSABLE = "private_permissable";
    public static final String VALUE_SPI = "SPI";
    public static final String VALUE_TRUE = "true";
    private Element fComponent;
    private Document fDoc = Util.newDocument();
    private Element fPackage;
    private int fPackageVisibility;
    private Stack fTypeStack;
    private Set fVisitedPackages;

    public ApiSettingsXmlVisitor(IApiComponent component) throws CoreException {
        this(component.getName(), component.getId());
    }

    public ApiSettingsXmlVisitor(String componentName, String componentId) throws CoreException {
        this.fComponent = this.fDoc.createElement("component");
        this.fComponent.setAttribute("name", componentName);
        this.fComponent.setAttribute("version", "1.1");
        this.fDoc.appendChild(this.fComponent);
        Element plugin = this.fDoc.createElement("plugin");
        plugin.setAttribute("id", componentId);
        this.fComponent.appendChild(plugin);
        this.fVisitedPackages = new HashSet();
        this.fTypeStack = new Stack();
    }

    private void addVisibilityAttributes(Element element, IApiAnnotations description) {
        int modifiers = description.getVisibility();
        String value = null;
        switch (modifiers) {
            case 1: {
                value = VALUE_API;
                break;
            }
            case 2: {
                value = VALUE_PRIVATE;
                break;
            }
            case 8: {
                value = VALUE_PRIVATE_PERMISSABLE;
                break;
            }
            case 4: {
                value = VALUE_SPI;
                break;
            }
        }
        if (value != null) {
            element.setAttribute("visibility", value);
        }
    }

    private void annotateElementAttributes(IApiAnnotations description, Element element) {
        int visibility;
        int restrictions = description.getRestrictions();
        if (RestrictionModifiers.isImplementRestriction(restrictions)) {
            element.setAttribute("implement", VALUE_FALSE);
        }
        if (RestrictionModifiers.isExtendRestriction(restrictions)) {
            element.setAttribute("extend", VALUE_FALSE);
        }
        if (RestrictionModifiers.isOverrideRestriction(restrictions)) {
            element.setAttribute("override", VALUE_FALSE);
        }
        if (RestrictionModifiers.isInstantiateRestriction(restrictions)) {
            element.setAttribute("instantiate", VALUE_FALSE);
        }
        if (RestrictionModifiers.isReferenceRestriction(restrictions)) {
            element.setAttribute("reference", VALUE_FALSE);
        }
        if ((visibility = description.getVisibility()) != this.fPackageVisibility) {
            this.addVisibilityAttributes(element, description);
        }
    }

    public void endVisitElement(IElementDescriptor element, IApiAnnotations description) {
        switch (element.getElementType()) {
            case 1: {
                if (this.fPackage != null && this.fPackage.hasChildNodes()) {
                    this.fComponent.appendChild(this.fPackage);
                }
                this.fPackage = null;
                break;
            }
            case 2: {
                this.fTypeStack.pop();
            }
        }
    }

    public String getXML() throws CoreException {
        return Util.serializeDocument(this.fDoc);
    }

    public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
        switch (element.getElementType()) {
            case 1: {
                IPackageDescriptor pkg = (IPackageDescriptor)element;
                String pkgName = pkg.getName();
                if (!this.fVisitedPackages.add(pkgName)) break;
                this.fPackage = this.fDoc.createElement("package");
                this.fPackage.setAttribute("name", pkgName);
                this.fPackageVisibility = description.getVisibility();
                this.fVisitedPackages.add(pkgName);
                break;
            }
            case 2: {
                IReferenceTypeDescriptor typeDesc = (IReferenceTypeDescriptor)element;
                this.fTypeStack.push(this.fDoc.createElement("type"));
                Element type = (Element)this.fTypeStack.peek();
                this.annotateElementAttributes(description, type);
                this.fPackage.appendChild(type);
                type.setAttribute("name", Util.getTypeName(typeDesc.getQualifiedName()));
                break;
            }
            case 6: {
                IMethodDescriptor desc = (IMethodDescriptor)element;
                Element method = this.fDoc.createElement("method");
                Element type = (Element)this.fTypeStack.peek();
                this.annotateElementAttributes(description, method);
                if (!method.hasAttributes()) break;
                type.appendChild(method);
                method.setAttribute("signature", desc.getSignature());
                method.setAttribute("name", desc.getName());
                break;
            }
            case 5: {
                IFieldDescriptor desc = (IFieldDescriptor)element;
                Element field = this.fDoc.createElement("field");
                Element type = (Element)this.fTypeStack.peek();
                this.annotateElementAttributes(description, field);
                if (!field.hasAttributes()) break;
                type.appendChild(field);
                field.setAttribute("name", desc.getName());
            }
        }
        return true;
    }
}

