/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;

public class ApiJavadocTag
implements IApiJavadocTag {
    private String[][] comments = null;
    private String fId = null;
    private String fName = null;
    private int[] fElements = null;
    private String[] fComments = null;
    private int fRModifier = 0;
    private String taglabel = null;

    public ApiJavadocTag(String id, String name, int rmodifier, int[] elements, String[] comments) {
        Assert.isNotNull((Object)id);
        this.fId = id;
        Assert.isNotNull((Object)name);
        this.fName = name;
        Assert.isNotNull((Object)elements);
        this.fElements = elements;
        this.fComments = comments;
        this.fRModifier = rmodifier;
    }

    public String getTagId() {
        return this.fId;
    }

    public int getRestrictionModifier() {
        return this.fRModifier;
    }

    protected String getTagComment(int type, int member) {
        this.initializeElements();
        int i1 = 0;
        if (type == 2) {
            i1 = 1;
        }
        int i2 = 2;
        if (member == 8) {
            i2 = 1;
        } else if (member == 4) {
            i2 = 0;
        } else if (member == 32) {
            i2 = 3;
        }
        return this.comments[i1][i2];
    }

    private void initializeElements() {
        if (this.comments == null) {
            this.comments = new String[2][4];
            int i = 0;
            while (i < this.fElements.length) {
                boolean constructor;
                boolean clazz = (1 & this.fElements[i]) != 0;
                boolean inter = (2 & this.fElements[i]) != 0;
                boolean method = (4 & this.fElements[i]) != 0;
                boolean field = (8 & this.fElements[i]) != 0;
                boolean bl = constructor = (0x20 & this.fElements[i]) != 0;
                if (clazz) {
                    if (constructor) {
                        this.comments[0][3] = this.fComments[i];
                    }
                    if (method) {
                        this.comments[0][0] = this.fComments[i];
                    }
                    if (field) {
                        this.comments[0][1] = this.fComments[i];
                    }
                    if (!field & !method & !constructor) {
                        this.comments[0][2] = this.fComments[i];
                    }
                }
                if (inter) {
                    if (method) {
                        this.comments[1][0] = this.fComments[i];
                    }
                    if (field) {
                        this.comments[1][1] = this.fComments[i];
                    }
                    if (!field & !method) {
                        this.comments[1][2] = this.fComments[i];
                    }
                }
                ++i;
            }
        }
    }

    public String getTagLabel() {
        if (this.taglabel == null) {
            StringBuffer tag = new StringBuffer();
            tag.append("@");
            tag.append(this.fName);
            this.taglabel = tag.toString();
        }
        return this.taglabel;
    }

    public String toString() {
        return this.getTagLabel();
    }

    public String getCompleteTag(int type, int member) {
        StringBuffer tag = new StringBuffer();
        tag.append("@");
        tag.append(this.fName);
        tag.append(" ");
        tag.append(this.getTagComment(type, member));
        return tag.toString();
    }

    public boolean isApplicable(int type, int member) {
        this.initializeElements();
        return this.getTagComment(type, member) != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiJavadocTag) {
            return ((IApiJavadocTag)obj).getTagLabel().equals(this.getTagLabel());
        }
        if (obj instanceof String) {
            return ((String)obj).equals(this.getTagLabel());
        }
        return false;
    }

    public int hashCode() {
        return this.getTagLabel().hashCode();
    }
}

