/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ApiFilterStore
implements IApiFilterStore,
IResourceChangeListener {
    private static boolean DEBUG = Util.DEBUG;
    private HashMap fFilterMap = null;
    private IJavaProject fProject = null;
    private boolean fNeedsSaving = false;
    private boolean fTriggeredChange = false;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public ApiFilterStore(IJavaProject project) {
        Assert.isNotNull((Object)project);
        this.fProject = project;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void persistApiFilters() {
        if (!this.fNeedsSaving) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (DEBUG) {
                    System.out.println("persisting api filters for plugin project component [" + ApiFilterStore.this.fProject.getElementName() + "]");
                }
                try {
                    IProject project;
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    if (!(project = ApiFilterStore.this.fProject.getProject()).isAccessible()) {
                        if (DEBUG) {
                            System.out.println("project [" + ApiFilterStore.this.fProject.getElementName() + "] is not accessible, saving termainated");
                        }
                        return Status.CANCEL_STATUS;
                    }
                    String xml = ApiFilterStore.this.getStoreAsXml();
                    IFile file = project.getFile(new Path(".settings").append(".api_filters"));
                    if (xml == null) {
                        if (file.isAccessible()) {
                            IFolder folder = (IFolder)file.getParent();
                            file.delete(true, monitor);
                            if (folder.members().length == 0 && folder.isAccessible()) {
                                folder.delete(true, monitor);
                            }
                            ApiFilterStore.this.fTriggeredChange = true;
                        }
                        return Status.OK_STATUS;
                    }
                    InputStream xstream = Util.getInputStreamFromString(xml);
                    if (xstream == null) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        if (!file.exists()) {
                            IFolder folder = (IFolder)file.getParent();
                            if (!folder.exists()) {
                                folder.create(true, true, monitor);
                            }
                            file.create(xstream, true, monitor);
                        } else {
                            file.setContents(xstream, true, false, monitor);
                        }
                    }
                    finally {
                        xstream.close();
                    }
                    ApiFilterStore.this.fTriggeredChange = true;
                    ApiFilterStore.this.fNeedsSaving = false;
                }
                catch (CoreException ce) {
                    ApiPlugin.log(ce);
                }
                catch (IOException ioe) {
                    ApiPlugin.log(ioe);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public synchronized void addFilters(IApiProblemFilter[] filters) {
        if (filters == null) {
            if (DEBUG) {
                System.out.println("null filters array, not adding filters");
            }
            return;
        }
        this.initializeApiFilters();
        HashSet<IApiProblemFilter> pfilters = null;
        IResource resource = null;
        int i = 0;
        while (i < filters.length) {
            resource = this.fProject.getProject().findMember((IPath)new Path(filters[i].getUnderlyingProblem().getResourcePath()));
            if (resource != null) {
                pfilters = (HashSet<IApiProblemFilter>)this.fFilterMap.get(resource);
                if (pfilters == null) {
                    pfilters = new HashSet<IApiProblemFilter>();
                    this.fFilterMap.put(resource, pfilters);
                }
                this.fNeedsSaving |= pfilters.add(filters[i]);
            }
            ++i;
        }
        this.persistApiFilters();
    }

    public synchronized void addFilters(IApiProblem[] problems) {
        this.internalAddFilters(problems, true);
    }

    public synchronized IApiProblemFilter[] getFilters(IResource resource) {
        this.initializeApiFilters();
        HashSet filters = (HashSet)this.fFilterMap.get(resource);
        if (filters == null) {
            return new IApiProblemFilter[0];
        }
        return filters.toArray(new IApiProblemFilter[filters.size()]);
    }

    public synchronized boolean isFiltered(IApiProblem problem) {
        this.initializeApiFilters();
        IResource resource = this.fProject.getProject().findMember((IPath)new Path(problem.getResourcePath()));
        if (resource == null) {
            return false;
        }
        HashSet filters = (HashSet)this.fFilterMap.get(resource);
        if (filters == null) {
            if (DEBUG) {
                System.out.println("no filters defined for [" + problem.getResourcePath() + "] return not filtered");
            }
            return false;
        }
        IApiProblemFilter filter = null;
        Iterator iter = filters.iterator();
        while (iter.hasNext()) {
            filter = (IApiProblemFilter)iter.next();
            if (!filter.getUnderlyingProblem().equals(problem)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (this.fFilterMap != null) {
            this.fFilterMap.clear();
            this.fFilterMap = null;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public synchronized IResource[] getResources() {
        this.initializeApiFilters();
        Set resources = this.fFilterMap.keySet();
        return resources.toArray(new IResource[resources.size()]);
    }

    public synchronized boolean removeFilters(IApiProblemFilter[] filters) {
        if (filters == null) {
            if (DEBUG) {
                System.out.println("null filters array, not removing");
            }
            return false;
        }
        if (this.fFilterMap == null) {
            if (DEBUG) {
                System.out.println("null filter map, not removing");
            }
            return false;
        }
        boolean success = true;
        HashSet pfilters = null;
        IResource resource = null;
        int i = 0;
        while (i < filters.length) {
            resource = this.fProject.getProject().findMember((IPath)new Path(filters[i].getUnderlyingProblem().getResourcePath()));
            if (resource != null) {
                pfilters = (HashSet)this.fFilterMap.get(resource);
                if (pfilters != null && pfilters.remove(filters[i])) {
                    if (DEBUG) {
                        System.out.println("removed filter: [" + filters[i] + "]");
                    }
                    this.fNeedsSaving |= true;
                    success &= true;
                    if (pfilters.isEmpty()) {
                        success &= this.fFilterMap.remove(resource) != null;
                    }
                } else {
                    success &= false;
                }
            }
            ++i;
        }
        this.persistApiFilters();
        return success;
    }

    private String getStoreAsXml() throws CoreException {
        if (this.fFilterMap == null) {
            return null;
        }
        if (this.fFilterMap.isEmpty()) {
            return null;
        }
        Document document = Util.newDocument();
        Element root = document.createElement("component");
        document.appendChild(root);
        root.setAttribute("id", this.fProject.getElementName());
        root.setAttribute("version", "1");
        HashSet filters = null;
        IResource resource = null;
        IApiProblem problem = null;
        Element relement = null;
        Element felement = null;
        Iterator iter = this.fFilterMap.keySet().iterator();
        while (iter.hasNext()) {
            resource = (IResource)iter.next();
            relement = document.createElement("resource");
            relement.setAttribute("path", resource.getProjectRelativePath().toPortableString());
            root.appendChild(relement);
            filters = (HashSet)this.fFilterMap.get(resource);
            if (filters.isEmpty()) continue;
            Iterator iter2 = filters.iterator();
            while (iter2.hasNext()) {
                problem = ((IApiProblemFilter)iter2.next()).getUnderlyingProblem();
                felement = document.createElement("filter");
                felement.setAttribute("id", Integer.toString(problem.getId()));
                if (problem.getMessageArguments().length > 0) {
                    felement.setAttribute("messageargs", this.createArgAttribute(problem.getMessageArguments()));
                }
                relement.appendChild(felement);
            }
        }
        return Util.serializeDocument(document);
    }

    private String createArgAttribute(String[] args) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            buff.append(args[i]);
            if (i < args.length - 1) {
                buff.append("#");
            }
            ++i;
        }
        return buff.toString();
    }

    private void initializeApiFilters() {
        if (this.fFilterMap != null) {
            return;
        }
        if (DEBUG) {
            System.out.println("null filter map, creating a new one");
        }
        this.fFilterMap = new HashMap(5);
        IPath filepath = this.getFilterFilePath();
        IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(filepath);
        if (file == null) {
            return;
        }
        String xml = null;
        try {
            xml = new String(Util.getInputStreamAsCharArray(((IFile)file).getContents(), -1, "UTF-8"));
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        if (xml == null) {
            return;
        }
        Element root = null;
        try {
            root = Util.parseDocument(xml);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
        if (!root.getNodeName().equals("component")) {
            return;
        }
        String component = root.getAttribute("id");
        if (component.length() == 0) {
            return;
        }
        NodeList resources = root.getElementsByTagName("resource");
        Element element = null;
        String path = null;
        NodeList filters = null;
        int id = 0;
        String[] messageargs = null;
        IResource resource = null;
        ArrayList<IApiProblem> newfilters = new ArrayList<IApiProblem>();
        int i = 0;
        while (i < resources.getLength()) {
            IProject project;
            element = (Element)resources.item(i);
            path = element.getAttribute("path");
            if (path.length() != 0 && (project = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(component)) != null && (resource = project.findMember((IPath)new Path(path))) != null) {
                filters = element.getElementsByTagName("filter");
                int j = 0;
                while (j < filters.getLength()) {
                    element = (Element)filters.item(j);
                    id = ApiFilterStore.loadIntegerAttribute(element, "id");
                    if (id > 0) {
                        messageargs = element.getAttribute("messageargs").split("#");
                        newfilters.add(ApiProblemFactory.newApiProblem(resource.getProjectRelativePath().toPortableString(), messageargs, null, null, -1, -1, -1, id));
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.internalAddFilters(newfilters.toArray(new IApiProblem[newfilters.size()]), false);
        newfilters.clear();
    }

    private void internalAddFilters(IApiProblem[] problems, boolean persist) {
        if (problems == null) {
            if (DEBUG) {
                System.out.println("null problems array not addding filters");
            }
            return;
        }
        this.initializeApiFilters();
        ApiProblemFilter filter = null;
        IResource resource = null;
        HashSet<ApiProblemFilter> filters = null;
        int i = 0;
        while (i < problems.length) {
            filter = new ApiProblemFilter(this.fProject.getElementName(), problems[i]);
            resource = this.fProject.getProject().findMember((IPath)new Path(problems[i].getResourcePath()));
            if (resource != null) {
                filters = (HashSet<ApiProblemFilter>)this.fFilterMap.get(resource);
                if (filters == null) {
                    filters = new HashSet<ApiProblemFilter>();
                    this.fFilterMap.put(resource, filters);
                }
                this.fNeedsSaving |= filters.add(filter);
            }
            ++i;
        }
        if (persist) {
            this.persistApiFilters();
        }
    }

    private static int loadIntegerAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() == 0) {
            return -1;
        }
        try {
            int number = Integer.parseInt(value);
            return number;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private IPath getFilterFilePath() {
        IPath path = this.fProject.getPath();
        path = path.append(".settings").append(".api_filters");
        return path;
    }

    public String toString() {
        return "Api filter store for component: " + this.fProject.getElementName();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fTriggeredChange) {
            this.fTriggeredChange = false;
            return;
        }
        if (event.getType() == 1 && event.getType() == 1) {
            IFile file;
            IResource resource;
            IPath path = this.getFilterFilePath();
            IResourceDelta leafdelta = event.getDelta().findMember(path);
            if (leafdelta == null) {
                return;
            }
            boolean needsbuild = false;
            if (leafdelta.getKind() == 2) {
                if (this.fFilterMap != null) {
                    this.fFilterMap.clear();
                    needsbuild = true;
                }
            } else if ((leafdelta.getKind() == 1 || (leafdelta.getFlags() & 0x100) != 0 || (leafdelta.getFlags() & 0x40000) != 0) && (resource = leafdelta.getResource()) != null && resource.getType() == 1 && (file = (IFile)resource).isAccessible()) {
                try {
                    if (this.fFilterMap != null) {
                        this.fFilterMap.clear();
                        this.fFilterMap = null;
                    }
                    this.initializeApiFilters();
                }
                finally {
                    needsbuild = true;
                }
            }
            if (needsbuild) {
                Util.getBuildJob(new IProject[]{this.fProject.getProject()}).schedule();
            }
        }
    }
}

