/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.ProjectApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.scanner.ScannerMessages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApiDescriptionManager
implements IElementChangedListener,
ISaveParticipant {
    private static ApiDescriptionManager fgDefault;
    private Map fDescriptions = new HashMap();
    public static final IPath API_DESCRIPTIONS_CONTAINER_PATH;

    static {
        API_DESCRIPTIONS_CONTAINER_PATH = ApiPlugin.getDefault().getStateLocation();
    }

    private ApiDescriptionManager() {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
        ApiPlugin.getDefault().addSaveParticipant(this);
    }

    public static void shutdown() {
        if (fgDefault != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)fgDefault);
            ApiPlugin.getDefault().removeSaveParticipant(fgDefault);
        }
    }

    public static synchronized ApiDescriptionManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new ApiDescriptionManager();
        }
        return fgDefault;
    }

    public synchronized IApiDescription getApiDescription(IJavaProject project, BundleDescription bundle) {
        ProjectApiDescription description = (ProjectApiDescription)this.fDescriptions.get(project);
        if (description == null) {
            description = new ProjectApiDescription(project);
            try {
                this.restoreDescription(project, description);
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
                description = new ProjectApiDescription(project);
            }
            this.fDescriptions.put(project, description);
        }
        description.connect(bundle);
        return description;
    }

    public synchronized void clean(IJavaProject project, boolean delete, boolean remove) {
        File file;
        ProjectApiDescription desc = null;
        desc = remove ? (ProjectApiDescription)this.fDescriptions.remove(project) : (ProjectApiDescription)this.fDescriptions.get(project);
        if (desc != null) {
            desc.clean();
        }
        if (delete && (file = API_DESCRIPTIONS_CONTAINER_PATH.append(project.getElementName()).append(".api_description").toFile()).exists()) {
            file.delete();
        }
    }

    synchronized void projectChanged(IJavaProject project) {
        ProjectApiDescription desc = (ProjectApiDescription)this.fDescriptions.get(project);
        if (desc != null) {
            desc.projectChanged();
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        this.processJavaElementDeltas(delta.getAffectedChildren());
    }

    private synchronized void processJavaElementDeltas(IJavaElementDelta[] deltas) {
        IJavaElementDelta delta = null;
        int i = 0;
        while (i < deltas.length) {
            delta = deltas[i];
            block0 : switch (delta.getElement().getElementType()) {
                case 2: {
                    IJavaProject proj = (IJavaProject)delta.getElement();
                    switch (delta.getKind()) {
                        case 4: {
                            int flags = delta.getFlags();
                            if ((flags & 0x400) != 0) {
                                this.clean(proj, false, true);
                                break block0;
                            }
                            this.projectChanged(proj);
                            break block0;
                        }
                        case 2: {
                            this.clean(proj, true, true);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public synchronized void saving(ISaveContext context) throws CoreException {
        Iterator entries = this.fDescriptions.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IJavaProject project = (IJavaProject)entry.getKey();
            ProjectApiDescription desc = (ProjectApiDescription)entry.getValue();
            if (!desc.isModified()) continue;
            File dir = API_DESCRIPTIONS_CONTAINER_PATH.append(project.getElementName()).toFile();
            dir.mkdirs();
            String xml = desc.getXML();
            try {
                Util.saveFile(new File(dir, ".api_description"), xml);
            }
            catch (IOException e) {
                ApiDescriptionManager.abort(MessageFormat.format((String)ScannerMessages.ApiDescriptionManager_0, (Object[])new String[]{project.getElementName()}), e);
            }
        }
    }

    private boolean restoreDescription(IJavaProject project, ProjectApiDescription description) throws CoreException {
        File file = API_DESCRIPTIONS_CONTAINER_PATH.append(project.getElementName()).append(".api_description").toFile();
        if (file.exists()) {
            try {
                String xml = new String(Util.getInputStreamAsCharArray(new BufferedInputStream(new FileInputStream(file)), -1, "UTF-8"));
                Element root = Util.parseDocument(xml);
                if (!root.getNodeName().equals("component")) {
                    ApiDescriptionManager.abort(ScannerMessages.ComponentXMLScanner_0, null);
                }
                long timestamp = this.getLong(root, "modificationStamp");
                String version = root.getAttribute("version");
                if ("1.1".equals(version)) {
                    description.fPackageTimeStamp = timestamp;
                    description.fManifestFile = project.getProject().getFile("META-INF/MANIFEST.MF");
                    this.restoreChildren(description, root, null, description.fPackageMap);
                    return true;
                }
            }
            catch (IOException e) {
                ApiDescriptionManager.abort(MessageFormat.format((String)ScannerMessages.ApiDescriptionManager_1, (Object[])new String[]{project.getElementName()}), e);
            }
        }
        return false;
    }

    private void restoreChildren(ProjectApiDescription apiDesc, Element element, ApiDescription.ManifestNode parentNode, Map childrenMap) throws CoreException {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.restoreNode(apiDesc, (Element)child, parentNode, childrenMap);
            }
            ++i;
        }
    }

    private void restoreNode(ProjectApiDescription apiDesc, Element element, ApiDescription.ManifestNode parentNode, Map childrenMap) throws CoreException {
        ApiDescription.ManifestNode node = null;
        IElementDescriptor elementDesc = null;
        if (element.getTagName().equals("package")) {
            int vis = this.getInt(element, "visibility");
            int res = this.getInt(element, "restrictions");
            ArrayList<IJavaElement> fragments = new ArrayList<IJavaElement>();
            NodeList childNodes = element.getChildNodes();
            String pkgName = null;
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                if (child.getNodeType() == 1 && ((Element)child).getTagName().equals("fragment")) {
                    Element fragment = (Element)child;
                    String handle = fragment.getAttribute("handle");
                    IJavaElement je = JavaCore.create((String)handle);
                    if (je.getElementType() != 4) {
                        ApiDescriptionManager.abort(String.valueOf(ScannerMessages.ApiDescriptionManager_2) + handle, null);
                    }
                    pkgName = je.getElementName();
                    fragments.add(je);
                }
                ++i;
            }
            if (!fragments.isEmpty()) {
                elementDesc = Factory.packageDescriptor(pkgName);
                node = apiDesc.newPackageNode(fragments.toArray(new IPackageFragment[fragments.size()]), parentNode, elementDesc, vis, res);
            } else {
                ApiDescriptionManager.abort(ScannerMessages.ApiDescriptionManager_2, null);
            }
        } else {
            if (element.getTagName().equals("fragment")) {
                return;
            }
            if (element.getTagName().equals("type")) {
                String handle = element.getAttribute("handle");
                int vis = this.getInt(element, "visibility");
                int res = this.getInt(element, "restrictions");
                IJavaElement je = JavaCore.create((String)handle);
                if (je.getElementType() != 7) {
                    ApiDescriptionManager.abort(String.valueOf(ScannerMessages.ApiDescriptionManager_3) + handle, null);
                }
                IType type = (IType)je;
                elementDesc = Factory.typeDescriptor(type.getFullyQualifiedName('$'));
                ProjectApiDescription.TypeNode tn = apiDesc.newTypeNode(type, parentNode, elementDesc, vis, res);
                node = tn;
                tn.fTimeStamp = this.getLong(element, "modificationStamp");
            } else if (element.getTagName().equals("field")) {
                if (parentNode.element instanceof IReferenceTypeDescriptor) {
                    IReferenceTypeDescriptor type = (IReferenceTypeDescriptor)parentNode.element;
                    int vis = this.getInt(element, "visibility");
                    int res = this.getInt(element, "restrictions");
                    String name = element.getAttribute("name");
                    elementDesc = type.getField(name);
                    node = apiDesc.newNode(parentNode, elementDesc, vis, res);
                }
            } else if (element.getTagName().equals("method") && parentNode.element instanceof IReferenceTypeDescriptor) {
                IReferenceTypeDescriptor type = (IReferenceTypeDescriptor)parentNode.element;
                int vis = this.getInt(element, "visibility");
                int res = this.getInt(element, "restrictions");
                String name = element.getAttribute("name");
                String sig = element.getAttribute("signature");
                elementDesc = type.getMethod(name, sig, 0);
                node = apiDesc.newNode(parentNode, elementDesc, vis, res);
            }
        }
        if (node == null) {
            ApiDescriptionManager.abort(ScannerMessages.ApiDescriptionManager_4, null);
        }
        childrenMap.put(elementDesc, node);
        this.restoreChildren(apiDesc, element, node, node.children);
    }

    private int getInt(Element element, String attr) {
        String attribute = element.getAttribute(attr);
        if (attribute != null) {
            try {
                return Integer.parseInt(attribute);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    private long getLong(Element element, String attr) {
        String attribute = element.getAttribute(attr);
        if (attribute != null) {
            try {
                return Long.parseLong(attribute);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, ApiPlugin.getPluginIdentifier(), message, exception);
        throw new CoreException((IStatus)status);
    }
}

