/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.util.Util;

public abstract class AbstractClassFile
implements IClassFile {
    public byte[] getContents() throws CoreException {
        InputStream inputStream = this.getInputStream();
        try {
            byte[] byArray = Util.getInputStreamAsByteArray(inputStream, -1);
            return byArray;
        }
        catch (IOException e) {
            this.abort("Unable to read class file: " + this.getTypeName(), e);
            return null;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
        }
    }

    private void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", message, e));
    }
}

