/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.AbstractClassFileContainer;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.stubs.Converter;

public abstract class AbstractApiComponent
extends AbstractClassFileContainer
implements IApiComponent {
    private IApiDescription fApiDescription = null;
    private IApiFilterStore fFilterStore = null;
    private IApiProfile fProfile = null;
    private static CRC32 fgCRC32 = new CRC32();

    public AbstractApiComponent(IApiProfile profile) {
        this.fProfile = profile;
    }

    public void accept(ClassFileContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            super.accept(visitor);
        }
        visitor.end(this);
    }

    public IApiProfile getProfile() {
        return this.fProfile;
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        this.fApiDescription = null;
        this.fProfile = null;
    }

    public synchronized IApiDescription getApiDescription() throws CoreException {
        if (this.fApiDescription == null) {
            this.fApiDescription = this.createApiDescription();
        }
        return this.fApiDescription;
    }

    protected synchronized boolean hasApiDescription() {
        return this.fApiDescription != null;
    }

    protected synchronized boolean hasApiFilterStore() {
        return this.fFilterStore != null;
    }

    public IClassFileContainer[] getClassFileContainers() {
        return super.getClassFileContainers();
    }

    public IClassFileContainer[] getClassFileContainers(String id) {
        if (this.hasFragments()) {
            return super.getClassFileContainers(id);
        }
        return super.getClassFileContainers();
    }

    protected abstract IApiDescription createApiDescription() throws CoreException;

    protected void writeZipFileEntry(ZipOutputStream outputStream, String entryName, byte[] bytes, boolean compress) throws IOException {
        fgCRC32.reset();
        int byteArraySize = bytes.length;
        fgCRC32.update(bytes, 0, byteArraySize);
        ZipEntry entry = new ZipEntry(entryName);
        entry.setMethod(compress ? 8 : 0);
        entry.setSize(byteArraySize);
        entry.setCrc(fgCRC32.getValue());
        outputStream.putNextEntry(entry);
        outputStream.write(bytes, 0, byteArraySize);
        outputStream.closeEntry();
    }

    protected int writeContainer(IClassFileContainer container, ZipOutputStream zip, boolean compress, boolean stub) throws CoreException {
        Exporter exporter = new Exporter(zip, compress, stub);
        container.accept(exporter);
        return exporter.getEntriesWritten();
    }

    public IApiFilterStore getFilterStore() throws CoreException {
        if (this.fFilterStore == null) {
            this.fFilterStore = this.createApiFilterStore();
        }
        return this.fFilterStore;
    }

    public IApiProblemFilter newProblemFilter(IApiProblem problem) {
        return new ApiProblemFilter(this.getId(), problem);
    }

    protected abstract IApiFilterStore createApiFilterStore() throws CoreException;

    class Exporter
    extends ClassFileContainerVisitor {
        private ZipOutputStream fZip;
        private boolean fCompress;
        private boolean fStub;
        private int fEntriesWritten = 0;

        public Exporter(ZipOutputStream zip, boolean compress, boolean stub) {
            this.fZip = zip;
            this.fCompress = compress;
            this.fStub = stub;
        }

        public void visit(String packageName, IClassFile classFile) {
            try {
                byte[] contents = null;
                contents = this.fStub ? Converter.createStub(classFile, 15880) : classFile.getContents();
                if (contents != null) {
                    String entryName = String.valueOf(classFile.getTypeName().replace('.', '/')) + ".class";
                    AbstractApiComponent.this.writeZipFileEntry(this.fZip, entryName, contents, this.fCompress);
                    ++this.fEntriesWritten;
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }

        public int getEntriesWritten() {
            return this.fEntriesWritten;
        }
    }
}

