/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.eclipse.ltk.core.refactoring.resource.MoveResourcesDescriptor;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.Resources;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceModifications;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;

public class MoveResourcesProcessor
extends MoveProcessor {
    private final IResource[] fResourcesToMove;
    private IContainer fDestination;
    private boolean fUpdateReferences;
    private MoveArguments fMoveArguments;
    static /* synthetic */ Class class$0;

    public MoveResourcesProcessor(IResource[] resourcesToMove) {
        if (resourcesToMove == null) {
            throw new IllegalArgumentException("resources must not be null");
        }
        this.fResourcesToMove = resourcesToMove;
        this.fDestination = null;
        this.fUpdateReferences = true;
    }

    public IResource[] getResourcesToMove() {
        return this.fResourcesToMove;
    }

    public void setDestination(IContainer destination) {
        Assert.isNotNull((Object)destination);
        this.fDestination = destination;
    }

    public boolean isUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create(Resources.checkInSync(this.fResourcesToMove)));
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus status = this.validateDestination(this.fDestination);
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            this.fMoveArguments = new MoveArguments(this.fDestination, this.isUpdateReferences());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(clazz);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            int i = 0;
            while (i < this.fResourcesToMove.length) {
                IResource resource = this.fResourcesToMove[i];
                IResource newResource = this.fDestination.findMember(resource.getName());
                if (newResource != null) {
                    status.addWarning(Messages.format(RefactoringCoreMessages.MoveResourcesProcessor_warning_destination_already_exists, newResource.getFullPath().toString()));
                    deltaFactory.delete(newResource);
                }
                ResourceModifications.buildMoveDelta(deltaFactory, this.fResourcesToMove[i], this.fMoveArguments);
                ++i;
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus validateDestination(IContainer destination) {
        Assert.isNotNull((Object)destination, (String)"container is null");
        if (destination instanceof IWorkspaceRoot) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.MoveResourceProcessor_error_invalid_destination);
        }
        if (!destination.exists()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.MoveResourceProcessor_error_destination_not_exists);
        }
        IPath destinationPath = destination.getFullPath();
        int i = 0;
        while (i < this.fResourcesToMove.length) {
            IPath path = this.fResourcesToMove[i].getFullPath();
            if (path.isPrefixOf(destinationPath) || path.equals((Object)destinationPath)) {
                return RefactoringStatus.createFatalErrorStatus(Messages.format(RefactoringCoreMessages.MoveResourceProcessor_destination_inside_moved, path.toString()));
            }
            if (path.removeLastSegments(1).equals((Object)destinationPath)) {
                return RefactoringStatus.createFatalErrorStatus(Messages.format(RefactoringCoreMessages.MoveResourceProcessor_destination_same_as_moved, path.toString()));
            }
            ++i;
        }
        return new RefactoringStatus();
    }

    private String getMoveDescription() {
        if (this.fResourcesToMove.length == 1) {
            return Messages.format(RefactoringCoreMessages.MoveResourceProcessor_description_multiple, new Object[]{new Integer(this.fResourcesToMove.length), this.fDestination.getName()});
        }
        return Messages.format(RefactoringCoreMessages.MoveResourceProcessor_description_single, new String[]{this.fResourcesToMove[0].getName(), this.fDestination.getName()});
    }

    protected MoveResourcesDescriptor createDescriptor() {
        MoveResourcesDescriptor descriptor = new MoveResourcesDescriptor();
        descriptor.setProject(this.fDestination.getProject().getName());
        descriptor.setDescription(this.getMoveDescription());
        if (this.fResourcesToMove.length == 1) {
            descriptor.setComment(descriptor.getDescription());
        } else {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.fResourcesToMove.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.fResourcesToMove[i].getName());
                ++i;
            }
            descriptor.setComment(Messages.format(RefactoringCoreMessages.MoveResourceProcessor_comment, new String[]{this.fResourcesToMove[0].getName(), this.fDestination.getName()}));
        }
        descriptor.setFlags(7);
        descriptor.setDestination(this.fDestination);
        descriptor.setUpdateReferences(this.isUpdateReferences());
        descriptor.setResourcesToMove(this.fResourcesToMove);
        return descriptor;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fResourcesToMove.length);
        try {
            CompositeChange compositeChange = new CompositeChange(this.getMoveDescription());
            compositeChange.markAsSynthetic();
            RefactoringChangeDescriptor descriptor = new RefactoringChangeDescriptor(this.createDescriptor());
            int i = 0;
            while (i < this.fResourcesToMove.length) {
                MoveResourceChange moveChange = new MoveResourceChange(this.fResourcesToMove[i], this.fDestination);
                moveChange.setDescriptor(descriptor);
                compositeChange.add(moveChange);
                ++i;
            }
            CompositeChange compositeChange2 = compositeChange;
            return compositeChange2;
        }
        finally {
            pm.done();
        }
    }

    public Object[] getElements() {
        return this.fResourcesToMove;
    }

    public String getIdentifier() {
        return "org.eclipse.ltk.core.refactoring.moveResourcesProcessor";
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.MoveResourceProcessor_processor_name;
    }

    public boolean isApplicable() {
        int i = 0;
        while (i < this.fResourcesToMove.length) {
            if (!MoveResourcesProcessor.canMove(this.fResourcesToMove[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean canMove(IResource res) {
        return (res instanceof IFile || res instanceof IFolder) && res.exists() && !res.isPhantom();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        String[] affectedNatures = ResourceProcessors.computeAffectedNatures(this.fResourcesToMove);
        ArrayList<MoveParticipant> result = new ArrayList<MoveParticipant>();
        int i = 0;
        while (i < this.fResourcesToMove.length) {
            MoveParticipant[] participants = ParticipantManager.loadMoveParticipants(status, this, this.fResourcesToMove[i], this.fMoveArguments, null, affectedNatures, shared);
            result.addAll(Arrays.asList(participants));
            ++i;
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }
}

