/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

public class MoveResourceChange
extends ResourceChange {
    private final IResource fSource;
    private final IContainer fTarget;
    private final long fStampToRestore;
    private final Change fRestoreSourceChange;
    private ChangeDescriptor fDescriptor;

    public MoveResourceChange(IResource source, IContainer target) {
        this(source, target, -1L, null);
    }

    protected MoveResourceChange(IResource source, IContainer target, long stampToRestore, Change restoreSourceChange) {
        this.fSource = source;
        this.fTarget = target;
        this.fStampToRestore = stampToRestore;
        this.fRestoreSourceChange = restoreSourceChange;
        this.setValidationMethod(2);
    }

    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public final Change perform(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(this.getName(), 4);
            Change deleteUndo = null;
            IResource resourceAtDestination = this.fTarget.findMember(this.fSource.getName());
            if (resourceAtDestination != null && resourceAtDestination.exists()) {
                deleteUndo = this.performDestinationDelete(resourceAtDestination, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            long currentStamp = this.fSource.getModificationStamp();
            IPath destinationPath = this.fTarget.getFullPath().append(this.fSource.getName());
            this.fSource.move(destinationPath, 34, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            resourceAtDestination = ResourcesPlugin.getWorkspace().getRoot().findMember(destinationPath);
            if (this.fStampToRestore != -1L) {
                resourceAtDestination.revertModificationStamp(this.fStampToRestore);
            }
            if (this.fRestoreSourceChange != null) {
                this.performSourceRestore((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            MoveResourceChange moveResourceChange = new MoveResourceChange(resourceAtDestination, this.fSource.getParent(), currentStamp, deleteUndo);
            return moveResourceChange;
        }
        finally {
            monitor.done();
        }
    }

    private Change performDestinationDelete(IResource newResource, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(RefactoringCoreMessages.MoveResourceChange_progress_delete_destination, 3);
        try {
            DeleteResourceChange deleteChange = new DeleteResourceChange(newResource.getFullPath(), true);
            deleteChange.initializeValidationData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            RefactoringStatus deleteStatus = deleteChange.isValid((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!deleteStatus.hasFatalError()) {
                Change change = deleteChange.perform((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return change;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private void performSourceRestore(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(RefactoringCoreMessages.MoveResourceChange_progress_restore_source, 3);
        try {
            this.fRestoreSourceChange.initializeValidationData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            RefactoringStatus restoreStatus = this.fRestoreSourceChange.isValid((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!restoreStatus.hasFatalError()) {
                this.fRestoreSourceChange.perform((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IResource getModifiedResource() {
        return this.fSource;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.MoveResourceChange_name, new String[]{this.fSource.getFullPath().makeRelative().toString(), this.fTarget.getName()});
    }
}

