/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.directorywatcher;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.generator.features.FeatureParser;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.Activator;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.Messages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.BundleDescriptionFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Feature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.MetadataGeneratorHelper;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.URLEntry;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RepositoryListener
extends DirectoryChangeListener {
    private static final String ARTIFACT_FOLDER = "artifact.folder";
    private static final String ARTIFACT_REFERENCE = "artifact.reference";
    private static final String FILE_LAST_MODIFIED = "file.lastModified";
    private static final String FILE_NAME = "file.name";
    private final IMetadataRepository metadataRepository;
    private final IArtifactRepository artifactRepository;
    private final BundleDescriptionFactory bundleDescriptionFactory;
    private final Map currentFiles = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public RepositoryListener(BundleContext context, String repositoryName, File repositoryFolder, boolean hidden) {
        URL stateDirURL;
        File stateDir;
        if (repositoryFolder == null) {
            String stateDirName = "listener_" + repositoryName.hashCode();
            stateDir = context.getDataFile(stateDirName);
            stateDir.mkdirs();
        } else {
            stateDir = repositoryFolder;
        }
        try {
            stateDirURL = stateDir.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
        this.metadataRepository = this.initializeMetadataRepository(context, repositoryName, stateDirURL, hidden);
        this.artifactRepository = this.initializeArtifactRepository(context, repositoryName, stateDirURL, hidden);
        this.bundleDescriptionFactory = this.initializeBundleDescriptionFactory(context);
    }

    public RepositoryListener(BundleContext context, IMetadataRepository metadataRepository, IArtifactRepository artifactRepository) {
        this.artifactRepository = artifactRepository;
        this.metadataRepository = metadataRepository;
        this.bundleDescriptionFactory = this.initializeBundleDescriptionFactory(context);
    }

    private void publishSites(Feature feature) {
        IProvisioningEventBus bus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME);
        if (bus == null) {
            return;
        }
        URLEntry[] discoverySites = feature.getDiscoverySites();
        int i = 0;
        while (i < discoverySites.length) {
            this.publishSite(feature, bus, discoverySites[i].getURL(), false);
            ++i;
        }
        String updateSite = feature.getUpdateSiteURL();
        if (updateSite != null) {
            this.publishSite(feature, bus, updateSite, true);
        }
    }

    private void publishSite(Feature feature, IProvisioningEventBus bus, String locationString, boolean isEnabled) {
        try {
            URL location = new URL(locationString);
            bus.publishEvent((EventObject)new RepositoryEvent(location, 0, 4, isEnabled));
            bus.publishEvent((EventObject)new RepositoryEvent(location, 1, 4, isEnabled));
        }
        catch (MalformedURLException e) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.directorywatcher", "Feature references invalid site: " + feature.getId(), (Throwable)e));
        }
    }

    private BundleDescriptionFactory initializeBundleDescriptionFactory(BundleContext context) {
        ServiceReference reference;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = context.getServiceReference(clazz.getName())) == null) {
            throw new IllegalStateException(Messages.platformadmin_not_registered);
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)context.getService(reference);
        if (platformAdmin == null) {
            throw new IllegalStateException(Messages.platformadmin_not_registered);
        }
        try {
            StateObjectFactory stateObjectFactory = platformAdmin.getFactory();
            BundleDescriptionFactory bundleDescriptionFactory = new BundleDescriptionFactory(stateObjectFactory, null);
            return bundleDescriptionFactory;
        }
        finally {
            context.ungetService(reference);
        }
    }

    private IArtifactRepository initializeArtifactRepository(BundleContext context, String repositoryName, URL stateDirURL, boolean hidden) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        IArtifactRepositoryManager manager = null;
        if (reference != null) {
            manager = (IArtifactRepositoryManager)context.getService(reference);
        }
        if (manager == null) {
            throw new IllegalStateException(Messages.artifact_repo_manager_not_registered);
        }
        try {
            IArtifactRepository iArtifactRepository = manager.loadRepository(stateDirURL, null);
            return iArtifactRepository;
        }
        catch (ProvisionException provisionException) {
            try {
                String name = repositoryName;
                HashMap<String, String> properties = new HashMap<String, String>(1);
                if (hidden) {
                    properties.put("p2.system", Boolean.TRUE.toString());
                    name = "artifact listener " + repositoryName;
                }
                IArtifactRepository repository = manager.createRepository(stateDirURL, name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
                manager.addRepository(repository.getLocation());
                IArtifactRepository iArtifactRepository = repository;
                return iArtifactRepository;
            }
            catch (ProvisionException e) {
                LogHelper.log((ProvisionException)e);
                throw new IllegalStateException(NLS.bind((String)Messages.failed_create_artifact_repo, (Object)stateDirURL));
            }
        }
        finally {
            context.ungetService(reference);
        }
    }

    private IMetadataRepository initializeMetadataRepository(BundleContext context, String repositoryName, URL stateDirURL, boolean hidden) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        IMetadataRepositoryManager manager = null;
        if (reference != null) {
            manager = (IMetadataRepositoryManager)context.getService(reference);
        }
        if (manager == null) {
            throw new IllegalStateException(Messages.metadata_repo_manager_not_registered);
        }
        try {
            IMetadataRepository iMetadataRepository = manager.loadRepository(stateDirURL, null);
            return iMetadataRepository;
        }
        catch (ProvisionException provisionException) {
            String name = repositoryName;
            HashMap<String, String> properties = new HashMap<String, String>(1);
            if (hidden) {
                properties.put("p2.system", Boolean.TRUE.toString());
                name = "metadata listener " + repositoryName;
            }
            IMetadataRepository repository = manager.createRepository(stateDirURL, name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            manager.addRepository(stateDirURL);
            IMetadataRepository iMetadataRepository = repository;
            return iMetadataRepository;
        }
        finally {
            context.ungetService(reference);
        }
    }

    public boolean added(File file) {
        if (this.isFeature(file) || this.isBundle(file)) {
            this.currentFiles.put(file, new Long(file.lastModified()));
            return true;
        }
        return false;
    }

    public boolean changed(File file) {
        if (this.isFeature(file) || this.isBundle(file)) {
            this.currentFiles.put(file, new Long(file.lastModified()));
            return true;
        }
        return false;
    }

    public boolean removed(File file) {
        this.currentFiles.remove(file);
        return true;
    }

    private boolean isBundle(File file) {
        if (file.isDirectory() || file.getName().endsWith(".jar")) {
            BundleDescription bundleDescription = this.bundleDescriptionFactory.getBundleDescription(file);
            return bundleDescription != null;
        }
        return false;
    }

    boolean isFeature(File file) {
        return file.isDirectory() && file.getParentFile() != null && file.getParentFile().getName().equals("features") && new File(file, "feature.xml").exists();
    }

    public boolean isInterested(File file) {
        return true;
    }

    public Long getSeenFile(File file) {
        return (Long)this.currentFiles.get(file);
    }

    public void startPoll() {
    }

    public void stopPoll() {
        if (this.metadataRepository != null) {
            this.synchronizeMetadataRepository();
        }
        if (this.artifactRepository != null) {
            this.synchronizeArtifactRepository();
        }
    }

    private void synchronizeMetadataRepository() {
        IInstallableUnit[] iusToAdd;
        final HashMap snapshot = new HashMap(this.currentFiles);
        final ArrayList featureFiles = new ArrayList();
        Query removeQuery = new Query(){

            public boolean isMatch(Object candidate) {
                if (!(candidate instanceof IInstallableUnit)) {
                    return false;
                }
                IInstallableUnit iu = (IInstallableUnit)candidate;
                File iuFile = new File(iu.getProperty(RepositoryListener.FILE_NAME));
                if (featureFiles.contains(iuFile)) {
                    return false;
                }
                Long iuLastModified = new Long(iu.getProperty(RepositoryListener.FILE_LAST_MODIFIED));
                Long snapshotLastModified = (Long)snapshot.get(iuFile);
                if (snapshotLastModified == null || !snapshotLastModified.equals(iuLastModified)) {
                    return true;
                }
                snapshot.remove(iuFile);
                if (RepositoryListener.this.isFeature(iuFile)) {
                    featureFiles.add(iuFile);
                }
                return false;
            }
        };
        this.metadataRepository.removeInstallableUnits(removeQuery, null);
        if (!snapshot.isEmpty() && (iusToAdd = this.generateIUs(snapshot.keySet())).length != 0) {
            this.metadataRepository.addInstallableUnits(iusToAdd);
        }
    }

    private void synchronizeArtifactRepository() {
        HashMap snapshot = new HashMap(this.currentFiles);
        ArrayList<IArtifactKey> keys = new ArrayList<IArtifactKey>(Arrays.asList(this.artifactRepository.getArtifactKeys()));
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            IArtifactKey key = (IArtifactKey)it.next();
            IArtifactDescriptor[] descriptors = this.artifactRepository.getArtifactDescriptors(key);
            int i = 0;
            while (i < descriptors.length) {
                ArtifactDescriptor descriptor = (ArtifactDescriptor)descriptors[i];
                File artifactFile = new File(descriptor.getRepositoryProperty(FILE_NAME));
                Long artifactLastModified = new Long(descriptor.getRepositoryProperty(FILE_LAST_MODIFIED));
                Long snapshotLastModified = (Long)snapshot.get(artifactFile);
                if (snapshotLastModified == null || !snapshotLastModified.equals(artifactLastModified)) {
                    this.artifactRepository.removeDescriptor((IArtifactDescriptor)descriptor);
                } else {
                    snapshot.remove(artifactFile);
                }
                ++i;
            }
        }
        if (!snapshot.isEmpty()) {
            ArrayList<IArtifactDescriptor> descriptorsToAdd = new ArrayList<IArtifactDescriptor>();
            Iterator it2 = snapshot.keySet().iterator();
            while (it2.hasNext()) {
                File file = (File)it2.next();
                IArtifactDescriptor descriptor = this.generateArtifactDescriptor(file);
                if (descriptor == null) continue;
                descriptorsToAdd.add(descriptor);
            }
            if (!descriptorsToAdd.isEmpty()) {
                this.artifactRepository.addDescriptors(descriptorsToAdd.toArray(new IArtifactDescriptor[descriptorsToAdd.size()]));
            }
        }
    }

    protected IArtifactDescriptor generateArtifactDescriptor(File candidate) {
        IArtifactDescriptor basicDescriptor = this.generateBasicDescriptor(candidate);
        if (basicDescriptor == null) {
            return null;
        }
        ArtifactDescriptor pathDescriptor = new ArtifactDescriptor(basicDescriptor);
        try {
            pathDescriptor.setRepositoryProperty(ARTIFACT_REFERENCE, candidate.toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        if (candidate.isDirectory()) {
            pathDescriptor.setRepositoryProperty(ARTIFACT_FOLDER, Boolean.TRUE.toString());
        }
        pathDescriptor.setRepositoryProperty(FILE_NAME, candidate.getAbsolutePath());
        pathDescriptor.setRepositoryProperty(FILE_LAST_MODIFIED, Long.toString(candidate.lastModified()));
        return pathDescriptor;
    }

    private IArtifactDescriptor generateBasicDescriptor(File candidate) {
        if (this.isFeature(candidate)) {
            FeatureParser parser = new FeatureParser();
            Feature feature = parser.parse(candidate);
            if (feature == null) {
                return null;
            }
            IArtifactKey featureKey = MetadataGeneratorHelper.createFeatureArtifactKey((String)feature.getId(), (String)feature.getVersion());
            return new ArtifactDescriptor(featureKey);
        }
        BundleDescription bundleDescription = this.bundleDescriptionFactory.getBundleDescription(candidate);
        if (bundleDescription == null) {
            return null;
        }
        IArtifactKey key = MetadataGeneratorHelper.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        return MetadataGeneratorHelper.createArtifactDescriptor((IArtifactKey)key, (File)candidate, (boolean)true, (boolean)false);
    }

    private IInstallableUnit[] generateIUs(Collection files) {
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File candidate = (File)it.next();
            Properties props = new Properties();
            props.setProperty(FILE_NAME, candidate.getAbsolutePath());
            props.setProperty(FILE_LAST_MODIFIED, Long.toString(candidate.lastModified()));
            if (this.isFeature(candidate)) {
                IInstallableUnit[] featureIUs = this.generateFeatureIUs(candidate, props);
                if (featureIUs == null) continue;
                ius.addAll(Arrays.asList(featureIUs));
                continue;
            }
            IInstallableUnit[] bundleIUs = this.generateBundleIU(candidate, props);
            if (bundleIUs == null) continue;
            int i = 0;
            while (i < bundleIUs.length) {
                ius.add(bundleIUs[i]);
                ++i;
            }
        }
        return ius.toArray(new IInstallableUnit[ius.size()]);
    }

    private IInstallableUnit[] generateFeatureIUs(File featureFile, Properties props) {
        FeatureParser parser = new FeatureParser();
        Feature feature = parser.parse(featureFile);
        if (feature == null) {
            return null;
        }
        this.publishSites(feature);
        IInstallableUnit featureIU = MetadataGeneratorHelper.createFeatureJarIU((Feature)feature, (boolean)true, (Properties)props);
        IInstallableUnit groupIU = MetadataGeneratorHelper.createGroupIU((Feature)feature, (IInstallableUnit)featureIU, (Properties)props);
        return new IInstallableUnit[]{featureIU, groupIU};
    }

    private IInstallableUnit[] generateBundleIU(File bundleFile, Properties props) {
        BundleDescription bundleDescription = this.bundleDescriptionFactory.getBundleDescription(bundleFile);
        if (bundleDescription == null) {
            return null;
        }
        IArtifactKey key = MetadataGeneratorHelper.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IInstallableUnit[] ius = MetadataGeneratorHelper.createEclipseIU((BundleDescription)bundleDescription, (Map)((Map)bundleDescription.getUserObject()), (boolean)bundleFile.isDirectory(), (IArtifactKey)key, (Properties)props);
        if (ius.length == 0) {
            return ius;
        }
        int i = 0;
        while (i < ius.length) {
            if (!ius[i].isFragment()) {
                return new IInstallableUnit[]{ius[i]};
            }
            ++i;
        }
        throw new IllegalStateException(Messages.multiple_bundle_ius);
    }

    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }
}

