/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.services.IServiceLocator;

public final class ActiveShellSourceProvider
extends AbstractSourceProvider {
    private static final String STATUS_LINE_VIS = "activeWorkbenchWindow.isStatusLineVisible";
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeShell", "activeWorkbenchWindow", "activeWorkbenchWindowShell", "activeWorkbenchWindow.isCoolbarVisible", "activeWorkbenchWindow.isPerspectiveBarVisible", "activeWorkbenchWindow.activePerspective", "activeWorkbenchWindow.isStatusLineVisible"};
    private Display display;
    private Shell lastActiveShell = null;
    private Shell lastActiveWorkbenchWindowShell = null;
    private WorkbenchWindow lastActiveWorkbenchWindow = null;
    private Boolean lastCoolbarVisibility = Boolean.FALSE;
    private Boolean lastPerspectiveBarVisibility = Boolean.FALSE;
    private Boolean lastStatusLineVisibility = Boolean.FALSE;
    private String lastPerspectiveId = null;
    private final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("coolbarVisible".equals(event.getProperty())) {
                Object newValue = event.getNewValue();
                if (newValue == null || !(newValue instanceof Boolean)) {
                    return;
                }
                if (!ActiveShellSourceProvider.this.lastCoolbarVisibility.equals(newValue)) {
                    ActiveShellSourceProvider.this.fireSourceChanged(32768, "activeWorkbenchWindow.isCoolbarVisible", newValue);
                    ActiveShellSourceProvider.this.lastCoolbarVisibility = (Boolean)newValue;
                }
            } else if ("perspectiveBarVisible".equals(event.getProperty())) {
                Object newValue = event.getNewValue();
                if (newValue == null || !(newValue instanceof Boolean)) {
                    return;
                }
                if (!ActiveShellSourceProvider.this.lastPerspectiveBarVisibility.equals(newValue)) {
                    ActiveShellSourceProvider.this.fireSourceChanged(32768, "activeWorkbenchWindow.isPerspectiveBarVisible", newValue);
                    ActiveShellSourceProvider.this.lastPerspectiveBarVisibility = (Boolean)newValue;
                }
            } else if ("statusLineVisible".equals(event.getProperty())) {
                Object newValue = event.getNewValue();
                if (newValue == null || !(newValue instanceof Boolean)) {
                    return;
                }
                if (!ActiveShellSourceProvider.this.lastStatusLineVisibility.equals(newValue)) {
                    ActiveShellSourceProvider.this.fireSourceChanged(32768, ActiveShellSourceProvider.STATUS_LINE_VIS, newValue);
                    ActiveShellSourceProvider.this.lastStatusLineVisibility = (Boolean)newValue;
                }
            }
        }
    };
    IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            String id;
            String string = id = perspective == null ? null : perspective.getId();
            if (Util.equals(ActiveShellSourceProvider.this.lastPerspectiveId, id)) {
                return;
            }
            ActiveShellSourceProvider.this.fireSourceChanged(32768, "activeWorkbenchWindow.activePerspective", id);
            ActiveShellSourceProvider.this.lastPerspectiveId = id;
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }
    };
    private final Listener listener = new Listener(){

        public final void handleEvent(Event event) {
            boolean perspectiveIdChanged;
            IPerspectiveDescriptor perspective;
            IWorkbenchPage activePage;
            Boolean newPerspectiveBarVisibility;
            Boolean newCoolbarVisibility;
            if (!(event.widget instanceof Shell)) {
                if (ActiveShellSourceProvider.access$9()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("ASSP: passOnEvent: " + event.widget);
                }
                return;
            }
            if (ActiveShellSourceProvider.access$9()) {
                ActiveShellSourceProvider.this.logDebuggingInfo("\tASSP:lastActiveShell: " + ActiveShellSourceProvider.this.lastActiveShell);
                ActiveShellSourceProvider.this.logDebuggingInfo("\tASSP:lastActiveWorkbenchWindowShell" + ActiveShellSourceProvider.this.lastActiveWorkbenchWindowShell);
            }
            Map currentState = ActiveShellSourceProvider.this.getCurrentState();
            Shell newActiveShell = (Shell)currentState.get("activeShell");
            WorkbenchWindow newActiveWorkbenchWindow = (WorkbenchWindow)currentState.get("activeWorkbenchWindow");
            Shell newActiveWorkbenchWindowShell = (Shell)currentState.get("activeWorkbenchWindowShell");
            Boolean bl = newActiveWorkbenchWindow == null ? ActiveShellSourceProvider.this.lastCoolbarVisibility : (newCoolbarVisibility = newActiveWorkbenchWindow.getCoolBarVisible() ? Boolean.TRUE : Boolean.FALSE);
            Boolean bl2 = newActiveWorkbenchWindow == null ? ActiveShellSourceProvider.this.lastPerspectiveBarVisibility : (newPerspectiveBarVisibility = newActiveWorkbenchWindow.getPerspectiveBarVisible() ? Boolean.TRUE : Boolean.FALSE);
            Boolean newStatusLineVis = newActiveWorkbenchWindow == null ? ActiveShellSourceProvider.this.lastStatusLineVisibility : (newActiveWorkbenchWindow.getStatusLineVisible() ? Boolean.TRUE : Boolean.FALSE);
            String perspectiveId = ActiveShellSourceProvider.this.lastPerspectiveId;
            if (newActiveWorkbenchWindow != null && (activePage = newActiveWorkbenchWindow.getActivePage()) != null && (perspective = activePage.getPerspective()) != null) {
                perspectiveId = perspective.getId();
            }
            boolean shellChanged = newActiveShell != ActiveShellSourceProvider.this.lastActiveShell;
            boolean windowChanged = newActiveWorkbenchWindowShell != ActiveShellSourceProvider.this.lastActiveWorkbenchWindowShell;
            boolean coolbarChanged = newCoolbarVisibility != ActiveShellSourceProvider.this.lastCoolbarVisibility;
            boolean statusLineChanged = newStatusLineVis != ActiveShellSourceProvider.this.lastStatusLineVisibility;
            boolean perspectiveBarChanged = newPerspectiveBarVisibility != ActiveShellSourceProvider.this.lastPerspectiveBarVisibility;
            boolean bl3 = perspectiveIdChanged = !Util.equals(ActiveShellSourceProvider.this.lastPerspectiveId, perspectiveId);
            if (shellChanged && windowChanged) {
                HashMap<String, Object> sourceValuesByName = new HashMap<String, Object>(5);
                sourceValuesByName.put("activeShell", newActiveShell);
                sourceValuesByName.put("activeWorkbenchWindow", newActiveWorkbenchWindow);
                sourceValuesByName.put("activeWorkbenchWindowShell", newActiveWorkbenchWindowShell);
                int sourceFlags = 17408;
                if (coolbarChanged) {
                    sourceValuesByName.put("activeWorkbenchWindow.isCoolbarVisible", newCoolbarVisibility);
                    sourceFlags |= 0x8000;
                }
                if (statusLineChanged) {
                    sourceValuesByName.put(ActiveShellSourceProvider.STATUS_LINE_VIS, newStatusLineVis);
                    sourceFlags |= 0x8000;
                }
                if (perspectiveBarChanged) {
                    sourceValuesByName.put("activeWorkbenchWindow.isPerspectiveBarVisible", newPerspectiveBarVisibility);
                    sourceFlags |= 0x8000;
                }
                if (perspectiveIdChanged) {
                    sourceValuesByName.put("activeWorkbenchWindow.activePerspective", perspectiveId);
                    sourceFlags |= 0x8000;
                }
                if (ActiveShellSourceProvider.access$9()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active shell changed to " + newActiveShell);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window changed to " + newActiveWorkbenchWindow);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window shell changed to " + newActiveWorkbenchWindowShell);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window coolbar visibility " + newCoolbarVisibility);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window perspective bar visibility " + newPerspectiveBarVisibility);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window status line visibility " + newStatusLineVis);
                }
                ActiveShellSourceProvider.this.fireSourceChanged(sourceFlags, sourceValuesByName);
                ActiveShellSourceProvider.this.hookListener(ActiveShellSourceProvider.this.lastActiveWorkbenchWindow, newActiveWorkbenchWindow);
            } else if (shellChanged) {
                if (ActiveShellSourceProvider.access$9()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active shell changed to " + newActiveShell);
                }
                ActiveShellSourceProvider.this.fireSourceChanged(1024, "activeShell", newActiveShell);
            } else if (windowChanged) {
                HashMap<String, Object> sourceValuesByName = new HashMap<String, Object>(4);
                sourceValuesByName.put("activeWorkbenchWindow", newActiveWorkbenchWindow);
                sourceValuesByName.put("activeWorkbenchWindowShell", newActiveWorkbenchWindowShell);
                int sourceFlags = 17408;
                if (coolbarChanged) {
                    sourceValuesByName.put("activeWorkbenchWindow.isCoolbarVisible", newCoolbarVisibility);
                    sourceFlags |= 0x8000;
                }
                if (statusLineChanged) {
                    sourceValuesByName.put(ActiveShellSourceProvider.STATUS_LINE_VIS, newStatusLineVis);
                    sourceFlags |= 0x8000;
                }
                if (perspectiveBarChanged) {
                    sourceValuesByName.put("activeWorkbenchWindow.isPerspectiveBarVisible", newPerspectiveBarVisibility);
                    sourceFlags |= 0x8000;
                }
                if (perspectiveIdChanged) {
                    sourceValuesByName.put("activeWorkbenchWindow.activePerspective", perspectiveId);
                    sourceFlags |= 0x8000;
                }
                if (ActiveShellSourceProvider.access$9()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window changed to " + newActiveWorkbenchWindow);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window shell changed to " + newActiveWorkbenchWindowShell);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window coolbar visibility " + newCoolbarVisibility);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window perspective bar visibility " + newPerspectiveBarVisibility);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window status line visibility " + newStatusLineVis);
                }
                ActiveShellSourceProvider.this.fireSourceChanged(sourceFlags, sourceValuesByName);
                ActiveShellSourceProvider.this.hookListener(ActiveShellSourceProvider.this.lastActiveWorkbenchWindow, newActiveWorkbenchWindow);
            }
            ActiveShellSourceProvider.this.lastActiveShell = newActiveShell;
            ActiveShellSourceProvider.this.lastActiveWorkbenchWindowShell = newActiveWorkbenchWindowShell;
            ActiveShellSourceProvider.this.lastActiveWorkbenchWindow = newActiveWorkbenchWindow;
            ActiveShellSourceProvider.this.lastCoolbarVisibility = newCoolbarVisibility;
            ActiveShellSourceProvider.this.lastStatusLineVisibility = newStatusLineVis;
            ActiveShellSourceProvider.this.lastPerspectiveBarVisibility = newPerspectiveBarVisibility;
            ActiveShellSourceProvider.this.lastPerspectiveId = perspectiveId;
        }
    };
    private IWorkbench workbench;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public final void dispose() {
        this.display.removeFilter(26, this.listener);
        this.hookListener(this.lastActiveWorkbenchWindow, null);
        this.lastActiveWorkbenchWindow = null;
        this.lastActiveWorkbenchWindowShell = null;
        this.lastActiveShell = null;
    }

    public final Map getCurrentState() {
        IContextService contextService;
        int shellType;
        HashMap<String, Object> currentState = new HashMap<String, Object>(4);
        Shell newActiveShell = this.display.getActiveShell();
        currentState.put("activeShell", newActiveShell);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((shellType = (contextService = (IContextService)this.workbench.getService(clazz)).getShellType(newActiveShell)) != 0) {
            IPerspectiveDescriptor perspective;
            IWorkbenchPage activePage;
            Boolean newPerspectiveBarVisibility;
            Boolean newCoolbarVisibility;
            WorkbenchWindow newActiveWorkbenchWindow = (WorkbenchWindow)this.workbench.getActiveWorkbenchWindow();
            Shell newActiveWorkbenchWindowShell = newActiveWorkbenchWindow == null ? null : newActiveWorkbenchWindow.getShell();
            currentState.put("activeWorkbenchWindow", newActiveWorkbenchWindow);
            currentState.put("activeWorkbenchWindowShell", newActiveWorkbenchWindowShell);
            Boolean bl = newActiveWorkbenchWindow == null ? this.lastCoolbarVisibility : (newCoolbarVisibility = newActiveWorkbenchWindow.getCoolBarVisible() ? Boolean.TRUE : Boolean.FALSE);
            Boolean bl2 = newActiveWorkbenchWindow == null ? this.lastPerspectiveBarVisibility : (newPerspectiveBarVisibility = newActiveWorkbenchWindow.getPerspectiveBarVisible() ? Boolean.TRUE : Boolean.FALSE);
            Boolean newStatusLineVis = newActiveWorkbenchWindow == null ? this.lastStatusLineVisibility : (newActiveWorkbenchWindow.getStatusLineVisible() ? Boolean.TRUE : Boolean.FALSE);
            String perspectiveId = this.lastPerspectiveId;
            if (newActiveWorkbenchWindow != null && (activePage = newActiveWorkbenchWindow.getActivePage()) != null && (perspective = activePage.getPerspective()) != null) {
                perspectiveId = perspective.getId();
            }
            currentState.put("activeWorkbenchWindow.isCoolbarVisible", newCoolbarVisibility);
            currentState.put("activeWorkbenchWindow.isPerspectiveBarVisible", newPerspectiveBarVisibility);
            currentState.put(STATUS_LINE_VIS, newStatusLineVis);
            currentState.put("activeWorkbenchWindow.activePerspective", perspectiveId);
        }
        return currentState;
    }

    public final String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    private void hookListener(WorkbenchWindow lastActiveWorkbenchWindow, WorkbenchWindow newActiveWorkbenchWindow) {
        if (lastActiveWorkbenchWindow != null) {
            lastActiveWorkbenchWindow.removePropertyChangeListener(this.propertyListener);
            lastActiveWorkbenchWindow.removePerspectiveListener(this.perspectiveListener);
        }
        if (newActiveWorkbenchWindow != null) {
            newActiveWorkbenchWindow.addPropertyChangeListener(this.propertyListener);
            newActiveWorkbenchWindow.addPerspectiveListener(this.perspectiveListener);
        }
    }

    public void initialize(IServiceLocator locator) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.internal.services.IWorkbenchLocationService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWorkbenchLocationService wls = (IWorkbenchLocationService)locator.getService(clazz);
        this.workbench = wls.getWorkbench();
        this.display = this.workbench.getDisplay();
        this.display.addFilter(26, this.listener);
    }

    static /* synthetic */ boolean access$9() {
        return AbstractSourceProvider.DEBUG;
    }
}

