/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class ObjectSerializer {
    public static final int MAX_DEPTH = 3;

    public static String serialize(Object object) {
        StringBuffer sb = new StringBuffer();
        try {
            ObjectSerializer._serialize(object, sb, 0);
        }
        catch (RuntimeException e) {
            System.out.println(String.valueOf(e.getClass().getName()) + ": " + object.getClass().getName());
            return "11 UNAVAILABLE";
        }
        return sb.toString();
    }

    public static String escape(String string) {
        StringBuffer s = new StringBuffer(string);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\n' || c == '\r' || c == ';') {
                s.setCharAt(i, '#');
            }
            ++i;
        }
        return s.toString();
    }

    protected static void _serialize(Object object, StringBuffer sb, int depth) {
        ++depth;
        if (object == null) {
            sb.append("4 null");
            return;
        }
        String clazz = object.getClass().getName();
        if (clazz.startsWith("java.lang")) {
            String value = ObjectSerializer.escape(object.toString());
            sb.append(value.length()).append(" ").append(value);
            return;
        }
        if (depth > 3) {
            String value = ObjectSerializer.escape(object.getClass().getName());
            sb.append(value.length()).append(" ").append(value);
            return;
        }
        if (object.getClass().isArray()) {
            ObjectSerializer.serializeArray(object, sb, depth);
            return;
        }
        ObjectSerializer.serializeObjectFields(object, sb, depth);
    }

    protected static void serializeArray(Object array, StringBuffer sb, int depth) {
        if (array instanceof boolean[]) {
            ObjectSerializer.serialize((boolean[])array, sb);
            return;
        }
        if (array instanceof byte[]) {
            ObjectSerializer.serialize((byte[])array, sb);
            return;
        }
        if (array instanceof char[]) {
            ObjectSerializer.serialize((char[])array, sb);
            return;
        }
        if (array instanceof long[]) {
            ObjectSerializer.serialize((long[])array, sb);
            return;
        }
        if (array instanceof short[]) {
            ObjectSerializer.serialize((short[])array, sb);
            return;
        }
        if (array instanceof int[]) {
            ObjectSerializer.serialize((int[])array, sb);
            return;
        }
        if (array instanceof float[]) {
            ObjectSerializer.serialize((float[])array, sb);
            return;
        }
        if (array instanceof double[]) {
            ObjectSerializer.serialize((double[])array, sb);
            return;
        }
        if (array instanceof int[]) {
            ObjectSerializer.serialize((int[])array, sb);
            return;
        }
        if (array instanceof Object[]) {
            ObjectSerializer.serialize((Object[])array, sb, depth);
            return;
        }
    }

    protected static void serializeObjectFields(Object object, StringBuffer sb, int depth) {
        Field[] fields = object.getClass().getDeclaredFields();
        sb.append(object.getClass().getName());
        ArrayList<Field> nonFinal = new ArrayList<Field>();
        int i = 0;
        while (i < fields.length) {
            Field f = fields[i];
            f.setAccessible(true);
            int m = f.getModifiers();
            if (!Modifier.isFinal(m)) {
                nonFinal.add(f);
            }
            ++i;
        }
        sb.append(" ").append(nonFinal.size());
        for (Field f : nonFinal) {
            sb.append(" ").append(f.getName()).append(" ");
            try {
                ObjectSerializer._serialize(f.get(object), sb, depth);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                sb.append("IllegalArgumentException");
            }
            catch (IllegalAccessException illegalAccessException) {
                sb.append("IllegalAccessException");
            }
        }
    }

    public static String serialize(boolean boolean1) {
        String value = Boolean.toString(boolean1);
        return String.valueOf(value.length()) + " " + value;
    }

    public static String serialize(byte byte1) {
        String value = Byte.toString(byte1);
        return String.valueOf(value.length()) + " " + value;
    }

    public static String serialize(char char1) {
        String value = Character.toString(char1);
        return String.valueOf(value.length()) + " " + value;
    }

    public static String serialize(long long1) {
        String value = Long.toString(long1);
        return String.valueOf(value.length()) + " " + value;
    }

    public static String serialize(short short1) {
        String value = Short.toString(short1);
        return String.valueOf(value.length()) + " " + value;
    }

    public static String serialize(int int1) {
        String value = Integer.toString(int1);
        return String.valueOf(value.length()) + " " + value;
    }

    public static String serialize(float float1) {
        String value = Float.toString(float1);
        return String.valueOf(value.length()) + " " + value;
    }

    public static String serialize(double double1) {
        String value = Double.toString(double1);
        return String.valueOf(value.length()) + " " + value;
    }

    protected static void serialize(boolean[] array, StringBuffer sb) {
        if (array == null) {
            sb.append("4 null");
            return;
        }
        if (array.length == 0) {
            sb.append("2 []");
            return;
        }
        StringBuffer value = new StringBuffer();
        value.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            value.append(", ").append(array[i]);
            ++i;
        }
        value.append("]");
        sb.append(value.length()).append(" ").append(value);
    }

    protected static void serialize(byte[] array, StringBuffer sb) {
        if (array == null) {
            sb.append("4 null");
            return;
        }
        if (array.length == 0) {
            sb.append("2 []");
            return;
        }
        StringBuffer value = new StringBuffer();
        value.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            value.append(", ").append(array[i]);
            ++i;
        }
        value.append("]");
        sb.append(value.length()).append(" ").append(value);
    }

    protected static void serialize(char[] array, StringBuffer sb) {
        if (array == null) {
            sb.append("4 null");
            return;
        }
        if (array.length == 0) {
            sb.append("2 []");
            return;
        }
        StringBuffer value = new StringBuffer();
        value.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            value.append(", ").append(array[i]);
            ++i;
        }
        value.append("]");
        sb.append(value.length()).append(" ").append(value);
    }

    protected static void serialize(long[] array, StringBuffer sb) {
        if (array == null) {
            sb.append("4 null");
            return;
        }
        if (array.length == 0) {
            sb.append("2 []");
            return;
        }
        StringBuffer value = new StringBuffer();
        value.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            value.append(", ").append(array[i]);
            ++i;
        }
        value.append("]");
        sb.append(value.length()).append(" ").append(value);
    }

    protected static void serialize(short[] array, StringBuffer sb) {
        if (array == null) {
            sb.append("4 null");
            return;
        }
        if (array.length == 0) {
            sb.append("2 []");
            return;
        }
        StringBuffer value = new StringBuffer();
        value.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            value.append(", ").append(array[i]);
            ++i;
        }
        value.append("]");
        sb.append(value.length()).append(" ").append(value);
    }

    protected static void serialize(int[] array, StringBuffer sb) {
        if (array == null) {
            sb.append("4 null");
            return;
        }
        if (array.length == 0) {
            sb.append("2 []");
            return;
        }
        StringBuffer value = new StringBuffer();
        value.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            value.append(", ").append(array[i]);
            ++i;
        }
        value.append("]");
        sb.append(value.length()).append(" ").append(value);
    }

    protected static void serialize(float[] array, StringBuffer sb) {
        if (array == null) {
            sb.append("4 null");
            return;
        }
        if (array.length == 0) {
            sb.append("2 []");
            return;
        }
        StringBuffer value = new StringBuffer();
        value.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            value.append(", ").append(array[i]);
            ++i;
        }
        value.append("]");
        sb.append(value.length()).append(" ").append(value);
    }

    protected static void serialize(double[] array, StringBuffer sb) {
        if (array == null) {
            sb.append("4 null");
            return;
        }
        if (array.length == 0) {
            sb.append("2 []");
            return;
        }
        StringBuffer value = new StringBuffer();
        value.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            value.append(", ").append(array[i]);
            ++i;
        }
        value.append("]");
        sb.append(value.length()).append(" ").append(value);
    }

    protected static void serialize(Object[] array, StringBuffer sb, int depth) {
        if (array == null) {
            sb.append("4 null");
            return;
        }
        if (array.length == 0) {
            sb.append("2 []");
            return;
        }
        StringBuffer value = new StringBuffer();
        value.append("[");
        ObjectSerializer._serialize(array[0], value, depth);
        int i = 1;
        while (i < array.length) {
            value.append(", ");
            ObjectSerializer._serialize(array[i], value, depth);
            ++i;
        }
        value.append("]");
        sb.append(value.length()).append(" ").append(value);
    }
}

