/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.runtime;

import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import org.eclipse.jdt.internal.junit.runner.IClassifiesThrowables;
import org.eclipse.jdt.internal.junit.runner.IListensToTestExecutions;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.MessageSender;
import org.eclipse.jdt.internal.junit.runner.TestExecution;
import pl.poznan.put.qjunit.runtime.MutationInfo;
import pl.poznan.put.qjunit.runtime.MutationTestExecution;
import pl.poznan.put.qjunit.runtime.ObjectSerializer;
import pl.poznan.put.qjunit.runtime.QJUnitTestReference;

public class MutationTestListener
implements TestListener {
    private List results = new ArrayList();
    private String result = null;
    private List messages = new ArrayList();
    private String message = null;
    private boolean fMutationMode = false;
    private MessageSender mutationSender;
    private final IListensToTestExecutions fNotified;
    private final IClassifiesThrowables fClassifier;

    public MutationTestListener(TestExecution execution) {
        this.fNotified = execution.getListener();
        this.fClassifier = execution.getClassifier();
        if (execution instanceof MutationTestExecution) {
            this.mutationSender = ((MutationTestExecution)execution).getMutationSender();
        }
    }

    public void addError(Test test, Throwable t) {
        if (this.fMutationMode) {
            this.result = "error";
            this.message = t.getMessage();
            if (this.message == null || this.message.equals("")) {
                this.message = t.getClass().getName();
            }
        } else {
            this.newReference(test).sendFailure(t, this.fClassifier, "%ERROR  ", this.fNotified);
        }
    }

    public void addFailure(Test test, AssertionFailedError t) {
        if (this.fMutationMode) {
            this.result = "failure";
            this.message = t.getMessage();
            if (this.message == null || this.message.equals("")) {
                this.message = t.getClass().getName();
            }
        } else {
            this.newReference(test).sendFailure((Throwable)t, this.fClassifier, "%FAILED ", this.fNotified);
        }
    }

    public void endTest(Test test) {
        if (this.fMutationMode) {
            this.result = this.result == null ? "ok" : this.result;
            this.message = this.message == null ? " " : ObjectSerializer.escape(this.message);
            this.results.add(this.result);
            this.messages.add(this.message);
            this.result = null;
            this.message = null;
        } else {
            this.fNotified.notifyTestEnded(this.id(test));
        }
    }

    public void startTest(Test test) {
        if (!this.fMutationMode) {
            this.fNotified.notifyTestStarted(this.id(test));
        }
    }

    public void startMutations(Test test) {
        this.fMutationMode = true;
    }

    public void endMutations(Test test, MutationInfo[] infos) {
        this.fMutationMode = false;
        TestCase tc = (TestCase)test;
        if (this.mutationSender == null) {
            return;
        }
        int i = 0;
        while (i < infos.length) {
            MutationInfo info = infos[i];
            String[] infoResults = new String[info.getGenerated().length];
            String[] infoMessages = new String[info.getGenerated().length];
            long[] infoTimings = new long[info.getGenerated().length];
            int j = 0;
            while (j < infoResults.length) {
                infoResults[j] = (String)this.results.remove(0);
                infoMessages[j] = (String)this.messages.remove(0);
                infoTimings[j] = 0L;
                ++j;
            }
            info.setResults(infoResults);
            info.setMessages(infoMessages);
            info.setTiming(infoTimings);
            String message = String.valueOf(tc.getClass().getName()) + ";" + tc.getName() + ";" + info.toString();
            this.mutationSender.sendMessage(message);
            this.mutationSender.flush();
            ++i;
        }
    }

    private ITestIdentifier id(Test test) {
        return this.newReference(test).getIdentifier();
    }

    private QJUnitTestReference newReference(Test test) {
        return new QJUnitTestReference(test);
    }
}

