/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GenerateHashCodeEqualsOperation;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.GenerateHashCodeEqualsDialog;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public final class GenerateHashCodeEqualsAction
extends SelectionDispatchAction {
    private static final String METHODNAME_HASH_CODE = "hashCode";
    private static final String METHODNAME_EQUALS = "equals";
    private CompilationUnitEditor fEditor;
    private CompilationUnit fUnit;
    private ITypeBinding fTypeBinding;
    private IVariableBinding[] fCandidateFields;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GenerateHashCodeEqualsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor));
    }

    public GenerateHashCodeEqualsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.GenerateHashCodeEqualsAction_label);
        this.setDescription(ActionMessages.GenerateHashCodeEqualsAction_description);
        this.setToolTipText(ActionMessages.GenerateHashCodeEqualsAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.add_hashcode_equals_action_context");
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof IType) {
                IType type = (IType)element;
                return type.getCompilationUnit() != null && type.isClass();
            }
            if (element instanceof ICompilationUnit) {
                return true;
            }
        }
        return false;
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaModelException {
        ICompilationUnit unit;
        IType type;
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type2 = (IType)selection.getFirstElement();
            if (type2.getCompilationUnit() != null && type2.isClass()) {
                return type2;
            }
        } else if (selection.getFirstElement() instanceof ICompilationUnit && (type = (unit = (ICompilationUnit)selection.getFirstElement()).findPrimaryType()) != null && type.isClass()) {
            return type;
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        try {
            this.checkAndRun(this.getSelectedType(selection));
        }
        catch (CoreException exception) {
            ExceptionHandler.handle(exception, this.getShell(), ActionMessages.GenerateHashCodeEqualsAction_error_caption, ActionMessages.GenerateHashCodeEqualsAction_error_cannot_create);
        }
    }

    public void run(ITextSelection selection) {
        try {
            this.checkAndRun(SelectionConverter.getTypeAtOffset(this.fEditor));
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.GenerateHashCodeEqualsAction_error_caption, ActionMessages.GenerateHashCodeEqualsAction_error_cannot_create);
        }
    }

    private void checkAndRun(IType type) throws CoreException {
        if (type == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateHashCodeEqualsAction_error_caption, (String)ActionMessages.GenerateHashCodeEqualsAction_error_not_applicable);
            this.notifyResult(false);
        }
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), ActionMessages.GenerateHashCodeEqualsAction_error_caption, false) || !ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)type)) {
            this.notifyResult(false);
            return;
        }
        if (type == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.GenerateHashCodeEqualsAction_error_caption, (String)ActionMessages.GenerateHashCodeEqualsAction_error_removed_type);
            this.notifyResult(false);
            return;
        }
        if (type.isAnnotation()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateHashCodeEqualsAction_error_caption, (String)ActionMessages.GenerateHashCodeEqualsAction_annotation_not_applicable);
            this.notifyResult(false);
            return;
        }
        if (type.isInterface()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateHashCodeEqualsAction_error_caption, (String)ActionMessages.GenerateHashCodeEqualsAction_interface_not_applicable);
            this.notifyResult(false);
            return;
        }
        if (type.isEnum()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateHashCodeEqualsAction_error_caption, (String)ActionMessages.GenerateHashCodeEqualsAction_enum_not_applicable);
            this.notifyResult(false);
            return;
        }
        if (type.isAnonymous()) {
            MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.GenerateHashCodeEqualsAction_error_caption, (String)ActionMessages.GenerateHashCodeEqualsAction_anonymous_type_not_applicable);
            this.notifyResult(false);
            return;
        }
        this.run(this.getShell(), type);
    }

    private void run(Shell shell, IType type) throws CoreException {
        int dialogResult;
        block30: {
            IVariableBinding[] selectedFieldBindings;
            this.initialize(type);
            boolean regenerate = false;
            if (this.hasHashCodeOrEquals(this.fTypeBinding) && !(regenerate = MessageDialog.openQuestion((Shell)this.getShell(), (String)ActionMessages.GenerateHashCodeEqualsAction_error_caption, (String)Messages.format(ActionMessages.GenerateHashCodeEqualsAction_already_has_hashCode_equals_error, this.fTypeBinding.getQualifiedName())))) {
                this.notifyResult(false);
                return;
            }
            ArrayList<IVariableBinding> allFields = new ArrayList<IVariableBinding>();
            ArrayList<IVariableBinding> selectedFields = new ArrayList<IVariableBinding>();
            int i = 0;
            while (i < this.fCandidateFields.length) {
                if (!Modifier.isStatic((int)this.fCandidateFields[i].getModifiers())) {
                    allFields.add(this.fCandidateFields[i]);
                    if (!Modifier.isTransient((int)this.fCandidateFields[i].getModifiers())) {
                        selectedFields.add(this.fCandidateFields[i]);
                    }
                }
                ++i;
            }
            if (allFields.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateHashCodeEqualsAction_error_caption, (String)ActionMessages.GenerateHashCodeEqualsAction_no_nonstatic_fields_error);
                this.notifyResult(false);
                return;
            }
            IVariableBinding[] allFieldBindings = allFields.toArray(new IVariableBinding[0]);
            GenerateHashCodeEqualsDialog dialog = new GenerateHashCodeEqualsDialog(shell, this.fEditor, type, allFieldBindings, selectedFieldBindings = selectedFields.toArray(new IVariableBinding[0]));
            dialogResult = dialog.open();
            if (dialogResult == 0) {
                IRewriteTarget target;
                IRewriteTarget iRewriteTarget;
                Dialog d;
                Object[] selected = dialog.getResult();
                if (selected == null) {
                    this.notifyResult(false);
                    return;
                }
                IVariableBinding[] selectedBindings = Arrays.asList(selected).toArray(new IVariableBinding[0]);
                ITypeBinding superclass = this.fTypeBinding.getSuperclass();
                RefactoringStatus status = new RefactoringStatus();
                ArrayList<ITypeBinding> alreadyChecked = new ArrayList<ITypeBinding>();
                if (!"java.lang.Object".equals(superclass.getQualifiedName())) {
                    status.merge(this.checkHashCodeEqualsExists(superclass, true));
                }
                int i2 = 0;
                while (i2 < selectedBindings.length) {
                    ITypeBinding fieldsType = selectedBindings[i2].getType();
                    if (fieldsType.isArray()) {
                        fieldsType = fieldsType.getElementType();
                    }
                    if (!(fieldsType.isPrimitive() || fieldsType.isEnum() || alreadyChecked.contains(fieldsType) || fieldsType.equals((Object)this.fTypeBinding))) {
                        status.merge(this.checkHashCodeEqualsExists(fieldsType, false));
                        alreadyChecked.add(fieldsType);
                    }
                    if (Modifier.isTransient((int)selectedBindings[i2].getModifiers())) {
                        status.addWarning(Messages.format(ActionMessages.GenerateHashCodeEqualsAction_transient_field_included_error, selectedBindings[i2].getName()), GenerateHashCodeEqualsAction.createRefactoringStatusContext(selectedBindings[i2].getJavaElement()));
                    }
                    ++i2;
                }
                if (status.hasEntries() && (d = RefactoringUI.createLightWeightStatusDialog((RefactoringStatus)status, (Shell)this.getShell(), (String)ActionMessages.GenerateHashCodeEqualsAction_error_caption)).open() != 0) {
                    this.notifyResult(false);
                    return;
                }
                CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject());
                settings.createComments = dialog.getGenerateComment();
                IEditorPart editor = JavaUI.openInEditor((IJavaElement)type.getCompilationUnit());
                if (editor != null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iRewriteTarget = (IRewriteTarget)editor.getAdapter((Class)clazz);
                } else {
                    iRewriteTarget = target = null;
                }
                if (target != null) {
                    target.beginCompoundChange();
                }
                try {
                    GenerateHashCodeEqualsOperation operation = new GenerateHashCodeEqualsOperation(this.fTypeBinding, selectedBindings, this.fUnit, dialog.getElementPosition(), settings, dialog.isUseInstanceOf(), regenerate, true, false);
                    operation.setUseBlocksForThen(this.useBlocks(type.getJavaProject()));
                    Object context = JavaPlugin.getActiveWorkbenchWindow();
                    if (context == null) {
                        context = new BusyIndicatorRunnableContext();
                    }
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation, operation.getSchedulingRule()), operation.getSchedulingRule());
                }
                catch (InvocationTargetException exception) {
                    ExceptionHandler.handle(exception, shell, ActionMessages.GenerateHashCodeEqualsAction_error_caption, null);
                    if (target != null) {
                        target.endCompoundChange();
                    }
                    break block30;
                }
                catch (InterruptedException interruptedException) {
                    try {
                        break block30;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (target != null) {
                            target.endCompoundChange();
                        }
                    }
                }
                if (target == null) break block30;
                target.endCompoundChange();
            }
        }
        this.notifyResult(dialogResult == 0);
    }

    private boolean useBlocks(IJavaProject project) {
        if ("true".equals(PreferenceConstants.getPreference("cleanup.use_blocks", project))) {
            return "true".equals(PreferenceConstants.getPreference("cleanup.always_use_blocks", project));
        }
        return false;
    }

    private static RefactoringStatusContext createRefactoringStatusContext(IJavaElement element) {
        if (element instanceof IMember) {
            return JavaStatusContext.create((IMember)element);
        }
        if (element instanceof ISourceReference) {
            IOpenable openable = element.getOpenable();
            try {
                if (openable instanceof ICompilationUnit) {
                    return JavaStatusContext.create((ITypeRoot)((ICompilationUnit)openable), ((ISourceReference)element).getSourceRange());
                }
                if (openable instanceof IClassFile) {
                    return JavaStatusContext.create((ITypeRoot)((IClassFile)openable), ((ISourceReference)element).getSourceRange());
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    private boolean hasHashCodeOrEquals(ITypeBinding someType) {
        HashCodeEqualsInfo info = this.getTypeInfo(someType);
        return info.foundEquals || info.foundHashCode;
    }

    private RefactoringStatus checkHashCodeEqualsExists(ITypeBinding someType, boolean superClass) {
        RefactoringStatus status = new RefactoringStatus();
        HashCodeEqualsInfo info = this.getTypeInfo(someType);
        String concreteTypeWarning = superClass ? ActionMessages.GenerateHashCodeEqualsAction_super_class : ActionMessages.GenerateHashCodeEqualsAction_field_type;
        String concreteMethWarning = someType.isInterface() || Modifier.isAbstract((int)someType.getModifiers()) ? ActionMessages.GenerateHashCodeEqualsAction_interface_does_not_declare_hashCode_equals_error : ActionMessages.GenerateHashCodeEqualsAction_type_does_not_implement_hashCode_equals_error;
        String concreteHCEWarning = null;
        if (!info.foundEquals && !info.foundHashCode) {
            concreteHCEWarning = ActionMessages.GenerateHashCodeEqualsAction_equals_and_hashCode;
        } else if (!info.foundEquals) {
            concreteHCEWarning = ActionMessages.GenerateHashCodeEqualsAction_equals;
        } else if (!info.foundHashCode) {
            concreteHCEWarning = ActionMessages.GenerateHashCodeEqualsAction_hashCode;
        }
        if (!info.foundEquals && !info.foundHashCode) {
            status.addWarning(Messages.format(concreteMethWarning, new String[]{Messages.format(concreteTypeWarning, BindingLabelProvider.getBindingLabel((IBinding)someType, JavaElementLabels.ALL_FULLY_QUALIFIED)), concreteHCEWarning}), GenerateHashCodeEqualsAction.createRefactoringStatusContext(someType.getJavaElement()));
        }
        if (superClass && (info.foundFinalEquals || info.foundFinalHashCode)) {
            status.addError(Messages.format(ActionMessages.GenerateHashCodeEqualsAction_final_hashCode_equals_in_superclass_error, Messages.format(concreteTypeWarning, someType.getQualifiedName())), GenerateHashCodeEqualsAction.createRefactoringStatusContext(someType.getJavaElement()));
        }
        return status;
    }

    private HashCodeEqualsInfo getTypeInfo(ITypeBinding someType) {
        HashCodeEqualsInfo info = new HashCodeEqualsInfo();
        if (someType.isTypeVariable()) {
            someType = someType.getErasure();
        }
        IMethodBinding[] declaredMethods = someType.getDeclaredMethods();
        int i = 0;
        while (i < declaredMethods.length) {
            ITypeBinding[] b;
            if (declaredMethods[i].getName().equals(METHODNAME_EQUALS) && (b = declaredMethods[i].getParameterTypes()).length == 1 && b[0].getQualifiedName().equals("java.lang.Object")) {
                info.foundEquals = true;
                if (Modifier.isFinal((int)declaredMethods[i].getModifiers())) {
                    info.foundFinalEquals = true;
                }
            }
            if (declaredMethods[i].getName().equals(METHODNAME_HASH_CODE) && declaredMethods[i].getParameterTypes().length == 0) {
                info.foundHashCode = true;
                if (Modifier.isFinal((int)declaredMethods[i].getModifiers())) {
                    info.foundFinalHashCode = true;
                }
            }
            if (info.foundEquals && info.foundHashCode) break;
            ++i;
        }
        return info;
    }

    private void initialize(IType type) throws JavaModelException {
        AbstractTypeDeclaration declaration;
        RefactoringASTParser parser = new RefactoringASTParser(3);
        this.fUnit = parser.parse((ITypeRoot)type.getCompilationUnit(), true);
        this.fTypeBinding = null;
        ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fUnit, type.getNameRange());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((declaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null) {
            this.fTypeBinding = declaration.resolveBinding();
        }
        this.fCandidateFields = this.fTypeBinding.getDeclaredFields();
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException exception) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)exception))) {
                JavaPlugin.log(exception);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }

    private class HashCodeEqualsInfo {
        public boolean foundHashCode = false;
        public boolean foundEquals = false;
        public boolean foundFinalHashCode = false;
        public boolean foundFinalEquals = false;

        private HashCodeEqualsInfo() {
        }
    }
}

