/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.internal.ui.actions.CopyQualifiedNameAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CutAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.DeleteAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.PasteAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class CCPActionGroup
extends ActionGroup {
    private Clipboard fClipboard;
    private SelectionDispatchAction[] fActions;
    private SelectionDispatchAction fDeleteAction;
    private SelectionDispatchAction fCopyAction;
    private SelectionDispatchAction fCopyQualifiedNameAction;
    private SelectionDispatchAction fPasteAction;
    private SelectionDispatchAction fCutAction;
    private final ISelectionProvider fSelectionProvider;

    public CCPActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), null);
    }

    public CCPActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public CCPActionGroup(IWorkbenchSite site, ISelectionProvider specialSelectionProvider) {
        this.fSelectionProvider = specialSelectionProvider == null ? site.getSelectionProvider() : specialSelectionProvider;
        this.fClipboard = new Clipboard(site.getShell().getDisplay());
        this.fPasteAction = new PasteAction(site, this.fClipboard);
        this.fPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.fCopyAction = new CopyToClipboardAction(site, this.fClipboard);
        this.fCopyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fCopyQualifiedNameAction = new CopyQualifiedNameAction(site);
        this.fCopyQualifiedNameAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.copy.qualified.name");
        this.fCutAction = new CutAction(site, this.fClipboard);
        this.fCutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.fDeleteAction = new DeleteAction(site);
        this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.fActions = new SelectionDispatchAction[]{this.fCutAction, this.fCopyAction, this.fCopyQualifiedNameAction, this.fPasteAction, this.fDeleteAction};
        if (specialSelectionProvider != null) {
            int i = 0;
            while (i < this.fActions.length) {
                this.fActions[i].setSpecialSelectionProvider(specialSelectionProvider);
                ++i;
            }
        }
        this.registerActionsAsSelectionChangeListeners();
    }

    private void registerActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSelectionProvider;
        ISelection selection = provider.getSelection();
        int i = 0;
        while (i < this.fActions.length) {
            SelectionDispatchAction action = this.fActions[i];
            action.update(selection);
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
            ++i;
        }
    }

    private void deregisterActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSelectionProvider;
        int i = 0;
        while (i < this.fActions.length) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fActions[i]);
            ++i;
        }
    }

    public IAction getDeleteAction() {
        return this.fDeleteAction;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.CopyQualifiedName", (IAction)this.fCopyQualifiedNameAction);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.fCutAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fPasteAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        int i = 0;
        while (i < this.fActions.length) {
            SelectionDispatchAction action = this.fActions[i];
            if (action != this.fCutAction || this.fCutAction.isEnabled()) {
                menu.appendToGroup("group.edit", (IAction)action);
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        this.deregisterActionsAsSelectionChangeListeners();
    }
}

