/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.viewsupport.IRefreshable;
import org.eclipse.jdt.ui.actions.RefreshAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.ide.IDEActionFactory;

public class BuildActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private ISelectionProvider fSelectionProvider;
    private BuildAction fBuildAction;
    private RefreshAction fRefreshAction;

    public BuildActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), null, new RefreshableViewRefreshAction(part));
    }

    public BuildActionGroup(IWorkbenchSite site, ISelectionProvider specialSelectionProvider) {
        this(site, specialSelectionProvider, new RefreshAction(site));
    }

    private BuildActionGroup(IWorkbenchSite site, ISelectionProvider specialSelectionProvider, RefreshAction refreshAction) {
        this.fSite = site;
        this.fSelectionProvider = specialSelectionProvider != null ? specialSelectionProvider : site.getSelectionProvider();
        this.fBuildAction = new BuildAction((IShellProvider)this.fSite, 10);
        this.fBuildAction.setText(ActionMessages.BuildAction_label);
        this.fBuildAction.setActionDefinitionId("org.eclipse.ui.project.buildProject");
        this.fRefreshAction = refreshAction;
        this.fRefreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        if (specialSelectionProvider != null) {
            this.fRefreshAction.setSpecialSelectionProvider(specialSelectionProvider);
        }
        this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fBuildAction);
        this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fRefreshAction);
    }

    public IAction getRefreshAction() {
        return this.fRefreshAction;
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelection selection = this.getContext().getSelection();
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding() && this.isBuildTarget(selection)) {
            this.appendToGroup(menu, (IAction)this.fBuildAction);
        }
        this.appendToGroup(menu, (IAction)this.fRefreshAction);
        super.fillContextMenu(menu);
    }

    public void dispose() {
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fBuildAction);
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fRefreshAction);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
        actionBar.setGlobalActionHandler(IDEActionFactory.BUILD_PROJECT.getId(), (IAction)this.fBuildAction);
        actionBar.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefreshAction);
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.build", action);
        }
    }

    private boolean isBuildTarget(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IJavaProject;
    }

    private static class RefreshableViewRefreshAction
    extends RefreshAction {
        private final IViewPart fPart;

        public RefreshableViewRefreshAction(IViewPart part) {
            super((IWorkbenchSite)part.getSite());
            this.fPart = part;
        }

        public void run(IStructuredSelection selection) {
            super.run(selection);
            if (this.fPart instanceof IRefreshable) {
                ((IRefreshable)this.fPart).refresh(selection);
            }
        }
    }
}

